/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForGenerators;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForShuntCompensators;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForStaticVarCompensators;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForTransformers;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForVscConverters;
import com.powsybl.iidm.network.Network;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;

public class RegulatingControlMapping {
    static final String MISSING_IIDM_TERMINAL = "IIDM terminal for this CGMES terminal: %s";
    private static final String REGULATING_TERMINAL = "Regulating Terminal";
    private static final String REGULATING_CONTROL = "RegulatingControl";
    private static final String TERMINAL = "Terminal";
    private static final String VOLTAGE = "voltage";
    private final Context context;
    private final RegulatingControlMappingForGenerators regulatingControlMappingForGenerators;
    private final RegulatingControlMappingForTransformers regulatingControlMappingForTransformers;
    private final RegulatingControlMappingForShuntCompensators regulatingControlMappingForShuntCompensators;
    private final RegulatingControlMappingForStaticVarCompensators regulatingControlMappingForStaticVarCompensators;
    private final RegulatingControlMappingForVscConverters regulatingControlMappingForVscConverters;
    private Map<String, RegulatingControl> cachedRegulatingControls = new HashMap<String, RegulatingControl>();

    RegulatingControlMapping(Context context) {
        this.context = context;
        this.regulatingControlMappingForGenerators = new RegulatingControlMappingForGenerators(this, context);
        this.regulatingControlMappingForTransformers = new RegulatingControlMappingForTransformers(this, context);
        this.regulatingControlMappingForStaticVarCompensators = new RegulatingControlMappingForStaticVarCompensators(this, context);
        this.regulatingControlMappingForShuntCompensators = new RegulatingControlMappingForShuntCompensators(this, context);
        this.regulatingControlMappingForVscConverters = new RegulatingControlMappingForVscConverters(context);
    }

    public RegulatingControlMappingForGenerators forGenerators() {
        return this.regulatingControlMappingForGenerators;
    }

    public RegulatingControlMappingForTransformers forTransformers() {
        return this.regulatingControlMappingForTransformers;
    }

    public RegulatingControlMappingForShuntCompensators forShuntCompensators() {
        return this.regulatingControlMappingForShuntCompensators;
    }

    public RegulatingControlMappingForStaticVarCompensators forStaticVarCompensators() {
        return this.regulatingControlMappingForStaticVarCompensators;
    }

    public RegulatingControlMappingForVscConverters forVscConverters() {
        return this.regulatingControlMappingForVscConverters;
    }

    public Map<String, RegulatingControl> cachedRegulatingControls() {
        return this.cachedRegulatingControls;
    }

    void cacheRegulatingControls(PropertyBag p) {
        this.cachedRegulatingControls.put(p.getId(REGULATING_CONTROL), new RegulatingControl(p));
    }

    void setAllRegulatingControls(Network network) {
        this.regulatingControlMappingForGenerators.applyRegulatingControls(network);
        this.regulatingControlMappingForTransformers.applyTapChangersRegulatingControl(network);
        this.regulatingControlMappingForShuntCompensators.applyRegulatingControls(network);
        this.regulatingControlMappingForStaticVarCompensators.applyRegulatingControls(network);
        this.regulatingControlMappingForVscConverters.applyRegulatingControls(network);
        this.cachedRegulatingControls.forEach((key, value) -> {
            if (value.correctlySet == null || !value.correctlySet.booleanValue()) {
                this.context.pending(REGULATING_TERMINAL, () -> String.format("The setting of the regulating control %s is not entirely handled.", key));
            }
        });
        this.cachedRegulatingControls.clear();
    }

    static boolean isControlModeVoltage(String controlMode) {
        return controlMode != null && controlMode.endsWith(VOLTAGE);
    }

    static boolean isControlModeReactivePower(String controlMode) {
        return controlMode != null && controlMode.toLowerCase().endsWith("reactivepower");
    }

    static String getRegulatingControlId(PropertyBag p) {
        return p.getId(REGULATING_CONTROL);
    }

    public static class RegulatingControl {
        final String mode;
        final String cgmesTerminal;
        final boolean enabled;
        final double targetValue;
        final double targetDeadband;
        private Boolean correctlySet;

        RegulatingControl(PropertyBag p) {
            this.mode = ((String)p.get((Object)"mode")).toLowerCase();
            this.cgmesTerminal = p.getId(RegulatingControlMapping.TERMINAL);
            this.enabled = p.asBoolean("enabled", true);
            this.targetValue = p.asDouble("targetValue");
            this.targetDeadband = p.asDouble("targetDeadband", 0.0);
        }

        void setCorrectlySet(boolean okSet) {
            if (okSet) {
                if (this.correctlySet != null && !this.correctlySet.booleanValue()) {
                    return;
                }
                this.correctlySet = true;
            } else {
                this.correctlySet = false;
            }
        }

        public double getTargetValue() {
            return this.targetValue;
        }

        public double getTargetDeadBand() {
            return this.targetDeadband;
        }
    }
}

