/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegulatingControlMappingForStaticVarCompensators {
    private final RegulatingControlMapping parent;
    private final Map<String, CgmesRegulatingControlForStaticVarCompensator> mapping;
    private final Context context;
    private static final Logger LOG = LoggerFactory.getLogger(RegulatingControlMappingForStaticVarCompensators.class);

    RegulatingControlMappingForStaticVarCompensators(RegulatingControlMapping parent, Context context) {
        this.parent = parent;
        this.context = context;
        this.mapping = new HashMap<String, CgmesRegulatingControlForStaticVarCompensator>();
    }

    public static void initialize(StaticVarCompensatorAdder adder) {
        adder.setRegulationMode(StaticVarCompensator.RegulationMode.OFF);
    }

    public void add(String iidmId, PropertyBag sm) {
        String rcId = RegulatingControlMapping.getRegulatingControlId(sm);
        boolean controlEnabled = sm.asBoolean("controlEnabled", false);
        double defaultTargetVoltage = sm.asDouble("voltageSetPoint");
        double defaultTargetReactivePower = sm.asDouble("q");
        String defaultRegulationMode = sm.getId("controlMode");
        if (this.mapping.containsKey(iidmId)) {
            throw new CgmesModelException("StaticVarCompensator already added, IIDM StaticVarCompensator Id: " + iidmId);
        }
        CgmesRegulatingControlForStaticVarCompensator rc = new CgmesRegulatingControlForStaticVarCompensator();
        rc.regulatingControlId = rcId;
        rc.controlEnabled = controlEnabled;
        rc.defaultTargetVoltage = defaultTargetVoltage;
        rc.defaultTargetReactivePower = defaultTargetReactivePower;
        rc.defaultRegulationMode = defaultRegulationMode;
        this.mapping.put(iidmId, rc);
    }

    void applyRegulatingControls(Network network) {
        network.getStaticVarCompensatorStream().forEach(this::apply);
    }

    private void apply(StaticVarCompensator svc) {
        CgmesRegulatingControlForStaticVarCompensator rd = this.mapping.get(svc.getId());
        this.apply(svc, rd);
    }

    private void apply(StaticVarCompensator svc, CgmesRegulatingControlForStaticVarCompensator rc) {
        if (rc == null) {
            return;
        }
        String controlId = rc.regulatingControlId;
        if (controlId == null) {
            LOG.trace("Regulating control Id not present for static var compensator {}", (Object)svc.getId());
            this.setDefaultRegulatingControl(rc, svc, false, null);
            return;
        }
        RegulatingControlMapping.RegulatingControl control = this.parent.cachedRegulatingControls().get(controlId);
        if (control == null) {
            this.context.missing(String.format("Regulating control %s", controlId));
            this.setDefaultRegulatingControl(rc, svc, false, null);
            return;
        }
        control.setCorrectlySet(this.setRegulatingControl(rc, control, svc));
    }

    private boolean setRegulatingControl(CgmesRegulatingControlForStaticVarCompensator rc, RegulatingControlMapping.RegulatingControl control, StaticVarCompensator svc) {
        StaticVarCompensator.RegulationMode regulationMode;
        svc.setProperty("CGMES.RegulatingControl", rc.regulatingControlId);
        Terminal regulatingTerminal = RegulatingTerminalMapper.mapForVoltageControl(control.cgmesTerminal, this.context).orElse(svc.getTerminal());
        double targetVoltage = Double.NaN;
        double targetReactivePower = Double.NaN;
        boolean okSet = false;
        if (!control.enabled && rc.controlEnabled) {
            this.context.fixed("SVCControlEnabledStatus", () -> String.format("Regulating control of %s is disabled but controlEnabled property is set to true.Equipment and regulating control properties are used to set local default regulation if local default regulation is reactive power. Else, regulation is disabled.", svc.getId()));
            this.setDefaultRegulatingControl(rc, svc, true, control);
            return false;
        }
        if (RegulatingControlMapping.isControlModeVoltage(control.mode.toLowerCase())) {
            regulationMode = StaticVarCompensator.RegulationMode.VOLTAGE;
            targetVoltage = control.targetValue;
            okSet = true;
        } else if (RegulatingControlMappingForStaticVarCompensators.isControlModeReactivePower(control.mode.toLowerCase())) {
            regulationMode = StaticVarCompensator.RegulationMode.REACTIVE_POWER;
            targetReactivePower = control.targetValue;
            okSet = true;
        } else {
            this.context.fixed("SVCControlMode", () -> String.format("Invalid control mode for static var compensator %s. Regulating control is disabled", svc.getId()));
            regulationMode = StaticVarCompensator.RegulationMode.OFF;
        }
        svc.setVoltageSetpoint(targetVoltage);
        svc.setReactivePowerSetpoint(targetReactivePower);
        if (control.enabled && rc.controlEnabled) {
            svc.setRegulationMode(regulationMode);
        }
        svc.setRegulatingTerminal(regulatingTerminal);
        return okSet;
    }

    private boolean isValidVoltageFromRegulatingControl(RegulatingControlMapping.RegulatingControl control) {
        return control != null && RegulatingControlMapping.isControlModeVoltage(control.mode) && Double.isFinite(control.targetValue) && control.targetValue > 0.0;
    }

    private boolean isValidReactivePowerFromRegulatingControl(RegulatingControlMapping.RegulatingControl control) {
        return control != null && RegulatingControlMapping.isControlModeReactivePower(control.mode) && Double.isFinite(control.targetValue);
    }

    private void setDefaultRegulatingControl(CgmesRegulatingControlForStaticVarCompensator rc, StaticVarCompensator svc, boolean onlyReactivePowerReg, RegulatingControlMapping.RegulatingControl control) {
        StaticVarCompensator.RegulationMode regulationMode;
        double targetVoltage = Double.NaN;
        double targetReactivePower = Double.NaN;
        if (RegulatingControlMapping.isControlModeVoltage(rc.defaultRegulationMode.toLowerCase())) {
            regulationMode = onlyReactivePowerReg ? StaticVarCompensator.RegulationMode.OFF : StaticVarCompensator.RegulationMode.VOLTAGE;
            targetVoltage = this.isValidVoltageFromRegulatingControl(control) ? control.targetValue : rc.defaultTargetVoltage;
        } else if (RegulatingControlMappingForStaticVarCompensators.isControlModeReactivePower(rc.defaultRegulationMode.toLowerCase())) {
            regulationMode = StaticVarCompensator.RegulationMode.REACTIVE_POWER;
            targetReactivePower = this.isValidReactivePowerFromRegulatingControl(control) ? control.targetValue : rc.defaultTargetReactivePower;
        } else {
            this.context.fixed("SVCControlMode", () -> String.format("Invalid control mode for static var compensator %s. Regulating control is disabled", svc.getId()));
            regulationMode = StaticVarCompensator.RegulationMode.OFF;
        }
        svc.setVoltageSetpoint(targetVoltage);
        svc.setReactivePowerSetpoint(targetReactivePower);
        if (rc.controlEnabled) {
            svc.setRegulationMode(regulationMode);
        }
    }

    private static boolean isControlModeReactivePower(String controlMode) {
        return controlMode != null && controlMode.endsWith("reactivepower");
    }

    private static final class CgmesRegulatingControlForStaticVarCompensator {
        String regulatingControlId;
        boolean controlEnabled;
        double defaultTargetVoltage;
        double defaultTargetReactivePower;
        String defaultRegulationMode;

        private CgmesRegulatingControlForStaticVarCompensator() {
        }
    }
}

