/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.ReportRow;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.triplestore.api.PropertyBag;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ReportTapChangers {
    private final CgmesModel cgmes;
    private final Consumer<String> output;
    private final String dataSource;
    private final String modelId;
    private final Map<String, List<PropertyBag>> txTapChangers;
    private final Map<String, List<PropertyBag>> txEnds;
    private final Map<String, String> endTx;

    public ReportTapChangers(CgmesModel cgmes, Consumer<String> output) {
        this.cgmes = cgmes;
        this.output = output;
        Path p = (Path)cgmes.getProperties().get("dataSource");
        String ps = "";
        if (p != null) {
            ps = p.toString().replaceAll("../data", "");
        }
        this.dataSource = ps;
        this.modelId = cgmes.modelId();
        this.txTapChangers = new HashMap<String, List<PropertyBag>>();
        this.txEnds = new HashMap<String, List<PropertyBag>>();
        this.endTx = new HashMap<String, String>();
        ReportRow d = new ReportRow("TapChangerHeader");
        d.col("dataSource");
        d.col("modelId");
        d.col("txId");
        d.col("txName");
        d.col("numEnds (windings)");
        d.col("ratedU1");
        d.col("r1");
        d.col("x1");
        d.col("g1");
        d.col("b1");
        d.col("ratedU2");
        d.col("r2");
        d.col("x2");
        d.col("g2");
        d.col("b2");
        d.col("ratedU3");
        d.col("r3");
        d.col("x3");
        d.col("g3");
        d.col("b3");
        d.col("numTapChangers");
        d.col("sameSteps");
        d.col("numRatioTapChangersEnd1");
        d.col("numPhaseTapChangersEnd1");
        d.col("numRatioTapChangersEnd2");
        d.col("numPhaseTapChangersEnd2");
        d.col("numRatioTapChangersEnd3");
        d.col("numPhaseTapChangersEnd3");
        for (int k = 0; k < 6; ++k) {
            d.col("tapChangerId");
            d.col("end");
            d.col("lowStep");
            d.col("highStep");
            d.col("neutralStep");
            d.col("step");
            d.col("atNeutral");
            d.col("regulating");
        }
        d.end(output);
    }

    private void addTapChanger(PropertyBag tc) {
        String txId = this.transformerId(tc);
        if (txId == null) {
            ReportRow d = new ReportRow("TapChangerError");
            d.col(this.dataSource);
            d.col(this.modelId);
            d.col(this.tcId(tc));
            d.col(txId);
            d.col("Missing Transformer");
            d.end(this.output);
            return;
        }
        List tcs = this.txTapChangers.computeIfAbsent(txId, t -> new ArrayList());
        tcs.add(tc);
    }

    private void addEnd(PropertyBag end) {
        String txId = end.getId("PowerTransformer");
        List ends = this.txEnds.computeIfAbsent(txId, t -> new ArrayList());
        ends.add(end);
        String endId = end.getId("TransformerEnd");
        this.endTx.put(endId, txId);
    }

    void report() {
        this.cgmes.transformerEnds().forEach(this::addEnd);
        this.cgmes.ratioTapChangers().forEach(this::addTapChanger);
        this.cgmes.phaseTapChangers().forEach(this::addTapChanger);
        this.txEnds.keySet().forEach(this::lambda$report$9);
    }

    private String transformerId(PropertyBag tc) {
        String endId = tc.getId("TransformerEnd");
        return this.endTx.get(endId);
    }

    private int end(PropertyBag tc) {
        String endId = tc.getId("TransformerEnd");
        String txId = this.endTx.get(endId);
        List<PropertyBag> txe = this.txEnds.get(txId);
        PropertyBag end = txe.stream().filter(e -> e.getId("TransformerEnd").equals(endId)).reduce((a, b) -> {
            throw new ConversionException("Multiple transformerEnds with id: " + endId);
        }).orElseThrow(() -> new ConversionException("No transformerEnd with id: " + endId));
        int endNumber = end.asInt("terminalSequenceNumber", -1);
        if (endNumber == -1) {
            return end.asInt("endNumber", -1);
        }
        return endNumber;
    }

    private String txName(String txId) {
        List<PropertyBag> txe = this.txEnds.get(txId);
        PropertyBag end = txe.get(0);
        return end.getLocal("name");
    }

    private boolean isRatio(PropertyBag tc) {
        return tc.containsKey((Object)"RatioTapChanger");
    }

    private int steps(PropertyBag tc) {
        int lowStep = tc.asInt("lowStep");
        int highStep = tc.asInt("highStep");
        return highStep - lowStep + 1;
    }

    private boolean isPhase(PropertyBag tc) {
        return tc.containsKey((Object)"PhaseTapChanger");
    }

    private String tcId(PropertyBag tc) {
        return this.isRatio(tc) ? tc.getId("RatioTapChanger") : tc.getId("PhaseTapChanger");
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$report$9(String txId) {
        block5: {
            block4: {
                ends = this.txEnds.get(txId);
                tcs = this.txTapChangers.get(txId);
                d = new ReportRow("TapChanger");
                d.col(this.dataSource);
                d.col(this.modelId);
                d.col(txId);
                d.col(this.txName(txId));
                d.col(ends.size());
                for (k = 0; k < ends.size(); ++k) {
                    end = ends.get(k);
                    d.col(end.asDouble("ratedU"));
                    d.col(end.asDouble("r"));
                    d.col(end.asDouble("x"));
                    d.col(end.asDouble("g"));
                    d.col(end.asDouble("b"));
                }
                while (k < 3) {
                    d.col("-");
                    d.col("-");
                    d.col("-");
                    d.col("-");
                    d.col("-");
                    ++k;
                }
                if (tcs != null) break block4;
                d.col(0);
                break block5;
            }
            rtc1 = tcs.stream().filter((Predicate<PropertyBag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$report$2(com.powsybl.triplestore.api.PropertyBag ), (Lcom/powsybl/triplestore/api/PropertyBag;)Z)((ReportTapChangers)this)).count();
            ptc1 = tcs.stream().filter((Predicate<PropertyBag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$report$3(com.powsybl.triplestore.api.PropertyBag ), (Lcom/powsybl/triplestore/api/PropertyBag;)Z)((ReportTapChangers)this)).count();
            rtc2 = tcs.stream().filter((Predicate<PropertyBag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$report$4(com.powsybl.triplestore.api.PropertyBag ), (Lcom/powsybl/triplestore/api/PropertyBag;)Z)((ReportTapChangers)this)).count();
            ptc2 = tcs.stream().filter((Predicate<PropertyBag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$report$5(com.powsybl.triplestore.api.PropertyBag ), (Lcom/powsybl/triplestore/api/PropertyBag;)Z)((ReportTapChangers)this)).count();
            rtc3 = tcs.stream().filter((Predicate<PropertyBag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$report$6(com.powsybl.triplestore.api.PropertyBag ), (Lcom/powsybl/triplestore/api/PropertyBag;)Z)((ReportTapChangers)this)).count();
            ptc3 = tcs.stream().filter((Predicate<PropertyBag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$report$7(com.powsybl.triplestore.api.PropertyBag ), (Lcom/powsybl/triplestore/api/PropertyBag;)Z)((ReportTapChangers)this)).count();
            steps = tcs.stream().map((Function<PropertyBag, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, steps(com.powsybl.triplestore.api.PropertyBag ), (Lcom/powsybl/triplestore/api/PropertyBag;)Ljava/lang/Integer;)((ReportTapChangers)this)).toList();
            if (steps.isEmpty()) ** GOTO lbl-1000
            if (steps.stream().allMatch((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/Integer;)Z)((Integer)steps.get(0)))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            sameSteps = v0;
            d.col(tcs.size());
            d.col(sameSteps);
            d.col(rtc1);
            d.col(ptc1);
            d.col(rtc2);
            d.col(ptc2);
            d.col(rtc3);
            d.col(ptc3);
            tcs.forEach((Consumer<PropertyBag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$report$8(com.powsybl.cgmes.conversion.ReportRow com.powsybl.triplestore.api.PropertyBag ), (Lcom/powsybl/triplestore/api/PropertyBag;)V)((ReportTapChangers)this, (ReportRow)d));
        }
        d.end(this.output);
    }

    private /* synthetic */ void lambda$report$8(ReportRow d, PropertyBag tc) {
        int step;
        String tcId = this.tcId(tc);
        int lowStep = tc.asInt("lowStep");
        int highStep = tc.asInt("highStep");
        int neutralStep = tc.asInt("neutralStep");
        boolean atNeutral = neutralStep == (step = (int)tc.asDouble("SVtapStep", (double)neutralStep));
        boolean regulating = tc.asBoolean("regulatingControlEnabled", false);
        d.col(tcId);
        d.col(this.end(tc));
        d.col(lowStep);
        d.col(highStep);
        d.col(neutralStep);
        d.col(step);
        d.col(atNeutral);
        d.col(regulating);
    }

    private /* synthetic */ boolean lambda$report$7(PropertyBag tc) {
        return this.end(tc) == 3 && this.isPhase(tc);
    }

    private /* synthetic */ boolean lambda$report$6(PropertyBag tc) {
        return this.end(tc) == 3 && this.isRatio(tc);
    }

    private /* synthetic */ boolean lambda$report$5(PropertyBag tc) {
        return this.end(tc) == 2 && this.isPhase(tc);
    }

    private /* synthetic */ boolean lambda$report$4(PropertyBag tc) {
        return this.end(tc) == 2 && this.isRatio(tc);
    }

    private /* synthetic */ boolean lambda$report$3(PropertyBag tc) {
        return this.end(tc) == 1 && this.isPhase(tc);
    }

    private /* synthetic */ boolean lambda$report$2(PropertyBag tc) {
        return this.end(tc) == 1 && this.isRatio(tc);
    }
}

