/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.commons.PowsyblException;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstationIdMapping {
    private final Context context;
    private final Map<String, String> substationMapping;
    private final Map<String, String> voltageLevelMapping;
    private static final Logger LOG = LoggerFactory.getLogger(SubstationIdMapping.class);

    public SubstationIdMapping(Context context) {
        this.context = context;
        this.substationMapping = new HashMap<String, String>();
        this.voltageLevelMapping = new HashMap<String, String>();
    }

    public boolean substationIsMapped(String cgmesIdentifier) {
        String sid = this.context.namingStrategy().getIidmId("Substation", cgmesIdentifier);
        return this.substationMapping.containsKey(sid);
    }

    public String substationIidm(String cgmesIdentifier) {
        String sid = this.context.namingStrategy().getIidmId("Substation", cgmesIdentifier);
        if (this.substationMapping.containsKey(sid)) {
            return this.substationMapping.get(sid);
        }
        return sid;
    }

    public Set<String> mergedSubstations(String cgmesIdentifier) {
        String sid = this.context.namingStrategy().getIidmId("Substation", cgmesIdentifier);
        return this.substationMapping.entrySet().stream().filter(r -> ((String)r.getValue()).equals(sid)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean voltageLevelIsMapped(String cgmesIdentifier) {
        String vlid = this.context.namingStrategy().getIidmId("VoltageLevel", cgmesIdentifier);
        return this.voltageLevelMapping.containsKey(vlid);
    }

    public String voltageLevelIidm(String cgmesIdentifier) {
        String vlid = this.context.namingStrategy().getIidmId("VoltageLevel", cgmesIdentifier);
        if (this.voltageLevelMapping.containsKey(vlid)) {
            return this.voltageLevelMapping.get(vlid);
        }
        return vlid;
    }

    public Set<String> mergedVoltageLevels(String cgmesIdentifier) {
        String vlid = this.context.namingStrategy().getIidmId("VoltageLevel", cgmesIdentifier);
        return this.voltageLevelMapping.entrySet().stream().filter(r -> ((String)r.getValue()).equals(vlid)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void build() {
        HashMap<String, Set<String>> voltageLevelAdjacency = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> substationAdjacency = new HashMap<String, Set<String>>();
        this.buildAdjacency(voltageLevelAdjacency, substationAdjacency);
        this.buildVoltageLevel(voltageLevelAdjacency);
        this.buildSubstation(substationAdjacency);
    }

    private void buildAdjacency(Map<String, Set<String>> voltageLevelAdjacency, Map<String, Set<String>> substationAdjacency) {
        this.context.cgmes().voltageLevels().forEach(vl -> this.addVoltageLevel(voltageLevelAdjacency, (PropertyBag)vl));
        this.context.cgmes().substations().forEach(st -> this.addSubstation(substationAdjacency, (PropertyBag)st));
        this.context.cgmes().switches().forEach(sw -> this.addSwitch(voltageLevelAdjacency, substationAdjacency, (PropertyBag)sw));
        this.context.cgmes().groupedTransformerEnds().forEach((t, tends) -> this.addEnds(substationAdjacency, (PropertyBags)tends));
    }

    private void addVoltageLevel(Map<String, Set<String>> voltageLevelAdjacency, PropertyBag vl) {
        String voltageLevelId = vl.getId("VoltageLevel");
        String vId = this.context.namingStrategy().getIidmId("VoltageLevel", voltageLevelId);
        voltageLevelAdjacency.put(vId, new HashSet());
    }

    private void addSubstation(Map<String, Set<String>> substationAdjacency, PropertyBag sub) {
        String substationlId = sub.getId("Substation");
        String subId = this.context.namingStrategy().getIidmId("Substation", substationlId);
        substationAdjacency.put(subId, new HashSet());
    }

    private void addSwitch(Map<String, Set<String>> voltageLevelAdjacency, Map<String, Set<String>> substationAdjacency, PropertyBag sw) {
        CgmesTerminal t1 = this.context.cgmes().terminal(sw.getId("Terminal1"));
        CgmesTerminal t2 = this.context.cgmes().terminal(sw.getId("Terminal2"));
        String voltageLevelId1 = this.context.cgmes().voltageLevel(t1, this.context.nodeBreaker());
        String voltageLevelId2 = this.context.cgmes().voltageLevel(t2, this.context.nodeBreaker());
        if (voltageLevelId1 == null || voltageLevelId2 == null || voltageLevelId1.equals(voltageLevelId2)) {
            return;
        }
        SubstationIdMapping.addAdjacency(voltageLevelAdjacency, voltageLevelId1, voltageLevelId2);
        String substationId1 = this.context.cgmes().substation(t1, this.context.nodeBreaker());
        String substationId2 = this.context.cgmes().substation(t2, this.context.nodeBreaker());
        if (substationId1 == null || substationId2 == null || substationId1.equals(substationId2)) {
            return;
        }
        SubstationIdMapping.addAdjacency(substationAdjacency, substationId1, substationId2);
    }

    private void addEnds(Map<String, Set<String>> substationAdjacency, PropertyBags tends) {
        List<String> substationsIds = this.substationsIds(tends);
        if (substationsIds.size() <= 1) {
            return;
        }
        String sub0 = substationsIds.get(0);
        for (int i = 1; i < substationsIds.size(); ++i) {
            String subi = substationsIds.get(i);
            if (sub0.contentEquals(subi)) continue;
            SubstationIdMapping.addAdjacency(substationAdjacency, sub0, subi);
        }
    }

    private static void addAdjacency(Map<String, Set<String>> adjacency, String id1, String id2) {
        Set<String> ad1 = adjacency.get(id1);
        if (ad1 == null) {
            throw new PowsyblException("Unexpected reference to Substation or voltageLevel " + id1 + ". It has not been defined in CGMES substations / voltageLevels.");
        }
        Set<String> ad2 = adjacency.get(id2);
        if (ad2 == null) {
            throw new PowsyblException("Unexpected reference to Substation or voltageLevel " + id2 + ". It has not been defined in CGMES substations / voltageLevels.");
        }
        ad1.add(id2);
        ad2.add(id1);
    }

    private void buildVoltageLevel(Map<String, Set<String>> voltageLevelAdjacency) {
        HashSet<String> visitedVoltageLevels = new HashSet<String>();
        for (String vl : voltageLevelAdjacency.keySet()) {
            if (visitedVoltageLevels.contains(vl)) continue;
            Set<String> vlAds = SubstationIdMapping.allConnected(voltageLevelAdjacency, visitedVoltageLevels, vl);
            String selectedVoltageLevelId = SubstationIdMapping.representativeVoltageLevelId(vlAds);
            SubstationIdMapping.recordMergedIds(this.voltageLevelMapping, vlAds, selectedVoltageLevelId);
        }
        if (!this.voltageLevelMapping.isEmpty()) {
            LOG.warn("Original {} VoltageLevel container(s) connected by switches have been merged in IIDM. Map of original VoltageLevel to IIDM: {}", (Object)this.voltageLevelMapping.size(), this.voltageLevelMapping);
        }
    }

    private void buildSubstation(Map<String, Set<String>> substationAdjacency) {
        HashSet<String> visitedSubstations = new HashSet<String>();
        for (String sub : substationAdjacency.keySet()) {
            if (visitedSubstations.contains(sub)) continue;
            Set<String> subAds = SubstationIdMapping.allConnected(substationAdjacency, visitedSubstations, sub);
            String selectedSubstationId = this.representativeSubstationId(subAds);
            SubstationIdMapping.recordMergedIds(this.substationMapping, subAds, selectedSubstationId);
        }
        if (!this.substationMapping.isEmpty()) {
            LOG.warn("Original {} Substation container(s) connected by transformers have been merged in IIDM. Map of original Substation to IIDM: {}", (Object)this.substationMapping.size(), this.substationMapping);
        }
    }

    private static Set<String> allConnected(Map<String, Set<String>> adjacency, Set<String> visited, String id) {
        ArrayList<String> allConnected = new ArrayList<String>();
        allConnected.add(id);
        visited.add(id);
        for (int k = 0; k < allConnected.size(); ++k) {
            String vl0 = (String)allConnected.get(k);
            if (!adjacency.containsKey(vl0)) continue;
            adjacency.get(vl0).forEach(ad -> {
                if (visited.contains(ad)) {
                    return;
                }
                allConnected.add((String)ad);
                visited.add((String)ad);
            });
        }
        return new HashSet<String>(allConnected);
    }

    private static String representativeVoltageLevelId(Collection<String> voltageLevelIds) {
        return voltageLevelIds.stream().sorted().findFirst().orElseThrow(() -> new IllegalStateException("Unexpected: voltageLevelIds list is empty"));
    }

    private String representativeSubstationId(Collection<String> substationIds) {
        return substationIds.stream().filter(substationId -> this.context.config().substationIdsExcludedFromMapping().stream().noneMatch(substationId::matches)).sorted().findFirst().orElse(substationIds.iterator().next());
    }

    private static void recordMergedIds(Map<String, String> mapping, Collection<String> mergedIds, String representativeId) {
        for (String id : mergedIds) {
            if (id.equals(representativeId)) continue;
            mapping.put(id, representativeId);
        }
    }

    private List<String> substationsIds(PropertyBags tends) {
        ArrayList<String> substationsIds = new ArrayList<String>();
        for (PropertyBag end : tends) {
            String sid;
            CgmesTerminal t = this.context.cgmes().terminal(end.getId("Terminal"));
            String node = this.context.nodeBreaker() ? t.connectivityNode() : t.topologicalNode();
            if (node == null || this.context.boundary().containsNode(node) || (sid = this.context.cgmes().substation(t, this.context.nodeBreaker())) == null) continue;
            substationsIds.add(this.context.namingStrategy().getIidmId("Substation", sid));
        }
        return substationsIds;
    }
}

