/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TerminalMapping {
    private final Map<String, Terminal> terminals;
    private final Map<String, Boundary> boundaries = new HashMap<String, Boundary>();
    private final Map<String, Integer> terminalNumbers;
    private final Map<String, List<String>> topologicalNodesMapping;
    private final Map<String, String> cgmesTerminalsMapping;

    public TerminalMapping() {
        this.terminals = new HashMap<String, Terminal>();
        this.terminalNumbers = new HashMap<String, Integer>();
        this.topologicalNodesMapping = new HashMap<String, List<String>>();
        this.cgmesTerminalsMapping = new HashMap<String, String>();
    }

    public void add(String cgmesTerminal, Terminal iidmTerminal, int terminalNumber) {
        if (this.terminals.containsKey(cgmesTerminal) || this.boundaries.containsKey(cgmesTerminal)) {
            throw new CgmesModelException("Terminal already added, CGMES id : " + cgmesTerminal);
        }
        this.terminals.put(cgmesTerminal, iidmTerminal);
        this.terminalNumbers.put(cgmesTerminal, terminalNumber);
    }

    public void add(String cgmesTerminal, Boundary iidmBoundary, int terminalNumber) {
        if (this.terminals.containsKey(cgmesTerminal) || this.boundaries.containsKey(cgmesTerminal)) {
            throw new CgmesModelException("Terminal already added, CGMES id : " + cgmesTerminal);
        }
        this.boundaries.put(cgmesTerminal, iidmBoundary);
        this.terminalNumbers.put(cgmesTerminal, terminalNumber);
    }

    public Terminal get(String cgmesTerminalId) {
        if (this.terminals.get(cgmesTerminalId) != null) {
            return this.terminals.get(cgmesTerminalId);
        }
        return null;
    }

    public String getTopologicalNode(String cgmesTerminalId) {
        return this.cgmesTerminalsMapping.get(cgmesTerminalId);
    }

    public Terminal findForFlowLimits(String cgmesTerminalId) {
        return this.terminals.get(cgmesTerminalId);
    }

    public Terminal findForVoltageLimits(String cgmesTerminalId) {
        if (this.terminals.get(cgmesTerminalId) != null) {
            return this.terminals.get(cgmesTerminalId);
        }
        return this.findFromTopologicalNode(this.cgmesTerminalsMapping.get(cgmesTerminalId));
    }

    @Deprecated(since="6.1.2")
    public Terminal find(String cgmesTerminalId, boolean loadingLimits) {
        throw new ConversionException("Deprecated. Not used anymore");
    }

    @Deprecated(since="4.8.0")
    public Terminal find(String cgmesTerminalId, CgmesModel cgmesModel, Network network) {
        throw new ConversionException("Deprecated. Not used anymore");
    }

    public Boundary findBoundary(String cgmesTerminalId) {
        return this.boundaries.get(cgmesTerminalId);
    }

    public Boundary findBoundary(String cgmesTerminalId, CgmesModel cgmesModel) {
        String acLineSegmentCgmesTerminalId;
        CgmesTerminal cgmesTerminal = cgmesModel.terminal(cgmesTerminalId);
        if (cgmesTerminal != null && cgmesTerminal.conductingEquipmentType().equals("EquivalentInjection") && (acLineSegmentCgmesTerminalId = TerminalMapping.findAssociatedAcLineSegmentCgmesTerminalId(cgmesModel, cgmesTerminal)) != null) {
            return this.findBoundary(acLineSegmentCgmesTerminalId);
        }
        return this.findBoundary(cgmesTerminalId);
    }

    private static String findAssociatedAcLineSegmentCgmesTerminalId(CgmesModel cgmesModel, CgmesTerminal cgmesTerminal) {
        CgmesTerminal acLineSegmentCgmesTerminal = cgmesModel.computedTerminals().stream().filter(computedTerminal -> TerminalMapping.cgmesTerminalOk(computedTerminal, cgmesTerminal)).findFirst().orElse(null);
        if (acLineSegmentCgmesTerminal != null) {
            return acLineSegmentCgmesTerminal.id();
        }
        return null;
    }

    private static boolean cgmesTerminalOk(CgmesTerminal acLineSegmentCgmesTerminal, CgmesTerminal cgmesTerminal) {
        if (!acLineSegmentCgmesTerminal.conductingEquipmentType().equals("ACLineSegment")) {
            return false;
        }
        if (acLineSegmentCgmesTerminal.connectivityNode() != null && acLineSegmentCgmesTerminal.connectivityNode().equals(cgmesTerminal.connectivityNode())) {
            return true;
        }
        return acLineSegmentCgmesTerminal.topologicalNode() != null && acLineSegmentCgmesTerminal.topologicalNode().equals(cgmesTerminal.topologicalNode());
    }

    public int number(String cgmesTerminalId) {
        if (this.terminalNumbers.get(cgmesTerminalId) != null) {
            return this.terminalNumbers.get(cgmesTerminalId);
        }
        return -1;
    }

    public void buildTopologicalNodeCgmesTerminalsMapping(CgmesTerminal t) {
        String tp = t.topologicalNode();
        if (tp != null) {
            this.topologicalNodesMapping.computeIfAbsent(tp, tpnode -> new ArrayList()).add(t.id());
            this.cgmesTerminalsMapping.put(t.id(), tp);
        }
    }

    public boolean areAssociated(String cgmesTerminalId, String topologicalNode) {
        return this.topologicalNodesMapping.get(topologicalNode).contains(cgmesTerminalId);
    }

    public Terminal findFromTopologicalNode(String topologicalNode) {
        Terminal disconnectedTerminal = null;
        if (this.topologicalNodesMapping.containsKey(topologicalNode)) {
            for (String cgmesTerminalId : this.topologicalNodesMapping.get(topologicalNode)) {
                Terminal terminal = this.terminals.get(cgmesTerminalId);
                if (terminal == null) continue;
                if (terminal.isConnected()) {
                    return terminal;
                }
                if (disconnectedTerminal != null) continue;
                disconnectedTerminal = terminal;
            }
        }
        return disconnectedTerminal;
    }

    public String findCgmesTerminalFromTopologicalNode(String topologicalNode) {
        return this.topologicalNodesMapping.containsKey(topologicalNode) ? this.topologicalNodesMapping.get(topologicalNode).get(0) : null;
    }
}

