/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBag;

public class BusbarSectionConversion
extends AbstractConductingEquipmentConversion {
    public BusbarSectionConversion(PropertyBag bbs, Context context) {
        super("BusbarSection", bbs, context);
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public void convert() {
        if (this.context.nodeBreaker()) {
            BusbarSectionAdder bbsAdder = (BusbarSectionAdder)((BusbarSectionAdder)((BusbarSectionAdder)this.voltageLevel().getNodeBreakerView().newBusbarSection().setId(this.iidmId())).setName(this.iidmName())).setEnsureIdUnicity(this.context.config().isEnsureIdAliasUnicity());
            bbsAdder.setNode(this.iidmNode());
            BusbarSection bbs = bbsAdder.add();
            this.addAliasesAndProperties((Identifiable<?>)bbs);
            this.convertedTerminals(bbs.getTerminal());
        } else {
            this.addBusbarSectionTerminalToBus();
        }
    }

    private void addBusbarSectionTerminalToBus() {
        Bus bus = this.voltageLevel(1).map(VoltageLevel::getBusBreakerView).map(bbv -> bbv.getBus(this.busId())).orElse(null);
        if (bus != null) {
            Object busbarSectionTerminals = bus.getProperty("CGMES.busbarSectionTerminals", "");
            if (!((String)busbarSectionTerminals).isEmpty()) {
                busbarSectionTerminals = (String)busbarSectionTerminals + ",";
            }
            busbarSectionTerminals = (String)busbarSectionTerminals + this.terminalId();
            bus.setProperty("CGMES.busbarSectionTerminals", (String)busbarSectionTerminals);
        }
    }
}

