/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.triplestore.api.PropertyBag;

public class EnergySourceConversion
extends AbstractConductingEquipmentConversion {
    public EnergySourceConversion(PropertyBag es, Context context) {
        super("EnergySource", es, context);
    }

    @Override
    public void convert() {
        LoadType loadType = this.id.contains("fict") ? LoadType.FICTITIOUS : LoadType.UNDEFINED;
        LoadAdder adder = this.voltageLevel().newLoad().setP0(this.p0()).setQ0(this.q0()).setLoadType(loadType);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect((InjectionAdder<?, ?>)adder);
        Load load = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)load);
        this.convertedTerminals(load.getTerminal());
        EnergySourceConversion.addSpecificProperties(load);
    }

    private static void addSpecificProperties(Load load) {
        load.setProperty("CGMES.originalClass", "EnergySource");
    }
}

