/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.Conversion;
import com.powsybl.cgmes.conversion.CountryConversion;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.util.Networks;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConversion
extends AbstractIdentifiedObjectConversion {
    private static final Logger LOG = LoggerFactory.getLogger(NodeConversion.class);

    public NodeConversion(String nodeTypeName, PropertyBag n, Context context) {
        super(nodeTypeName, n, context);
    }

    @Override
    public boolean insideBoundary() {
        return this.context.boundary().containsNode(this.id);
    }

    @Override
    public void convertInsideBoundary() {
        double angle;
        double v;
        if (this.context.config().convertBoundary()) {
            if (this.context.nodeBreaker()) {
                this.newNode(this.newBoundarySubstationVoltageLevel());
            } else {
                this.newBus(this.newBoundarySubstationVoltageLevel());
            }
        } else if (this.p.containsKey((Object)"v") && this.p.containsKey((Object)"angle") && this.valid(v = this.p.asDouble("v"), angle = this.p.asDouble("angle"))) {
            this.context.boundary().addVoltageAtBoundary(this.id, v, angle);
        }
    }

    private VoltageLevel newBoundarySubstationVoltageLevel() {
        double nominalVoltage = this.context.cgmes().nominalVoltage(this.p.getId("BaseVoltage"));
        if (LOG.isWarnEnabled()) {
            LOG.warn("Boundary node will be converted {}, nominalVoltage {} from base voltage {}", new Object[]{this.id, nominalVoltage, this.p.getId("BaseVoltage")});
        }
        String substationId = Context.boundarySubstationId(this.id);
        String vlId = Context.boundaryVoltageLevelId(this.id);
        String substationName = "boundary";
        String vlName = "boundary";
        SubstationAdder adder = ((SubstationAdder)((SubstationAdder)this.context.network().newSubstation().setId(this.context.namingStrategy().getIidmId("Substation", substationId))).setName(substationName)).setCountry(this.boundaryCountryCode());
        if (this.boundaryCountryCode() != null) {
            adder.setGeographicalTags(new String[]{this.boundaryCountryCode().toString()});
        }
        Substation substation = adder.add();
        return ((VoltageLevelAdder)((VoltageLevelAdder)substation.newVoltageLevel().setId(this.context.namingStrategy().getIidmId("VoltageLevel", vlId))).setName(vlName)).setNominalV(nominalVoltage).setTopologyKind(this.context.nodeBreaker() ? TopologyKind.NODE_BREAKER : TopologyKind.BUS_BREAKER).add();
    }

    private Country boundaryCountryCode() {
        return CountryConversion.fromIsoCode(this.p.getLocal("fromEndIsoCode")).orElseGet(() -> CountryConversion.fromIsoCode(this.p.getLocal("toEndIsoCode")).orElseGet(() -> {
            Supplier<String> countryCodes = () -> String.format("Country. ISO codes %s %s", this.p.getLocal("fromEndIsoCode"), this.p.getLocal("toEndIsoCode"));
            this.ignored(countryCodes);
            return null;
        }));
    }

    @Override
    public boolean valid() {
        if (this.voltageLevel() == null) {
            this.missing(String.format("VoltageLevel %s", this.p.getId("VoltageLevel")));
            return false;
        }
        return true;
    }

    @Override
    public void convert() {
        VoltageLevel vl = this.voltageLevel();
        Objects.requireNonNull(vl);
        if (this.context.nodeBreaker()) {
            this.newNode(vl);
        } else {
            this.newBus(vl);
        }
    }

    public void setVoltageAngleNodeBreaker() {
        if (!this.context.nodeBreaker()) {
            return;
        }
        if (!this.checkValidVoltageAngle(null)) {
            return;
        }
        VoltageLevel vl = this.voltageLevel();
        if (vl == null) {
            return;
        }
        VoltageLevel.NodeBreakerView topo = vl.getNodeBreakerView();
        String connectivityNode = this.id;
        int iidmNode = this.context.nodeMapping().iidmNodeForConnectivityNode(connectivityNode, vl);
        if (!topo.hasAttachedEquipment(iidmNode)) {
            LOG.error("ConnectivityNode {} with voltage and angle is not valid in IIDM", (Object)connectivityNode);
            return;
        }
        Terminal t = topo.getOptionalTerminal(iidmNode).orElseGet(() -> Networks.getEquivalentTerminal((VoltageLevel)vl, (int)iidmNode));
        if (t == null) {
            LOG.error("Can't find a Terminal to obtain a Bus to set Voltage, Angle. ConnectivityNode {}", (Object)this.id);
            return;
        }
        Bus bus = t.getBusView().getBus();
        if (bus == null) {
            bus = t.getBusBreakerView().getBus();
            if (bus == null) {
                LOG.error("Can't find a Bus from Terminal to set Voltage, Angle. Connectivity Node {}", (Object)this.id);
                return;
            }
            LOG.warn("Can't find a bus from the Bus View to set Voltage and Angle, we use the bus {} from the Bus/Breaker view. Connectivity node {}", (Object)bus, (Object)this.id);
        }
        this.setVoltageAngle(bus);
    }

    private VoltageLevel voltageLevel() {
        if (this.insideBoundary() && this.context.config().convertBoundary()) {
            return this.context.network().getVoltageLevel(Context.boundaryVoltageLevelId(this.id));
        }
        if (!this.insideBoundary()) {
            String containerId = this.p.getId("ConnectivityNodeContainer");
            String cgmesId = this.context.cgmes().container(containerId).voltageLevel();
            if (cgmesId == null) {
                cgmesId = Conversion.getFictitiousVoltageLevelForNodeInContainer(containerId, this.id);
            }
            String iidm = this.context.namingStrategy().getIidmId("VoltageLevel", cgmesId);
            String iidmId = this.context.substationIdMapping().voltageLevelIidm(iidm);
            return iidmId != null ? this.context.network().getVoltageLevel(iidmId) : null;
        }
        return null;
    }

    private void newNode(VoltageLevel vl) {
        VoltageLevel.NodeBreakerView nbv = vl.getNodeBreakerView();
        String connectivityNode = this.id;
        int iidmNode = this.context.nodeMapping().iidmNodeForConnectivityNode(connectivityNode, vl);
        if (this.context.config().createBusbarSectionForEveryConnectivityNode()) {
            BusbarSection bus = ((BusbarSectionAdder)((BusbarSectionAdder)nbv.newBusbarSection().setId(this.context.namingStrategy().getIidmId("Bus", this.id))).setName(this.context.namingStrategy().getIidmName("Bus", this.name))).setNode(iidmNode).add();
            LOG.debug("    BusbarSection added at node {} : {} {} : {}", new Object[]{iidmNode, this.id, this.name, bus});
        }
    }

    private void newBus(VoltageLevel voltageLevel) {
        Bus bus = ((BusAdder)((BusAdder)voltageLevel.getBusBreakerView().newBus().setId(this.context.namingStrategy().getIidmId("Bus", this.id))).setName(this.context.namingStrategy().getIidmName("Bus", this.name))).add();
        if (this.checkValidVoltageAngle(bus)) {
            this.setVoltageAngle(bus);
        }
    }

    private boolean checkValidVoltageAngle(Bus bus) {
        double v = this.p.asDouble("v");
        double angle = this.p.asDouble("angle");
        if (Double.isNaN(v) && Double.isNaN(angle)) {
            return false;
        }
        boolean valid = this.valid(v, angle);
        if (!valid) {
            Supplier<String> reason = () -> String.format("v = %f, angle = %f. Node %s", v, angle, this.id);
            Supplier<String> location = () -> bus == null ? "No bus" : String.format("Bus %s, %sVoltage level %s", bus.getId(), bus.getVoltageLevel().getSubstation().map(s -> "Substation " + s.getNameOrId() + ", ").orElse(""), bus.getVoltageLevel().getNameOrId());
            Supplier<String> message = () -> (String)reason.get() + ". " + (String)location.get();
            this.context.invalid("SvVoltage", message);
            if (bus != null) {
                CgmesReports.invalidAngleVoltageBusReport(this.context.getReportNode(), bus, this.id, v, angle);
            } else {
                CgmesReports.invalidAngleVoltageNodeReport(this.context.getReportNode(), this.id, v, angle);
            }
        }
        return valid;
    }

    private void setVoltageAngle(Bus bus) {
        Objects.requireNonNull(bus);
        double v = this.p.asDouble("v");
        double angle = this.p.asDouble("angle");
        bus.setV(v);
        bus.setAngle(angle);
    }

    private boolean valid(double v, double angle) {
        boolean valid = v > 0.0;
        LOG.debug("valid voltage ({}, {}) ? {}", new Object[]{v, angle, valid});
        return valid;
    }
}

