/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;
import java.util.function.Supplier;

public class OperationalLimitConversion
extends AbstractIdentifiedObjectConversion {
    private static final String ACTIVE_POWER_LIMIT = "ActivePowerLimit";
    private static final String APPARENT_POWER_LIMIT = "ApparentPowerLimit";
    private static final String CURRENT_LIMIT = "CurrentLimit";
    private static final String LIMIT_TYPE = "limitType";
    private static final String OPERATIONAL_LIMIT = "Operational limit";
    private static final String OPERATIONAL_LIMIT_TYPE_NAME = "operationalLimitTypeName";
    private static final String OPERATIONAL_LIMIT_SUBCLASS = "OperationalLimitSubclass";
    private static final String PERMANENT_LIMIT = "Permanent Limit";
    private static final String TEMPORARY_LIMIT = "Temporary Limit";
    private final String terminalId;
    private final String equipmentId;
    private LoadingLimitsAdder<?, ?> loadingLimitsAdder;
    private LoadingLimitsAdder<?, ?> loadingLimitsAdder1;
    private LoadingLimitsAdder<?, ?> loadingLimitsAdder2;
    private VoltageLevel vl;

    public OperationalLimitConversion(PropertyBag l, Context context) {
        super("OperationalLimit", l, context);
        String limitSubclass = this.p.getLocal(OPERATIONAL_LIMIT_SUBCLASS);
        this.terminalId = l.getId("Terminal");
        this.equipmentId = l.getId("Equipment");
        Terminal terminal = null;
        if (limitSubclass == null || limitSubclass.equals(ACTIVE_POWER_LIMIT) || limitSubclass.equals(APPARENT_POWER_LIMIT) || limitSubclass.equals(CURRENT_LIMIT)) {
            if (this.terminalId != null) {
                terminal = context.terminalMapping().findForFlowLimits(this.terminalId);
            }
            if (terminal != null) {
                this.createLimitsAdder(context.terminalMapping().number(this.terminalId), limitSubclass, (Identifiable<?>)terminal.getConnectable());
            } else if (this.equipmentId != null) {
                Identifiable identifiable = context.network().getIdentifiable(this.equipmentId);
                this.createLimitsAdder(-1, limitSubclass, identifiable);
            }
        } else if (limitSubclass.equals("VoltageLimit")) {
            if (this.terminalId != null) {
                terminal = context.terminalMapping().findForVoltageLimits(this.terminalId);
            }
            this.setVoltageLevelForVoltageLimit(terminal);
        } else {
            this.notAssigned();
        }
    }

    private void setVoltageLevelForVoltageLimit(Terminal terminal) {
        if (terminal != null) {
            this.vl = terminal.getVoltageLevel();
        } else if (this.equipmentId != null) {
            Identifiable i = this.context.network().getIdentifiable(this.equipmentId);
            if (i == null) {
                this.vl = this.context.network().getVoltageLevel(this.p.getId("EquipmentContainer"));
            } else if (i instanceof Injection) {
                Injection injection = (Injection)i;
                this.vl = injection.getTerminal().getVoltageLevel();
            }
        }
    }

    private static Supplier<LoadingLimitsAdder<?, ?>> getLoadingLimitAdderSupplier(String limitSubClass, FlowsLimitsHolder holder) {
        if (limitSubClass == null) {
            return () -> ((FlowsLimitsHolder)holder).newCurrentLimits();
        }
        switch (limitSubClass) {
            case "ActivePowerLimit": {
                return () -> ((FlowsLimitsHolder)holder).newActivePowerLimits();
            }
            case "ApparentPowerLimit": {
                return () -> ((FlowsLimitsHolder)holder).newApparentPowerLimits();
            }
            case "CurrentLimit": {
                return () -> ((FlowsLimitsHolder)holder).newCurrentLimits();
            }
        }
        throw new IllegalStateException();
    }

    private static Supplier<LoadingLimitsAdder<?, ?>> getLoadingLimitAdder1Supplier(String limitSubClass, Branch<?> b) {
        if (limitSubClass == null) {
            return () -> b.newCurrentLimits1();
        }
        switch (limitSubClass) {
            case "ActivePowerLimit": {
                return () -> b.newActivePowerLimits1();
            }
            case "ApparentPowerLimit": {
                return () -> b.newApparentPowerLimits1();
            }
            case "CurrentLimit": {
                return () -> b.newCurrentLimits1();
            }
        }
        throw new IllegalStateException();
    }

    private static Supplier<LoadingLimitsAdder<?, ?>> getLoadingLimitAdder2Supplier(String limitSubClass, Branch<?> b) {
        if (limitSubClass == null) {
            return () -> b.newCurrentLimits2();
        }
        switch (limitSubClass) {
            case "ActivePowerLimit": {
                return () -> b.newActivePowerLimits2();
            }
            case "ApparentPowerLimit": {
                return () -> b.newApparentPowerLimits2();
            }
            case "CurrentLimit": {
                return () -> b.newCurrentLimits2();
            }
        }
        throw new IllegalStateException();
    }

    private void createLimitsAdder(int terminalNumber, String limitSubClass, Branch<?> b) {
        if (terminalNumber == 1) {
            Supplier<LoadingLimitsAdder<?, ?>> loadingLimitAdder1Supplier = OperationalLimitConversion.getLoadingLimitAdder1Supplier(limitSubClass, b);
            this.loadingLimitsAdder1 = this.context.loadingLimitsMapping().computeIfAbsentLoadingLimitsAdder(b.getId() + "_1_" + limitSubClass, loadingLimitAdder1Supplier);
        } else if (terminalNumber == 2) {
            Supplier<LoadingLimitsAdder<?, ?>> loadingLimitAdder2Supplier = OperationalLimitConversion.getLoadingLimitAdder2Supplier(limitSubClass, b);
            this.loadingLimitsAdder2 = this.context.loadingLimitsMapping().computeIfAbsentLoadingLimitsAdder(b.getId() + "_2_" + limitSubClass, loadingLimitAdder2Supplier);
        } else {
            this.notAssigned((Identifiable<?>)b);
        }
    }

    private void createLimitsAdder(int terminalNumber, String limitSubClass, ThreeWindingsTransformer twt) {
        if (terminalNumber == 1) {
            this.loadingLimitsAdder = this.context.loadingLimitsMapping().computeIfAbsentLoadingLimitsAdder(twt.getId() + "_1_" + limitSubClass, OperationalLimitConversion.getLoadingLimitAdderSupplier(limitSubClass, (FlowsLimitsHolder)twt.getLeg1()));
        } else if (terminalNumber == 2) {
            this.loadingLimitsAdder = this.context.loadingLimitsMapping().computeIfAbsentLoadingLimitsAdder(twt.getId() + "_2_" + limitSubClass, OperationalLimitConversion.getLoadingLimitAdderSupplier(limitSubClass, (FlowsLimitsHolder)twt.getLeg2()));
        } else if (terminalNumber == 3) {
            this.loadingLimitsAdder = this.context.loadingLimitsMapping().computeIfAbsentLoadingLimitsAdder(twt.getId() + "_3_" + limitSubClass, OperationalLimitConversion.getLoadingLimitAdderSupplier(limitSubClass, (FlowsLimitsHolder)twt.getLeg3()));
        } else {
            this.notAssigned((Identifiable<?>)twt);
        }
    }

    private void createLimitsAdder(int terminalNumber, String limitSubClass, Identifiable<?> identifiable) {
        if (identifiable instanceof Line) {
            Branch b = (Branch)identifiable;
            if (terminalNumber == -1) {
                this.loadingLimitsAdder1 = this.context.loadingLimitsMapping().computeIfAbsentLoadingLimitsAdder(b.getId() + "_1", OperationalLimitConversion.getLoadingLimitAdder1Supplier(limitSubClass, b));
                this.loadingLimitsAdder2 = this.context.loadingLimitsMapping().computeIfAbsentLoadingLimitsAdder(b.getId() + "_2", OperationalLimitConversion.getLoadingLimitAdder2Supplier(limitSubClass, b));
            } else {
                this.createLimitsAdder(terminalNumber, limitSubClass, b);
            }
        } else if (identifiable instanceof TwoWindingsTransformer) {
            Branch b = (Branch)identifiable;
            if (terminalNumber == -1) {
                this.context.ignored(limitSubClass, "Defined for Equipment TwoWindingsTransformer. Should be defined for one Terminal of Two");
                this.notAssigned((Identifiable<?>)b);
            } else {
                this.createLimitsAdder(terminalNumber, limitSubClass, b);
            }
        } else if (identifiable instanceof DanglingLine) {
            DanglingLine danglingLine = (DanglingLine)identifiable;
            this.loadingLimitsAdder = this.context.loadingLimitsMapping().computeIfAbsentLoadingLimitsAdder(danglingLine.getId() + "_" + limitSubClass, OperationalLimitConversion.getLoadingLimitAdderSupplier(limitSubClass, (FlowsLimitsHolder)danglingLine));
        } else if (identifiable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer twt = (ThreeWindingsTransformer)identifiable;
            if (terminalNumber == -1) {
                this.context.ignored(limitSubClass, "Defined for Equipment ThreeWindingsTransformer. Should be defined for one Terminal of Three");
                this.notAssigned((Identifiable<?>)twt);
            } else {
                this.createLimitsAdder(terminalNumber, limitSubClass, twt);
            }
        } else if (identifiable instanceof Switch) {
            Switch aswitch = this.context.network().getSwitch(this.equipmentId);
            this.notAssigned((Identifiable<?>)aswitch);
        } else {
            this.notAssigned(identifiable);
        }
    }

    @Override
    public boolean valid() {
        if (this.vl == null && this.loadingLimitsAdder == null && this.loadingLimitsAdder1 == null && this.loadingLimitsAdder2 == null) {
            this.missing(String.format("Terminal %s or Equipment %s", this.terminalId, this.equipmentId));
            return false;
        }
        return true;
    }

    @Override
    public void convert() {
        double normalValue = this.p.asDouble("normalValue");
        double value = this.p.asDouble("value", normalValue);
        if (value <= 0.0) {
            this.context.ignored(OPERATIONAL_LIMIT, "value is <= 0");
            return;
        }
        if (this.vl != null) {
            this.convertVoltageLimit(value);
        } else if (this.isPatl()) {
            this.convertPatl(value);
        } else if (this.isTatl()) {
            this.convertTatl(value);
        }
    }

    private void convertVoltageLimit(double value) {
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        if (limitTypeName.equalsIgnoreCase("highvoltage") || "LimitTypeKind.highVoltage".equals(limitType)) {
            if (value < this.vl.getLowVoltageLimit()) {
                this.context.ignored("HighVoltageLimit", "Inconsistent with low voltage limit (" + this.vl.getLowVoltageLimit() + "kV)");
            } else if (value < this.vl.getHighVoltageLimit() || Double.isNaN(this.vl.getHighVoltageLimit())) {
                this.vl.setHighVoltageLimit(value);
            }
        } else if (limitTypeName.equalsIgnoreCase("lowvoltage") || "LimitTypeKind.lowVoltage".equals(limitType)) {
            if (value > this.vl.getHighVoltageLimit()) {
                this.context.ignored("LowVoltageLimit", "Inconsistent with high voltage limit (" + this.vl.getHighVoltageLimit() + "kV)");
            } else if (value > this.vl.getLowVoltageLimit() || Double.isNaN(this.vl.getLowVoltageLimit())) {
                this.vl.setLowVoltageLimit(value);
            }
        } else {
            this.notAssigned((Identifiable<?>)this.vl);
        }
    }

    private boolean isPatl() {
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        return limitTypeName.equals("PATL") || "LimitTypeKind.patl".equals(limitType) || "LimitKind.patl".equals(limitType);
    }

    private void addPatl(double value, LoadingLimitsAdder<?, ?> adder) {
        if (Double.isNaN(adder.getPermanentLimit())) {
            adder.setPermanentLimit(value);
        } else {
            if (this.terminalId != null) {
                this.context.fixed(PERMANENT_LIMIT, () -> String.format("Several permanent limits defined for Terminal %s. Only the lowest is kept.", this.terminalId));
            } else {
                this.context.fixed(PERMANENT_LIMIT, () -> String.format("Several permanent limits defined for Equipment %s. Only the lowest is kept.", this.equipmentId));
            }
            if (adder.getPermanentLimit() > value) {
                adder.setPermanentLimit(value);
            }
        }
    }

    private void convertPatl(double value) {
        if (this.loadingLimitsAdder != null) {
            this.addPatl(value, this.loadingLimitsAdder);
        } else {
            if (this.loadingLimitsAdder1 != null) {
                this.addPatl(value, this.loadingLimitsAdder1);
            }
            if (this.loadingLimitsAdder2 != null) {
                this.addPatl(value, this.loadingLimitsAdder2);
            }
        }
    }

    private boolean isTatl() {
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        return limitTypeName.equals("TATL") || "LimitTypeKind.tatl".equals(limitType) || "LimitKind.tatl".equals(limitType);
    }

    private void addTatl(String name, double value, int acceptableDuration, LoadingLimitsAdder<?, ?> adder) {
        if (Double.isNaN(value)) {
            this.context.ignored(TEMPORARY_LIMIT, "Temporary limit value is undefined");
            return;
        }
        if (Double.isNaN(adder.getTemporaryLimitValue(acceptableDuration))) {
            adder.beginTemporaryLimit().setAcceptableDuration(acceptableDuration).setName(name).setValue(value).ensureNameUnicity().endTemporaryLimit();
        } else {
            if (this.terminalId != null) {
                this.context.fixed(TEMPORARY_LIMIT, () -> String.format("Several temporary limits defined for same acceptable duration (%d s) for Terminal %s. Only the lowest is kept.", acceptableDuration, this.terminalId));
            } else {
                this.context.fixed(TEMPORARY_LIMIT, () -> String.format("Several temporary limits defined for same acceptable duration (%d s) for Equipment %s. Only the lowest is kept.", acceptableDuration, this.equipmentId));
            }
            if (adder.getTemporaryLimitValue(acceptableDuration) > value) {
                adder.beginTemporaryLimit().setAcceptableDuration(acceptableDuration).setName(name).setValue(value).ensureNameUnicity().endTemporaryLimit();
            }
        }
    }

    private void convertTatl(double value) {
        int acceptableDuration = this.p.containsKey((Object)"acceptableDuration") ? (int)this.p.asDouble("acceptableDuration") : Integer.MAX_VALUE;
        String direction = this.p.getId("direction");
        if (direction == null || direction.endsWith("high") || direction.endsWith("absoluteValue")) {
            String name = Optional.ofNullable(this.p.getId("shortName")).orElse(this.p.getId("name"));
            if (this.loadingLimitsAdder != null) {
                this.addTatl(name, value, acceptableDuration, this.loadingLimitsAdder);
            } else {
                if (this.loadingLimitsAdder1 != null) {
                    this.addTatl(name, value, acceptableDuration, this.loadingLimitsAdder1);
                }
                if (this.loadingLimitsAdder2 != null) {
                    this.addTatl(name, value, acceptableDuration, this.loadingLimitsAdder2);
                }
            }
        } else if (direction.endsWith("low")) {
            this.context.invalid(TEMPORARY_LIMIT, () -> String.format("TATL %s is a low limit", this.id));
        } else {
            this.context.invalid(TEMPORARY_LIMIT, () -> String.format("TATL %s does not have a valid direction", this.id));
        }
    }

    private void notAssigned() {
        this.notAssigned(null);
    }

    private void notAssigned(Identifiable<?> eq) {
        String type = this.p.getLocal(LIMIT_TYPE);
        String typeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String subclass = this.p.getLocal(OPERATIONAL_LIMIT_SUBCLASS);
        Supplier<String> reason = () -> String.format("Not assigned for %s %s. Limit id, type, typeName, subClass, terminal : %s, %s, %s, %s, %s", eq != null ? OperationalLimitConversion.className(eq) : "", eq != null ? eq.getId() : "", this.id, type, typeName, subclass, this.terminalId);
        this.context.pending(OPERATIONAL_LIMIT, reason);
    }

    private static String className(Identifiable<?> o) {
        String s = o.getClass().getName();
        int dot = s.lastIndexOf(46);
        if (dot >= 0) {
            s = s.substring(dot + 1);
        }
        s = s.replace("Impl", "");
        return s;
    }
}

