/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForGenerators;
import com.powsybl.cgmes.conversion.elements.AbstractReactiveLimitsOwnerConversion;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.extensions.ActivePowerControlAdder;
import com.powsybl.iidm.network.extensions.ReferencePriority;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Arrays;

public class SynchronousMachineConversion
extends AbstractReactiveLimitsOwnerConversion {
    private final boolean isCondenser;

    public SynchronousMachineConversion(PropertyBag sm, Context context) {
        super("SynchronousMachine", sm, context);
        String type = this.p.getLocal("type");
        this.isCondenser = type != null && type.endsWith("Kind.condenser");
    }

    @Override
    public void convert() {
        double minP = this.p.asDouble("minP", this.isCondenser ? 0.0 : -1.7976931348623157E308);
        double maxP = this.p.asDouble("maxP", this.isCondenser ? 0.0 : Double.MAX_VALUE);
        double ratedS = this.p.asDouble("ratedS");
        ratedS = ratedS > 0.0 ? ratedS : Double.NaN;
        PowerFlow f = this.powerFlow();
        double targetP = this.p.asDouble("initialP", 0.0);
        double targetQ = 0.0;
        if (f.defined()) {
            targetP = -f.p();
            targetQ = -f.q();
        }
        GeneratorAdder adder = this.voltageLevel().newGenerator();
        RegulatingControlMappingForGenerators.initialize(adder);
        this.setMinPMaxP(adder, minP, maxP);
        adder.setTargetP(targetP).setTargetQ(targetQ).setEnergySource(this.energySourceFromGeneratingUnitType()).setRatedS(ratedS);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect((InjectionAdder<?, ?>)adder);
        Generator g = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)g);
        this.convertedTerminals(g.getTerminal());
        this.convertReactiveLimits((ReactiveLimitsHolder)g);
        int referencePriority = this.p.asInt("referencePriority", 0);
        if (referencePriority > 0) {
            ReferencePriority.set((Injection)g, (int)referencePriority);
        }
        if (!this.isCondenser) {
            this.convertGenerator(g);
        }
        this.context.regulatingControlMapping().forGenerators().add(g.getId(), this.p);
        SynchronousMachineConversion.addSpecificProperties(g, this.p);
    }

    private static void addSpecificProperties(Generator generator, PropertyBag p) {
        String operatingMode;
        generator.setProperty("CGMES.originalClass", "SynchronousMachine");
        String type = p.getLocal("type");
        if (type != null) {
            generator.setProperty("CGMES.synchronousMachineType", type.replace("SynchronousMachineKind.", ""));
        }
        if ((operatingMode = p.getLocal("operatingMode")) != null) {
            generator.setProperty("CGMES.synchronousMachineOperatingMode", operatingMode.replace("SynchronousMachineOperatingMode.", ""));
        }
    }

    private void convertGenerator(Generator g) {
        String generatingUnit;
        double normalPF = this.p.asDouble("normalPF");
        if (!Double.isNaN(normalPF)) {
            if (this.context.config().createActivePowerControlExtension()) {
                ((ActivePowerControlAdder)g.newExtension(ActivePowerControlAdder.class)).withParticipate(true).withParticipationFactor(normalPF).add();
            } else {
                g.setProperty("CGMES.normalPF", String.valueOf(normalPF));
            }
        }
        if ((generatingUnit = this.p.getId("GeneratingUnit")) != null) {
            g.setProperty("CGMES.GeneratingUnit", generatingUnit);
        }
        SynchronousMachineConversion.addSpecificGeneratingUnitProperties(g, this.p);
    }

    private static void addSpecificGeneratingUnitProperties(Generator generator, PropertyBag p) {
        String fossilFuelType;
        String hydroPlantStorageType = p.getLocal("hydroPlantStorageType");
        if (hydroPlantStorageType != null) {
            generator.setProperty("CGMES.hydroPlantStorageKind", hydroPlantStorageType.replace("HydroPlantStorageKind.", ""));
        }
        if (!(fossilFuelType = String.join((CharSequence)";", Arrays.stream(p.getLocals("fossilFuelTypeList", ";")).map(ff -> ff.replace("FuelType.", "")).toList())).isEmpty()) {
            generator.setProperty("CGMES.fuelType", fossilFuelType);
        }
    }

    private EnergySource energySourceFromGeneratingUnitType() {
        String gut = this.p.getLocal("generatingUnitType");
        EnergySource es = EnergySource.OTHER;
        if (gut != null) {
            if (gut.contains("HydroGeneratingUnit")) {
                es = EnergySource.HYDRO;
            } else if (gut.contains("NuclearGeneratingUnit")) {
                es = EnergySource.NUCLEAR;
            } else if (gut.contains("ThermalGeneratingUnit")) {
                es = EnergySource.THERMAL;
            } else if (gut.contains("WindGeneratingUnit")) {
                es = EnergySource.WIND;
            } else if (gut.contains("SolarGeneratingUnit")) {
                es = EnergySource.SOLAR;
            }
        }
        return es;
    }
}

