/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.triplestore.api.PropertyBag;

public class VoltageLevelConversion
extends AbstractIdentifiedObjectConversion {
    private final String cgmesSubstationId;
    private final String iidmSubstationId;
    private final Substation substation;

    public VoltageLevelConversion(PropertyBag vl, Context context) {
        super("VoltageLevel", vl, context);
        this.cgmesSubstationId = this.p.getId("Substation");
        this.iidmSubstationId = context.substationIdMapping().substationIidm(this.cgmesSubstationId);
        this.substation = context.network().getSubstation(this.iidmSubstationId);
    }

    @Override
    public boolean valid() {
        double nominalVoltage = this.p.asDouble("nominalVoltage");
        if (nominalVoltage == 0.0) {
            this.ignored("Voltage level", () -> String.format("nominal voltage of %s is equal to 0", this.id));
            return false;
        }
        if (this.substation == null) {
            this.missing(String.format("Substation %s (IIDM id: %s)", this.cgmesSubstationId, this.iidmSubstationId));
            return false;
        }
        return !this.context.substationIdMapping().voltageLevelIsMapped(this.id);
    }

    @Override
    public void convert() {
        String baseVoltage = this.p.getId("BaseVoltage");
        double nominalVoltage = this.p.asDouble("nominalVoltage");
        double lowVoltageLimit = this.p.asDouble("lowVoltageLimit");
        double highVoltageLimit = this.p.asDouble("highVoltageLimit");
        if (Double.isNaN(nominalVoltage)) {
            String bv = String.format("BaseVoltage %s", baseVoltage);
            this.missing(bv);
            throw new CgmesModelException(String.format("nominalVoltage not found for %s", bv));
        }
        String iidmVoltageLevelId = this.context.substationIdMapping().voltageLevelIidm(this.id);
        VoltageLevel voltageLevel = this.context.network().getVoltageLevel(iidmVoltageLevelId);
        if (voltageLevel == null) {
            VoltageLevelAdder adder = this.substation.newVoltageLevel().setNominalV(nominalVoltage).setTopologyKind(this.context.nodeBreaker() ? TopologyKind.NODE_BREAKER : TopologyKind.BUS_BREAKER).setLowVoltageLimit(lowVoltageLimit).setHighVoltageLimit(highVoltageLimit);
            this.identify((IdentifiableAdder<?, ?>)adder);
            VoltageLevel vl = adder.add();
            this.addAliases(vl);
        }
    }

    private void addAliases(VoltageLevel vl) {
        int index = 0;
        for (String mergedVl : this.context.substationIdMapping().mergedVoltageLevels(vl.getId())) {
            vl.addAlias(mergedVl, "MergedVoltageLevel" + ++index, this.context.config().isEnsureIdAliasUnicity());
        }
    }
}

