/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DcMapping {
    private final Context context;
    private final Map<String, CgmesConverter> cgmesConverters;
    private final Map<String, CgmesDcLineSegment> cgmesDcLineSegments;

    public DcMapping(Context context) {
        this.context = Objects.requireNonNull(context);
        this.cgmesConverters = new HashMap<String, CgmesConverter>();
        this.cgmesDcLineSegments = new HashMap<String, CgmesDcLineSegment>();
    }

    public void initialize() {
        this.context.cgmes().acDcConverters().forEach(pb -> this.cgmesConverters.put(pb.getId("ACDCConverter"), new CgmesConverter((PropertyBag)pb)));
        this.context.cgmes().dcLineSegments().forEach(pb -> this.cgmesDcLineSegments.put(pb.getId("DCLineSegment"), new CgmesDcLineSegment((PropertyBag)pb)));
    }

    PropertyBag getCgmesConverterPropertyBag(String id) {
        CgmesConverter cgmesConverter = this.cgmesConverters.get(id);
        if (cgmesConverter != null) {
            return cgmesConverter.propertyBag;
        }
        return null;
    }

    void setCgmesConverterUsed(String id) {
        CgmesConverter cgmesConverter = this.cgmesConverters.get(id);
        if (cgmesConverter != null) {
            cgmesConverter.used();
        }
    }

    void reportCgmesConvertersNotUsed() {
        this.cgmesConverters.entrySet().stream().filter(c -> !((CgmesConverter)c.getValue()).used).forEach(c -> {
            String what = "AcDcConverter Id: " + (String)c.getKey();
            this.context.ignored(what, "Dc configuration not supported");
        });
    }

    PropertyBag getCgmesDcLineSegmentPropertyBag(String id) {
        CgmesDcLineSegment cgmesDcLineSegment = this.cgmesDcLineSegments.get(id);
        if (cgmesDcLineSegment != null) {
            return cgmesDcLineSegment.propertyBag;
        }
        return null;
    }

    void setCgmesDcLineSegmentUsed(String id) {
        CgmesDcLineSegment cgmesDcLineSegment = this.cgmesDcLineSegments.get(id);
        if (cgmesDcLineSegment != null) {
            cgmesDcLineSegment.setUsed();
        }
    }

    void reportCgmesDcLineSegmentNotUsed() {
        this.cgmesDcLineSegments.entrySet().stream().filter(c -> !((CgmesDcLineSegment)c.getValue()).used).forEach(c -> {
            String what = "DcLineSegment Id: " + (String)c.getKey();
            this.context.ignored(what, "Ground DcLineSegment or Dc configuration not supported");
        });
    }

    private static class CgmesConverter {
        private PropertyBag propertyBag;
        private boolean used;

        CgmesConverter(PropertyBag propertyBag) {
            this.propertyBag = propertyBag;
            this.used = false;
        }

        void used() {
            this.used = true;
        }
    }

    private static class CgmesDcLineSegment {
        private PropertyBag propertyBag;
        private boolean used;

        CgmesDcLineSegment(PropertyBag propertyBag) {
            this.propertyBag = propertyBag;
            this.used = false;
        }

        void setUsed() {
            this.used = true;
        }
    }
}

