/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.elements.hvdc.Adjacency;
import com.powsybl.cgmes.conversion.elements.hvdc.NodeEquipment;
import com.powsybl.commons.PowsyblException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class IslandEndHvdc {
    private final List<HvdcEnd> hvdc = new ArrayList<HvdcEnd>();

    IslandEndHvdc() {
    }

    void add(Adjacency adjacency, NodeEquipment nodeEquipment, List<String> islandNodesEnd) {
        if (islandNodesEnd.isEmpty()) {
            return;
        }
        HashSet<String> visitedNodes = new HashSet<String>();
        HashSet<String> usedAcDcConverters = new HashSet<String>();
        Optional<String> nodeEndWithTransformers = IslandEndHvdc.nodeConnectedToTransformersWithMoreAcDcConvertersConnectedTo(nodeEquipment, islandNodesEnd, visitedNodes);
        while (nodeEndWithTransformers.isPresent()) {
            Set<String> acDcConverters = this.add(adjacency, nodeEquipment, visitedNodes, nodeEndWithTransformers.get(), islandNodesEnd);
            usedAcDcConverters.addAll(acDcConverters);
            nodeEndWithTransformers = IslandEndHvdc.nodeConnectedToTransformersWithMoreAcDcConvertersConnectedTo(nodeEquipment, islandNodesEnd, visitedNodes);
        }
        Optional<String> nodeEnd = IslandEndHvdc.nodeWithMoreAcDcConvertersConnectedTo(nodeEquipment, islandNodesEnd, visitedNodes, usedAcDcConverters);
        while (nodeEnd.isPresent()) {
            Set<String> acDcConverters = this.add(adjacency, nodeEquipment, visitedNodes, nodeEnd.get(), islandNodesEnd);
            usedAcDcConverters.addAll(acDcConverters);
            nodeEnd = IslandEndHvdc.nodeWithMoreAcDcConvertersConnectedTo(nodeEquipment, islandNodesEnd, visitedNodes, usedAcDcConverters);
        }
    }

    private static Optional<String> nodeConnectedToTransformersWithMoreAcDcConvertersConnectedTo(NodeEquipment nodeEquipment, List<String> islandNodesEnd, Set<String> visitedNodes) {
        return IslandEndHvdc.notVisitedNodesSortedByAcDcConvertersConnectedTo(nodeEquipment, islandNodesEnd, visitedNodes).stream().filter(nodeEquipment::containsAnyTransformer).findFirst();
    }

    private static Optional<String> nodeWithMoreAcDcConvertersConnectedTo(NodeEquipment nodeEquipment, List<String> islandNodesEnd, Set<String> visitedNodes, Set<String> usedAcDcConverters) {
        return IslandEndHvdc.notVisitedNodesSortedByNotUsedAcDcConvertersConnectedTo(nodeEquipment, islandNodesEnd, visitedNodes, usedAcDcConverters).stream().findFirst();
    }

    private static List<String> notVisitedNodesSortedByAcDcConvertersConnectedTo(NodeEquipment nodeEquipment, List<String> islandNodesEnd, Set<String> visitedNodes) {
        return islandNodesEnd.stream().filter(nodeEnd -> !visitedNodes.contains(nodeEnd) && nodeEquipment.containsAnyAcDcConverter((String)nodeEnd)).sorted(Comparator.comparingInt(nodeEquipment::acDcConvertersConnectedTo).reversed().thenComparing(nodeEnd -> nodeEnd)).collect(Collectors.toList());
    }

    private static List<String> notVisitedNodesSortedByNotUsedAcDcConvertersConnectedTo(NodeEquipment nodeEquipment, List<String> islandNodesEnd, Set<String> visitedNodes, Set<String> usedAcDcConverters) {
        return islandNodesEnd.stream().filter(nodeEnd -> !visitedNodes.contains(nodeEnd) && nodeEquipment.containsAnyNotUsedAcDcConverter((String)nodeEnd, usedAcDcConverters)).sorted(Comparator.comparingInt(nodeEquipment::acDcConvertersConnectedTo).reversed().thenComparing(nodeEnd -> nodeEnd)).collect(Collectors.toList());
    }

    private Set<String> add(Adjacency adjacency, NodeEquipment nodeEquipment, Set<String> visitedNodes, String nodeEnd, List<String> islandNodesEnd) {
        List<String> hvdcNodes = IslandEndHvdc.computeHvdcNodes(adjacency, nodeEquipment, nodeEnd, islandNodesEnd);
        Set<String> transformers = IslandEndHvdc.computeEquipment(nodeEquipment, hvdcNodes, NodeEquipment.EquipmentType.TRANSFORMER);
        Set<String> acDcConverters = IslandEndHvdc.computeEquipment(nodeEquipment, hvdcNodes, NodeEquipment.EquipmentType.AC_DC_CONVERTER);
        Set<String> dcLineSegment = IslandEndHvdc.computeEquipment(nodeEquipment, hvdcNodes, NodeEquipment.EquipmentType.DC_LINE_SEGMENT);
        visitedNodes.addAll(hvdcNodes);
        HvdcEnd hvdcEnd = new HvdcEnd(hvdcNodes, transformers, acDcConverters, dcLineSegment);
        this.hvdc.add(hvdcEnd);
        return acDcConverters;
    }

    private static List<String> computeHvdcNodes(Adjacency adjacency, NodeEquipment nodeEquipment, String nodeEnd, List<String> islandNodesEnd) {
        ArrayList<String> listNodes = new ArrayList<String>();
        listNodes.add(nodeEnd);
        for (int k = 0; k < listNodes.size(); ++k) {
            String node = (String)listNodes.get(k);
            if (!adjacency.get().containsKey(node)) continue;
            adjacency.get().get(node).forEach(adjacent -> {
                if (IslandEndHvdc.isAdjacentOk(nodeEquipment, listNodes, islandNodesEnd, adjacent.type, adjacent.node)) {
                    listNodes.add(adjacent.node);
                }
            });
        }
        return listNodes;
    }

    private static boolean isAdjacentOk(NodeEquipment nodeEquipment, List<String> visitedNodes, List<String> islandNodesEnd, Adjacency.AdjacentType adType, String adNode) {
        if (Adjacency.isDcLineSegment(adType)) {
            return false;
        }
        if (!islandNodesEnd.contains(adNode)) {
            return false;
        }
        if (visitedNodes.contains(adNode)) {
            return false;
        }
        return !nodeEquipment.multiAcDcConverter(adNode);
    }

    private static Set<String> computeEquipment(NodeEquipment nodeEquipment, List<String> hvdcNode, NodeEquipment.EquipmentType type) {
        HashSet<String> listEq = new HashSet<String>();
        hvdcNode.forEach(n -> IslandEndHvdc.addEquipment(nodeEquipment, n, type, listEq));
        return listEq;
    }

    private static void addEquipment(NodeEquipment nodeEquipment, String node, NodeEquipment.EquipmentType type, Set<String> listEq) {
        List<NodeEquipment.EquipmentReference> listEqNode = nodeEquipment.getNodeEquipment().get(node);
        if (listEqNode == null) {
            return;
        }
        listEqNode.stream().filter(eq -> eq.type == type).forEachOrdered(eq -> listEq.add(eq.equipmentId));
    }

    List<HvdcEnd> getHvdc() {
        return this.hvdc;
    }

    static class HvdcEnd {
        final List<String> nodesEnd;
        final Set<String> transformersEnd;
        final Set<String> acDcConvertersEnd;
        final Set<String> dcLineSegmentsEnd;

        HvdcEnd(List<String> nodesEnd, Set<String> transformersEnd, Set<String> acDcConvertersEnd, Set<String> dcLineSegmentsEnd) {
            Objects.requireNonNull(nodesEnd);
            Objects.requireNonNull(transformersEnd);
            Objects.requireNonNull(acDcConvertersEnd);
            Objects.requireNonNull(dcLineSegmentsEnd);
            this.nodesEnd = nodesEnd;
            this.transformersEnd = transformersEnd;
            this.acDcConvertersEnd = acDcConvertersEnd;
            this.dcLineSegmentsEnd = dcLineSegmentsEnd;
        }

        HvdcEndType computeType() {
            int t = this.transformersEnd.size();
            int c = this.acDcConvertersEnd.size();
            int ls = this.dcLineSegmentsEnd.size();
            if (t >= 0 && c == 1 && ls == 1) {
                return HvdcEndType.HVDC_TN_C1_LS1;
            }
            if (t >= 0 && c >= 1 && ls == 2 * c) {
                return HvdcEndType.HVDC_TN_CN_LS2N;
            }
            if (t >= 0 && c == 2 && ls == 1) {
                return HvdcEndType.HVDC_TN_C2_LS1;
            }
            if (t >= 0 && c == ls && c > 1) {
                return HvdcEndType.HVDC_TN_CN_LSN;
            }
            throw new PowsyblException(String.format("Unexpected HVDC configuration: Transformers %d Converters %d DcLineSegments %d", t, c, ls));
        }

        boolean isMatchingTo(HvdcEnd otherHvdcEnd) {
            if (this.acDcConvertersEnd.size() != otherHvdcEnd.acDcConvertersEnd.size()) {
                return false;
            }
            if (this.dcLineSegmentsEnd.size() != otherHvdcEnd.dcLineSegmentsEnd.size()) {
                return false;
            }
            return this.dcLineSegmentsEnd.stream().allMatch(otherHvdcEnd.dcLineSegmentsEnd::contains);
        }

        boolean isAssociatedWith(HvdcEnd otherHvdcEnd) {
            return this.dcLineSegmentsEnd.stream().anyMatch(otherHvdcEnd.dcLineSegmentsEnd::contains);
        }

        static HvdcEnd joinAll(List<HvdcEnd> listHvdcEnd) {
            HvdcEnd finalHvdcEnd = new HvdcEnd(new ArrayList<String>(), new HashSet<String>(), new HashSet<String>(), new HashSet<String>());
            listHvdcEnd.stream().forEach(hvdcEnd -> {
                finalHvdcEnd.nodesEnd.addAll(hvdcEnd.nodesEnd);
                finalHvdcEnd.transformersEnd.addAll(hvdcEnd.transformersEnd);
                finalHvdcEnd.acDcConvertersEnd.addAll(hvdcEnd.acDcConvertersEnd);
                finalHvdcEnd.dcLineSegmentsEnd.addAll(hvdcEnd.dcLineSegmentsEnd);
            });
            return finalHvdcEnd;
        }
    }

    static enum HvdcEndType {
        HVDC_TN_C1_LS1,
        HVDC_TN_C2_LS1,
        HVDC_TN_CN_LS2N,
        HVDC_TN_CN_LSN;

    }
}

