/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.elements.hvdc.Adjacency;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class Islands {
    private final List<ArrayList<String>> islandsNodes = new ArrayList<ArrayList<String>>();

    Islands(Adjacency adjacency) {
        HashSet visitedNodes = new HashSet();
        adjacency.get().keySet().forEach(nodeId -> {
            if (visitedNodes.contains(nodeId)) {
                return;
            }
            ArrayList<String> adjacentNodes = Islands.computeAdjacentNodes(nodeId, adjacency, visitedNodes);
            this.islandsNodes.add(adjacentNodes);
        });
    }

    private static ArrayList<String> computeAdjacentNodes(String nodeId, Adjacency adjacency, Set<String> visitedNodes) {
        ArrayList<String> adjacentNodes = new ArrayList<String>();
        adjacentNodes.add(nodeId);
        visitedNodes.add(nodeId);
        for (int k = 0; k < adjacentNodes.size(); ++k) {
            String node = adjacentNodes.get(k);
            if (!adjacency.get().containsKey(node)) continue;
            adjacency.get().get(node).forEach(adjacent -> {
                if (visitedNodes.contains(adjacent.node)) {
                    return;
                }
                adjacentNodes.add(adjacent.node);
                visitedNodes.add(adjacent.node);
            });
        }
        return adjacentNodes;
    }

    List<ArrayList<String>> getIslandsNodes() {
        return this.islandsNodes;
    }
}

