/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.iidm.network.HvdcLine;
import java.util.Objects;

class LossFactor {
    private final Context context;
    private final HvdcLine.ConvertersMode mode;
    private final double pAC1;
    private final double pAC2;
    private final double poleLossP1;
    private final double poleLossP2;
    private double lossFactor1;
    private double lossFactor2;

    LossFactor(Context context, HvdcLine.ConvertersMode mode, double pAC1, double pAC2, double poleLossP1, double poleLossP2) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(mode);
        this.context = context;
        this.mode = mode;
        this.pAC1 = pAC1;
        this.pAC2 = pAC2;
        this.poleLossP1 = poleLossP1;
        this.poleLossP2 = poleLossP2;
        this.lossFactor1 = Double.NaN;
        this.lossFactor2 = Double.NaN;
    }

    void compute() {
        if (this.pAC1 != 0.0 && this.pAC2 != 0.0) {
            if (this.mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER)) {
                this.computeLossFactor1(this.pAC1, this.poleLossP1, this.mode);
                this.computeLossFactor2FromPAC1(this.pAC1, this.poleLossP1, this.poleLossP2, this.mode);
            } else if (this.mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER)) {
                this.computeLossFactor1FromPAC2(this.pAC2, this.poleLossP1, this.poleLossP2, this.mode);
                this.computeLossFactor2(this.pAC2, this.poleLossP2, this.mode);
            }
        } else if (this.pAC1 != 0.0) {
            this.computeLossFactor1(this.pAC1, this.poleLossP1, this.mode);
            this.computeLossFactor2FromPAC1(this.pAC1, this.poleLossP1, this.poleLossP2, this.mode);
        } else if (this.pAC2 != 0.0) {
            this.computeLossFactor1FromPAC2(this.pAC2, this.poleLossP1, this.poleLossP2, this.mode);
            this.computeLossFactor2(this.pAC2, this.poleLossP2, this.mode);
        } else {
            this.lossFactor1 = 0.0;
            this.lossFactor2 = 0.0;
        }
        if (Double.isNaN(this.lossFactor1)) {
            this.lossFactor1 = 0.0;
            this.context.fixed("lossFactor1", "was NaN", Double.NaN, this.lossFactor1);
        }
        if (Double.isNaN(this.lossFactor2)) {
            this.lossFactor2 = 0.0;
            this.context.fixed("lossFactor2", "was NaN", Double.NaN, this.lossFactor2);
        }
    }

    private void computeLossFactor1(double pAC1, double poleLossP1, HvdcLine.ConvertersMode mode) {
        if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER)) {
            this.lossFactor1 = poleLossP1 / pAC1 * 100.0;
        } else if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER) && Math.abs(pAC1) + poleLossP1 != 0.0) {
            this.lossFactor1 = poleLossP1 / (Math.abs(pAC1) + poleLossP1) * 100.0;
        }
    }

    private void computeLossFactor2(double pAC2, double poleLossP2, HvdcLine.ConvertersMode mode) {
        if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER)) {
            this.lossFactor2 = poleLossP2 / pAC2 * 100.0;
        } else if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) && Math.abs(pAC2) + poleLossP2 != 0.0) {
            this.lossFactor2 = poleLossP2 / (Math.abs(pAC2) + poleLossP2) * 100.0;
        }
    }

    private void computeLossFactor1FromPAC2(double pAC2, double poleLossP1, double poleLossP2, HvdcLine.ConvertersMode mode) {
        if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) && Math.abs(pAC2) + poleLossP2 + poleLossP1 != 0.0) {
            this.lossFactor1 = poleLossP1 / (Math.abs(pAC2) + poleLossP2 + poleLossP1) * 100.0;
        } else if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER) && pAC2 - poleLossP2 != 0.0) {
            this.lossFactor1 = poleLossP1 / (pAC2 - poleLossP2) * 100.0;
        }
    }

    private void computeLossFactor2FromPAC1(double pAC1, double poleLossP1, double poleLossP2, HvdcLine.ConvertersMode mode) {
        if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) && pAC1 - poleLossP1 != 0.0) {
            this.lossFactor2 = poleLossP2 / (pAC1 - poleLossP1) * 100.0;
        } else if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER) && Math.abs(pAC1) + poleLossP1 + poleLossP2 != 0.0) {
            this.lossFactor2 = poleLossP2 / (Math.abs(pAC1) + poleLossP1 + poleLossP2) * 100.0;
        }
    }

    double getLossFactor1() {
        return this.lossFactor1;
    }

    double getLossFactor2() {
        return this.lossFactor2;
    }
}

