/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForTransformers;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.cgmes.extensions.CgmesTapChangersAdder;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.List;
import java.util.Optional;

abstract class AbstractTransformerConversion
extends AbstractConductingEquipmentConversion {
    AbstractTransformerConversion(String type, PropertyBags ends, Context context) {
        super(type, ends, context);
    }

    protected static void setToIidmRatioTapChanger(TapChanger rtc, RatioTapChangerAdder rtca) {
        boolean isLtcFlag = rtc.isLtcFlag();
        int lowStep = rtc.getLowTapPosition();
        int position = rtc.getTapPosition();
        ((RatioTapChangerAdder)rtca.setLoadTapChangingCapabilities(isLtcFlag).setLowTapPosition(lowStep)).setTapPosition(position);
        rtc.getSteps().forEach(step -> {
            double ratio = step.getRatio();
            double r = step.getR();
            double x = step.getX();
            double b1 = step.getB1();
            double g1 = step.getG1();
            ((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)rtca.beginStep()).setRho(1.0 / ratio)).setR(r)).setX(x)).setB(b1)).setG(g1)).endStep();
        });
        rtca.add();
    }

    protected static void setToIidmPhaseTapChanger(TapChanger ptc, PhaseTapChangerAdder ptca, Context context) {
        int lowStep = ptc.getLowTapPosition();
        int position = ptc.getTapPosition();
        ((PhaseTapChangerAdder)ptca.setLowTapPosition(lowStep)).setTapPosition(position);
        ptc.getSteps().forEach(step -> {
            double ratio = step.getRatio();
            double angle = step.getAngle();
            double r = step.getR();
            double x = step.getX();
            if (Double.isNaN(x)) {
                context.fixed("ptc.step.x", "ptc.step.x is undefined", x, 0.0);
                x = 0.0;
            }
            double b1 = step.getB1();
            double g1 = step.getG1();
            ((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)ptca.beginStep()).setRho(1.0 / ratio)).setAlpha(-angle)).setR(r)).setX(x)).setB(b1)).setG(g1)).endStep();
        });
        ptca.add();
    }

    protected RegulatingControlMappingForTransformers.CgmesRegulatingControlRatio setContextRegulatingDataRatio(TapChanger tc) {
        RegulatingControlMappingForTransformers.CgmesRegulatingControlRatio rcRtc = null;
        if (tc != null) {
            rcRtc = this.context.regulatingControlMapping().forTransformers().buildRegulatingControlRatio(tc.getId(), tc.getRegulatingControlId(), tc.getTculControlMode(), tc.isTapChangerControlEnabled());
        }
        return rcRtc;
    }

    protected RegulatingControlMappingForTransformers.CgmesRegulatingControlPhase setContextRegulatingDataPhase(TapChanger tc) {
        RegulatingControlMappingForTransformers.CgmesRegulatingControlPhase rcPtc = null;
        if (tc != null) {
            return this.context.regulatingControlMapping().forTransformers().buildRegulatingControlPhase(tc.getId(), tc.getRegulatingControlId(), tc.isTapChangerControlEnabled(), tc.isLtcFlag());
        }
        return rcPtc;
    }

    @Override
    protected void addAliasesAndProperties(Identifiable<?> identifiable) {
        List rtcs;
        super.addAliasesAndProperties(identifiable);
        int end = 1;
        for (PropertyBag p : this.ps) {
            identifiable.addAlias(p.getId("TransformerEnd"), "CGMES.TransformerEnd" + end);
            ++end;
        }
        List ptcs = this.context.cgmes().phaseTapChangerListForPowerTransformer(identifiable.getId());
        if (ptcs != null) {
            for (int i = 0; i < ptcs.size(); ++i) {
                int index = i + 1;
                Optional.ofNullable((String)ptcs.get(i)).ifPresent(ptc -> identifiable.addAlias(ptc, "CGMES.PhaseTapChanger" + index, this.context.config().isEnsureIdAliasUnicity()));
            }
        }
        if ((rtcs = this.context.cgmes().ratioTapChangerListForPowerTransformer(identifiable.getId())) != null) {
            for (int i = 0; i < rtcs.size(); ++i) {
                int index = i + 1;
                Optional.ofNullable((String)rtcs.get(i)).ifPresent(rtc -> identifiable.addAlias(rtc, "CGMES.RatioTapChanger" + index, this.context.config().isEnsureIdAliasUnicity()));
            }
        }
    }

    protected static <C extends Connectable<C>> void addCgmesReferences(C transformer, TapChanger tc) {
        if (tc == null || tc.getId() == null) {
            return;
        }
        TapChanger tch = tc.getHiddenCombinedTapChanger();
        if (tc.getRegulatingControlId() != null || tc.getType() != null || tch != null) {
            CgmesTapChangers tapChangers = (CgmesTapChangers)transformer.getExtension(CgmesTapChangers.class);
            if (tapChangers == null) {
                ((CgmesTapChangersAdder)transformer.newExtension(CgmesTapChangersAdder.class)).add();
                tapChangers = (CgmesTapChangers)transformer.getExtension(CgmesTapChangers.class);
            }
            if (tc.getRegulatingControlId() != null || tc.getType() != null) {
                tapChangers.newTapChanger().setId(tc.getId()).setType(tc.getType()).setControlId(tc.getRegulatingControlId()).add();
            }
            if (tch != null) {
                tapChangers.newTapChanger().setId(tch.getId()).setCombinedTapChangerId(tc.getId()).setHiddenStatus(true).setStep(tch.getTapPosition().intValue()).setType(tch.getType()).add();
            }
        }
    }
}

