/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForTransformers;
import com.powsybl.cgmes.conversion.elements.transformers.AbstractCgmesTapChangerBuilder;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Comparator;
import java.util.function.Supplier;

public class CgmesPhaseTapChangerBuilder
extends AbstractCgmesTapChangerBuilder {
    private final String type;
    private final String typeLowerCase;
    private final String tableId;
    private final double xtx;

    CgmesPhaseTapChangerBuilder(PropertyBag phaseTapChanger, double xtx, Context context) {
        super(phaseTapChanger, context);
        this.type = this.p.getLocal("phaseTapChangerType");
        this.typeLowerCase = this.type.toLowerCase();
        this.tableId = this.p.getId("PhaseTapChangerTable");
        this.xtx = xtx;
    }

    @Override
    public TapChanger build() {
        if (!this.validType()) {
            Supplier<String> utype = () -> "Unexpected type " + this.type;
            this.context.invalid("phaseTapChangerType", utype);
            return null;
        }
        return super.build().setType(CgmesPhaseTapChangerBuilder.toClassTypeFromClassOrKind(this.type));
    }

    private boolean validType() {
        return this.isLinear() || this.isTabular() || this.isSymmetrical() || this.isAsymmetrical();
    }

    @Override
    protected void addRegulationData() {
        String regulatingControlId = RegulatingControlMappingForTransformers.getRegulatingControlId(this.p);
        this.tapChanger.setId(this.p.getId("PhaseTapChanger")).setRegulating(this.context.regulatingControlMapping().forTransformers().getRegulating(regulatingControlId)).setRegulatingControlId(regulatingControlId).setTapChangerControlEnabled(this.p.asBoolean("tapChangerControlEnabled", false));
    }

    @Override
    protected void addSteps() {
        if (this.isLinear()) {
            this.addStepsLinear();
        } else if (this.isTabular()) {
            PropertyBags table = this.context.phaseTapChangerTable(this.tableId);
            if (table == null) {
                this.addStepsLinear();
                return;
            }
            if (this.isTableValid(this.tableId, table)) {
                this.addStepsFromTable(table);
            } else {
                this.addStepsLinear();
            }
        } else if (this.isAsymmetrical()) {
            this.addStepsAsymmetrical();
        } else if (this.isSymmetrical()) {
            this.addStepsSymmetrical();
        } else {
            this.tapChanger.beginStep().endStep();
        }
    }

    private void addStepsLinear() {
        int neutralStep = this.p.asInt("neutralStep");
        double stepPhaseShiftIncrement = this.p.asDouble("stepPhaseShiftIncrement");
        for (int step = this.lowStep; step <= this.highStep; ++step) {
            double angle = 0.0;
            if (!Double.isNaN(stepPhaseShiftIncrement) && stepPhaseShiftIncrement != 0.0) {
                angle = (double)(step - neutralStep) * stepPhaseShiftIncrement;
            }
            this.tapChanger.beginStep().setRatio(1.0).setAngle(angle).endStep();
        }
        this.stepXforLinearAndSymmetrical();
    }

    private void addStepsFromTable(PropertyBags table) {
        Comparator<PropertyBag> byStep = Comparator.comparingInt(p -> p.asInt("step"));
        table.sort(byStep);
        for (PropertyBag point : table) {
            int step = point.asInt("step");
            double angle = this.fixing(point, "angle", 0.0, this.tableId, step);
            double ratio = this.fixing(point, "ratio", 1.0, this.tableId, step);
            double r = this.fixing(point, "r", 0.0, this.tableId, step);
            double x = this.fixing(point, "x", 0.0, this.tableId, step);
            double g = this.fixing(point, "g", 0.0, this.tableId, step);
            double b = this.fixing(point, "b", 0.0, this.tableId, step);
            this.tapChanger.beginStep().setAngle(angle).setRatio(ratio).setR(r).setX(x).setG1(g).setB1(b).endStep();
        }
    }

    private void addStepsAsymmetrical() {
        int neutralStep = this.p.asInt("neutralStep");
        double stepVoltageIncrement = this.p.asDouble("voltageStepIncrement");
        double windingConnectionAngle = this.p.asDouble("windingConnectionAngle");
        for (int step2 = this.lowStep; step2 <= this.highStep; ++step2) {
            double dx = 1.0 + (double)(step2 - neutralStep) * (stepVoltageIncrement / 100.0) * Math.cos(Math.toRadians(windingConnectionAngle));
            double dy = (double)(step2 - neutralStep) * (stepVoltageIncrement / 100.0) * Math.sin(Math.toRadians(windingConnectionAngle));
            double ratio = Math.hypot(dx, dy);
            double angle = Math.toDegrees(Math.atan2(dy, dx));
            this.tapChanger.beginStep().setAngle(angle).setRatio(ratio).endStep();
        }
        double xMin = this.getXMin();
        double xMax = this.getXMax();
        if (Double.isNaN(xMin) || Double.isNaN(xMax) || xMin < 0.0 || xMax <= 0.0 || xMin > xMax) {
            return;
        }
        double alphaMax = this.tapChanger.getSteps().stream().map(TapChanger.Step::getAngle).mapToDouble(Double::doubleValue).max().orElse(0.0);
        this.tapChanger.getSteps().forEach(step -> {
            if (alphaMax == 0.0) {
                step.setX(0.0);
                return;
            }
            double alpha = step.getAngle();
            double x = CgmesPhaseTapChangerBuilder.getStepXforAsymmetrical(xMin, xMax, alpha, alphaMax, windingConnectionAngle);
            step.setX((x - this.xtx) / this.xtx * 100.0);
        });
    }

    private static double getStepXforAsymmetrical(double xStepMin, double xStepMax, double alphaDegrees, double alphaMaxDegrees, double thetaDegrees) {
        double alpha = Math.toRadians(alphaDegrees);
        double alphaMax = Math.toRadians(alphaMaxDegrees);
        double theta = Math.toRadians(thetaDegrees);
        double numer = Math.sin(theta) - Math.tan(alphaMax) * Math.cos(theta);
        double denom = Math.sin(theta) - Math.tan(alpha) * Math.cos(theta);
        return xStepMin + (xStepMax - xStepMin) * Math.pow(Math.tan(alpha) / Math.tan(alphaMax) * numer / denom, 2.0);
    }

    private void addStepsSymmetrical() {
        int neutralStep = this.p.asInt("neutralStep");
        double stepVoltageIncrement = this.p.asDouble("voltageStepIncrement");
        double stepPhaseShiftIncrement = this.p.asDouble("stepPhaseShiftIncrement");
        for (int step = this.lowStep; step <= this.highStep; ++step) {
            double angle;
            if (!Double.isNaN(stepPhaseShiftIncrement) && stepPhaseShiftIncrement != 0.0) {
                angle = (double)(step - neutralStep) * stepPhaseShiftIncrement;
            } else {
                double dy = (double)(step - neutralStep) * (stepVoltageIncrement / 100.0);
                angle = Math.toDegrees(2.0 * Math.atan(dy / 2.0));
            }
            this.tapChanger.beginStep().setRatio(1.0).setAngle(angle).endStep();
        }
        this.stepXforLinearAndSymmetrical();
    }

    private void stepXforLinearAndSymmetrical() {
        double xMin = this.getXMin();
        double xMax = this.getXMax();
        if (Double.isNaN(xMin) || Double.isNaN(xMax) || xMin < 0.0 || xMax <= 0.0 || xMin > xMax) {
            return;
        }
        double alphaMax = this.tapChanger.getSteps().stream().map(TapChanger.Step::getAngle).mapToDouble(Double::doubleValue).max().orElse(0.0);
        this.tapChanger.getSteps().forEach(step -> {
            if (alphaMax == 0.0) {
                step.setX(0.0);
                return;
            }
            double alpha = step.getAngle();
            double x = CgmesPhaseTapChangerBuilder.getStepXforLinearAndSymmetrical(xMin, xMax, alpha, alphaMax);
            step.setX(100.0 * (x - this.xtx) / this.xtx);
        });
    }

    private static double getStepXforLinearAndSymmetrical(double xStepMin, double xStepMax, double alphaDegrees, double alphaMaxDegrees) {
        double alpha = Math.toRadians(alphaDegrees);
        double alphaMax = Math.toRadians(alphaMaxDegrees);
        return xStepMin + (xStepMax - xStepMin) * Math.pow(Math.sin(alpha / 2.0) / Math.sin(alphaMax / 2.0), 2.0);
    }

    private boolean isLinear() {
        return this.typeLowerCase != null && this.typeLowerCase.endsWith("linear");
    }

    private boolean isTabular() {
        return this.tableId != null && this.typeLowerCase != null && this.typeLowerCase.endsWith("tabular");
    }

    private boolean isSymmetrical() {
        return this.typeLowerCase != null && !this.typeLowerCase.endsWith("asymmetrical") && this.typeLowerCase.endsWith("symmetrical");
    }

    private boolean isAsymmetrical() {
        return this.typeLowerCase != null && this.typeLowerCase.endsWith("asymmetrical");
    }

    private double getXMin() {
        double xMin = this.p.asDouble("xStepMin", this.p.asDouble("xMin", 0.0));
        if (xMin <= 0.0) {
            return this.xtx;
        }
        return xMin;
    }

    private double getXMax() {
        return this.p.asDouble("xStepMax", this.p.asDouble("xMax"));
    }

    private static String toClassTypeFromClassOrKind(String type) {
        if (type.startsWith("PhaseTapChangerKind.")) {
            int idot = type.indexOf(46);
            String kind = type.substring(idot + 1);
            String camelKind = kind.substring(0, 1).toUpperCase() + kind.substring(1);
            return "PhaseTapChanger" + camelKind;
        }
        return type;
    }
}

