/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForTransformers;
import com.powsybl.cgmes.conversion.elements.transformers.AbstractCgmesTapChangerBuilder;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Comparator;

public class CgmesRatioTapChangerBuilder
extends AbstractCgmesTapChangerBuilder {
    CgmesRatioTapChangerBuilder(PropertyBag ratioTapChanger, Context context) {
        super(ratioTapChanger, context);
    }

    @Override
    protected void addRegulationData() {
        String regulatingControlId = RegulatingControlMappingForTransformers.getRegulatingControlId(this.p);
        this.tapChanger.setId(this.p.getId("RatioTapChanger")).setRegulating(this.context.regulatingControlMapping().forTransformers().getRegulating(regulatingControlId)).setRegulatingControlId(regulatingControlId).setTculControlMode((String)this.p.get((Object)"tculControlMode")).setTapChangerControlEnabled(this.p.asBoolean("tapChangerControlEnabled", false));
    }

    @Override
    protected void addSteps() {
        String tableId = this.p.getId("RatioTapChangerTable");
        if (tableId != null) {
            PropertyBags table = this.context.ratioTapChangerTable(tableId);
            if (table == null) {
                this.addStepsFromLowHighIncrement();
                return;
            }
            if (this.isTableValid(tableId, table)) {
                this.addStepsFromTable(table, tableId);
            } else {
                this.addStepsFromLowHighIncrement();
            }
        } else {
            this.addStepsFromLowHighIncrement();
        }
    }

    private void addStepsFromTable(PropertyBags table, String tableId) {
        Comparator<PropertyBag> byStep = Comparator.comparingInt(p -> p.asInt("step"));
        table.sort(byStep);
        for (PropertyBag point : table) {
            int step = point.asInt("step");
            double ratio = this.fixing(point, "ratio", 1.0, tableId, step);
            double r = this.fixing(point, "r", 0.0, tableId, step);
            double x = this.fixing(point, "x", 0.0, tableId, step);
            double g = this.fixing(point, "g", 0.0, tableId, step);
            double b = this.fixing(point, "b", 0.0, tableId, step);
            this.tapChanger.beginStep().setRatio(ratio).setR(r).setX(x).setG1(g).setB1(b).endStep();
        }
    }

    private void addStepsFromLowHighIncrement() {
        double stepVoltageIncrement = this.p.asDouble("stepVoltageIncrement");
        int neutralStep = this.p.asInt("neutralStep");
        for (int step = this.lowStep; step <= this.highStep; ++step) {
            double ratio = 1.0 + (double)(step - neutralStep) * (stepVoltageIncrement / 100.0);
            this.tapChanger.beginStep().setRatio(ratio).endStep();
        }
    }
}

