/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export;

import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.LoadGroup;
import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class LoadGroups {
    Map<String, LoadGroup> uniqueGroupByClass = new HashMap<String, LoadGroup>();
    static final Map<String, String> GROUP_CLASS_NAMES = Map.of("ConformLoad", "ConformLoadGroup", "NonConformLoad", "NonConformLoadGroup");
    static final Map<String, String> GROUP_NAMES = Map.of("ConformLoad", "Conform loads", "NonConformLoad", "NonConform loads");

    LoadGroups() {
    }

    Collection<LoadGroup> found() {
        return this.uniqueGroupByClass.values();
    }

    String groupFor(String loadClassName, CgmesExportContext context) {
        if (loadClassName.equals("EnergyConsumer") || loadClassName.equals("StationSupply")) {
            return null;
        }
        LoadGroup loadGroup = this.uniqueGroupByClass.get(loadClassName);
        if (loadGroup == null) {
            loadGroup = this.createGroupFor(loadClassName, context);
        }
        return loadGroup.id;
    }

    LoadGroup createGroupFor(String loadClassName, CgmesExportContext context) {
        String id = context.getNamingStrategy().getCgmesId(CgmesObjectReference.ref(loadClassName), CgmesObjectReference.Part.LOAD_GROUP);
        String className = GROUP_CLASS_NAMES.get(loadClassName);
        String groupName = GROUP_NAMES.get(loadClassName);
        LoadGroup loadGroup = new LoadGroup(className, id, groupName);
        this.uniqueGroupByClass.put(loadClassName, loadGroup);
        return loadGroup;
    }
}

