/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export;

import com.powsybl.cgmes.conversion.CgmesImport;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.triplestore.CgmesModelTripleStore;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.datasource.ReadOnlyMemDataSource;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceDataProvider {
    private String sourcingActorName;
    private final String countryName;
    private final ReadOnlyDataSource referenceDataSource;
    private final CgmesImport cgmesImport;
    private final Properties params;
    private PropertyBag sourcingActor;
    private CgmesModel referenceData = null;
    private final Map<Double, String> baseVoltagesByNominalVoltage = new HashMap<Double, String>();
    private String equipmentBoundaryId = null;
    private String topologyBoundaryId = null;
    private boolean loaded = false;
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceDataProvider.class);

    public ReferenceDataProvider(String sourcingActorName, String countryName, CgmesImport cgmesImport, Properties params) {
        this(sourcingActorName, countryName, null, cgmesImport, params);
    }

    public ReferenceDataProvider(String sourcingActorName, String countryName, ReadOnlyDataSource referenceDataSource, CgmesImport cgmesImport, Properties params) {
        Objects.requireNonNull(cgmesImport);
        this.sourcingActorName = sourcingActorName;
        this.countryName = countryName;
        this.referenceDataSource = referenceDataSource;
        this.cgmesImport = cgmesImport;
        this.params = params;
    }

    public String getBaseVoltage(double nominalV) {
        this.ensureReferenceDataIsLoaded();
        return this.baseVoltagesByNominalVoltage.get(nominalV);
    }

    public PropertyBag getSourcingActor() {
        this.ensureReferenceDataIsLoaded();
        return this.sourcingActor;
    }

    public Pair<String, String> getSourcingActorRegion() {
        this.ensureReferenceDataIsLoaded();
        if (this.sourcingActor.containsKey((Object)"GeographicalRegion") && this.sourcingActor.containsKey((Object)"geographicalRegionName")) {
            return Pair.of((Object)this.sourcingActor.getId("GeographicalRegion"), (Object)this.sourcingActor.getLocal("geographicalRegionName"));
        }
        return null;
    }

    public String getEquipmentBoundaryId() {
        this.ensureReferenceDataIsLoaded();
        return this.equipmentBoundaryId;
    }

    public String getTopologyBoundaryId() {
        this.ensureReferenceDataIsLoaded();
        return this.topologyBoundaryId;
    }

    private void ensureReferenceDataIsLoaded() {
        if (this.loaded) {
            return;
        }
        this.loadReferenceData();
        this.loadBoundaryModelIds();
        this.loadBaseVoltages();
        this.loadSourcingActor();
        this.loaded = true;
    }

    private void loadReferenceData() {
        this.loadReferenceData(Objects.requireNonNullElseGet(this.referenceDataSource, ReadOnlyMemDataSource::new));
    }

    private void loadReferenceData(ReadOnlyDataSource ds) {
        try {
            this.referenceData = this.cgmesImport.readCgmes(ds, this.params, ReportNode.NO_OP);
        }
        catch (CgmesModelException x) {
            this.referenceData = null;
        }
    }

    private void loadBoundaryModelIds() {
        if (this.referenceData == null) {
            return;
        }
        CgmesModel cgmesModel = this.referenceData;
        if (!(cgmesModel instanceof CgmesModelTripleStore)) {
            return;
        }
        CgmesModelTripleStore referenceDataTs = (CgmesModelTripleStore)cgmesModel;
        PropertyBags boundaryModelIds = referenceDataTs.namedQuery("boundaryModelIds", new String[0]);
        for (PropertyBag mid : boundaryModelIds) {
            String modelId = mid.getId("FullModel");
            String profile = mid.getLocal("profile");
            if (profile.contains("EquipmentBoundary")) {
                this.equipmentBoundaryId = modelId;
                continue;
            }
            if (!profile.contains("TopologyBoundary")) continue;
            this.topologyBoundaryId = modelId;
        }
    }

    private void loadBaseVoltages() {
        if (this.referenceData == null) {
            return;
        }
        this.baseVoltagesByNominalVoltage.clear();
        this.baseVoltagesByNominalVoltage.putAll(this.referenceData.baseVoltages().stream().collect(Collectors.toMap(bv -> bv.asDouble("nominalVoltage"), bv -> bv.getId("BaseVoltage"))));
    }

    private void loadSourcingActor() {
        if (this.referenceData != null) {
            if (this.sourcingActorName == null || this.sourcingActorName.isEmpty()) {
                this.determineSourcingActorFromCountryName();
            }
            if (this.sourcingActorName != null && !this.sourcingActorName.isEmpty()) {
                PropertyBags sourcingActorRecords = this.referenceData.sourcingActor(this.sourcingActorName);
                if (sourcingActorRecords.size() > 1 && LOG.isWarnEnabled()) {
                    LOG.warn("Multiple records found for sourcing actor {}. Will consider only first one", (Object)this.sourcingActorName);
                    LOG.warn(sourcingActorRecords.tabulateLocals());
                } else if (sourcingActorRecords.isEmpty()) {
                    LOG.warn("Sourcing actor {} not found", (Object)this.sourcingActorName);
                } else {
                    this.sourcingActor = (PropertyBag)sourcingActorRecords.get(0);
                }
            }
        }
        if (this.sourcingActor == null) {
            this.sourcingActor = new PropertyBag(Collections.emptyList(), true);
        }
    }

    private void determineSourcingActorFromCountryName() {
        if (this.referenceData != null && this.countryName != null && !this.countryName.isEmpty()) {
            PropertyBags countryRecords = this.referenceData.countrySourcingActors(this.countryName);
            if (countryRecords.size() > 1 && LOG.isWarnEnabled()) {
                LOG.warn("Multiple sourcing actors found for country {}. Cannot determine a single sourcing actor", (Object)this.countryName);
                LOG.warn(countryRecords.tabulateLocals());
            } else if (countryRecords.isEmpty()) {
                LOG.warn("No sourcing actors found for country name {}", (Object)this.countryName);
            } else {
                this.sourcingActorName = ((PropertyBag)countryRecords.get(0)).getLocal("sourcingActorName");
            }
        }
    }
}

