/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export;

import com.powsybl.cgmes.conversion.CgmesExport;
import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.cgmes.extensions.CgmesControlArea;
import com.powsybl.cgmes.extensions.CgmesControlAreas;
import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.extensions.ActivePowerControl;
import com.powsybl.iidm.network.extensions.ReferencePriority;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SteadyStateHypothesisExport {
    private static final Logger LOG = LoggerFactory.getLogger(SteadyStateHypothesisExport.class);
    private static final String REGULATING_CONTROL_PROPERTY = "CGMES.RegulatingControl";
    private static final String GENERATING_UNIT_PROPERTY = "CGMES.GeneratingUnit";
    private static final String ROTATING_MACHINE_P = "RotatingMachine.p";
    private static final String ROTATING_MACHINE_Q = "RotatingMachine.q";
    private static final String REGULATING_COND_EQ_CONTROL_ENABLED = "RegulatingCondEq.controlEnabled";
    private static final String ALIAS_TYPE_TERMINAL_1 = "CGMES.Terminal1";
    private static final String ALIAS_TYPE_TERMINAL_2 = "CGMES.Terminal2";

    private SteadyStateHypothesisExport() {
    }

    public static void write(Network network, XMLStreamWriter writer, CgmesExportContext context) {
        CgmesMetadataModel model = CgmesExport.initializeModelForExport(network, CgmesSubset.STEADY_STATE_HYPOTHESIS, context, true, false);
        SteadyStateHypothesisExport.write(network, writer, context, model);
    }

    public static void write(Network network, XMLStreamWriter writer, CgmesExportContext context, CgmesMetadataModel model) {
        HashMap<String, List<RegulatingControlView>> regulatingControlViews = new HashMap<String, List<RegulatingControlView>>();
        String cimNamespace = context.getCim().getNamespace();
        try {
            CgmesExportUtil.writeRdfRoot(cimNamespace, context.getCim().getEuPrefix(), context.getCim().getEuNamespace(), writer);
            if (context.getCimVersion() >= 16) {
                CgmesExportUtil.writeModelDescription(network, CgmesSubset.STEADY_STATE_HYPOTHESIS, writer, model, context);
            }
            SteadyStateHypothesisExport.writeLoads(network, cimNamespace, writer, context);
            SteadyStateHypothesisExport.writeEquivalentInjections(network, cimNamespace, writer, context);
            SteadyStateHypothesisExport.writeTapChangers(network, cimNamespace, regulatingControlViews, writer, context);
            SteadyStateHypothesisExport.writeGenerators(network, cimNamespace, regulatingControlViews, writer, context);
            SteadyStateHypothesisExport.writeBatteries(network, cimNamespace, writer, context);
            SteadyStateHypothesisExport.writeShuntCompensators(network, cimNamespace, regulatingControlViews, writer, context);
            SteadyStateHypothesisExport.writeStaticVarCompensators(network, cimNamespace, regulatingControlViews, writer, context);
            SteadyStateHypothesisExport.writeRegulatingControls(regulatingControlViews, cimNamespace, writer, context);
            SteadyStateHypothesisExport.writeGeneratingUnitsParticitationFactors(network, cimNamespace, writer, context);
            SteadyStateHypothesisExport.writeConverters(network, cimNamespace, writer, context);
            SteadyStateHypothesisExport.writeSwitches(network, cimNamespace, writer, context);
            SteadyStateHypothesisExport.writeTerminals(network, cimNamespace, writer, context);
            SteadyStateHypothesisExport.writeControlAreas(network, cimNamespace, writer, context);
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeSwitches(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        for (Switch sw : network.getSwitches()) {
            if (!context.isExportedEquipment((Identifiable<?>)sw)) continue;
            SteadyStateHypothesisExport.writeSwitch(sw, cimNamespace, writer, context);
        }
    }

    private static void writeTerminalForSwitches(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        for (Switch sw : network.getSwitches()) {
            if (!context.isExportedEquipment((Identifiable<?>)sw)) continue;
            if (sw.getAliasFromType(ALIAS_TYPE_TERMINAL_1).isPresent()) {
                SteadyStateHypothesisExport.writeTerminal(context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)sw, ALIAS_TYPE_TERMINAL_1), true, cimNamespace, writer, context);
            }
            if (!sw.getAliasFromType(ALIAS_TYPE_TERMINAL_2).isPresent()) continue;
            SteadyStateHypothesisExport.writeTerminal(context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)sw, ALIAS_TYPE_TERMINAL_2), true, cimNamespace, writer, context);
        }
    }

    private static void writeTerminalForDanglingLines(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        for (DanglingLine dl : network.getDanglingLines(DanglingLineFilter.ALL)) {
            if (dl.getProperty("CGMES.EquivalentInjectionTerminal") != null) {
                SteadyStateHypothesisExport.writeTerminal(context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)dl, "CGMES.EquivalentInjectionTerminal"), true, cimNamespace, writer, context);
            }
            if (!dl.getAliasFromType("CGMES.Terminal_Boundary").isPresent()) continue;
            SteadyStateHypothesisExport.writeTerminal(context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)dl, "CGMES.Terminal_Boundary"), true, cimNamespace, writer, context);
        }
    }

    private static void writeTerminalForBuses(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        for (Bus b : network.getBusBreakerView().getBuses()) {
            String bbsTerminals = b.getProperty("CGMES.busbarSectionTerminals", "");
            if (bbsTerminals.isEmpty()) continue;
            for (String bbsTerminal : bbsTerminals.split(",")) {
                SteadyStateHypothesisExport.writeTerminal(bbsTerminal, true, cimNamespace, writer, context);
            }
        }
    }

    private static void writeTerminals(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        for (Connectable c : network.getConnectables()) {
            if (!context.isExportedEquipment((Identifiable<?>)c)) continue;
            if (CgmesExportUtil.isEquivalentShuntWithZeroSectionCount(c)) {
                SteadyStateHypothesisExport.writeTerminal(CgmesExportUtil.getTerminalId((Terminal)c.getTerminals().get(0), context), false, cimNamespace, writer, context);
                continue;
            }
            for (Terminal t : c.getTerminals()) {
                SteadyStateHypothesisExport.writeTerminal(t, cimNamespace, writer, context);
            }
        }
        SteadyStateHypothesisExport.writeTerminalForSwitches(network, cimNamespace, writer, context);
        SteadyStateHypothesisExport.writeTerminalForDanglingLines(network, cimNamespace, writer, context);
        if (!context.isExportEquipment()) {
            SteadyStateHypothesisExport.writeTerminalForBuses(network, cimNamespace, writer, context);
        }
    }

    private static void writeEquivalentInjections(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        ArrayList<String> exported = new ArrayList<String>();
        for (DanglingLine dl : network.getDanglingLines(DanglingLineFilter.ALL)) {
            String ei = dl.getProperty("CGMES.EquivalentInjection");
            if (exported.contains(ei) || ei == null) continue;
            String cgmesId = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)dl, "CGMES.EquivalentInjection");
            boolean regulationStatus = false;
            double regulationTarget = 0.0;
            if (dl.getGeneration() != null) {
                regulationStatus = dl.getGeneration().isVoltageRegulationOn();
                regulationTarget = dl.getGeneration().getTargetV();
            }
            SteadyStateHypothesisExport.writeEquivalentInjection(cgmesId, dl.getP0(), dl.getQ0(), regulationStatus, regulationTarget, cimNamespace, writer, context);
            exported.add(ei);
        }
    }

    private static String cgmesTapChangerId(TwoWindingsTransformer twt, String tapChangerKind, CgmesExportContext context) {
        String aliasType = "CGMES." + tapChangerKind + "1";
        if (twt.getAliasFromType(aliasType).isEmpty()) {
            aliasType = "CGMES." + tapChangerKind + "2";
        }
        return context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, aliasType);
    }

    private static void writeTapChangers(Network network, String cimNamespace, Map<String, List<RegulatingControlView>> regulatingControlViews, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (TwoWindingsTransformer twt : network.getTwoWindingsTransformers()) {
            if (twt.hasPhaseTapChanger()) {
                String ptcId = SteadyStateHypothesisExport.cgmesTapChangerId(twt, "PhaseTapChanger", context);
                SteadyStateHypothesisExport.writeTapChanger(twt, ptcId, twt.getPhaseTapChanger(), "PhaseTapChangerTabular", regulatingControlViews, cimNamespace, writer, context);
            }
            if (!twt.hasRatioTapChanger()) continue;
            String rtcId = SteadyStateHypothesisExport.cgmesTapChangerId(twt, "RatioTapChanger", context);
            SteadyStateHypothesisExport.writeTapChanger(twt, rtcId, twt.getRatioTapChanger(), "RatioTapChanger", regulatingControlViews, cimNamespace, writer, context);
        }
        for (TwoWindingsTransformer twt : network.getThreeWindingsTransformers()) {
            int i = 1;
            for (ThreeWindingsTransformer.Leg leg : Arrays.asList(twt.getLeg1(), twt.getLeg2(), twt.getLeg3())) {
                if (leg.hasPhaseTapChanger()) {
                    String ptcId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.PhaseTapChanger" + i);
                    SteadyStateHypothesisExport.writeTapChanger(twt, ptcId, leg.getPhaseTapChanger(), "PhaseTapChangerTabular", regulatingControlViews, cimNamespace, writer, context);
                }
                if (leg.hasRatioTapChanger()) {
                    String rtcId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.RatioTapChanger" + i);
                    SteadyStateHypothesisExport.writeTapChanger(twt, rtcId, leg.getRatioTapChanger(), "RatioTapChanger", regulatingControlViews, cimNamespace, writer, context);
                }
                ++i;
            }
        }
    }

    private static <C extends Connectable<C>> void writeTapChanger(C eq, String tcId, TapChanger<?, ?, ?, ?> tc, String defaultType, Map<String, List<RegulatingControlView>> regulatingControlViews, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String type = CgmesExportUtil.cgmesTapChangerType(eq, tcId).orElse(defaultType);
        SteadyStateHypothesisExport.writeTapChanger(type, tcId, tc, cimNamespace, writer, context);
        CgmesTapChangers cgmesTcs = (CgmesTapChangers)eq.getExtension(CgmesTapChangers.class);
        CgmesTapChanger cgmesTc = null;
        if (cgmesTcs != null) {
            cgmesTc = cgmesTcs.getTapChanger(tcId);
        }
        SteadyStateHypothesisExport.addRegulatingControlView(tc, cgmesTc, regulatingControlViews);
        if (cgmesTcs != null && !context.isExportEquipment()) {
            for (CgmesTapChanger tapChanger : cgmesTcs.getTapChangers()) {
                if (!tapChanger.isHidden() || !tapChanger.getCombinedTapChangerId().equals(tcId)) continue;
                SteadyStateHypothesisExport.writeHiddenTapChanger(tapChanger, defaultType, cimNamespace, writer, context);
            }
        }
    }

    private static void writeShuntCompensators(Network network, String cimNamespace, Map<String, List<RegulatingControlView>> regulatingControlViews, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (ShuntCompensator s : network.getShuntCompensators()) {
            if ("true".equals(s.getProperty("CGMES.isEquivalentShunt"))) continue;
            String shuntType = switch (s.getModelType()) {
                case ShuntCompensatorModelType.LINEAR -> "Linear";
                case ShuntCompensatorModelType.NON_LINEAR -> "Nonlinear";
                default -> throw new IllegalStateException("Unexpected shunt model type: " + s.getModelType());
            };
            boolean controlEnabled = s.isVoltageRegulatorOn();
            CgmesExportUtil.writeStartAbout(shuntType + "ShuntCompensator", context.getNamingStrategy().getCgmesId((Identifiable<?>)s), cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, "ShuntCompensator.sections");
            writer.writeCharacters(CgmesExportUtil.format(s.getSectionCount()));
            writer.writeEndElement();
            writer.writeStartElement(cimNamespace, REGULATING_COND_EQ_CONTROL_ENABLED);
            writer.writeCharacters(Boolean.toString(controlEnabled));
            writer.writeEndElement();
            writer.writeEndElement();
            SteadyStateHypothesisExport.addRegulatingControlView(s, regulatingControlViews, context);
        }
    }

    private static void addRegulatingControlView(ShuntCompensator s, Map<String, List<RegulatingControlView>> regulatingControlViews, CgmesExportContext context) {
        if (s.hasProperty(REGULATING_CONTROL_PROPERTY)) {
            String rcid = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)s, REGULATING_CONTROL_PROPERTY);
            RegulatingControlView rcv = new RegulatingControlView(rcid, RegulatingControlType.REGULATING_CONTROL, true, s.isVoltageRegulatorOn(), s.getTargetDeadband(), s.getTargetV(), "k");
            regulatingControlViews.computeIfAbsent(rcid, k -> new ArrayList()).add(rcv);
        }
    }

    private static void writeGenerators(Network network, String cimNamespace, Map<String, List<RegulatingControlView>> regulatingControlViews, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        block10: for (Generator g : network.getGenerators()) {
            String cgmesOriginalClass;
            switch (cgmesOriginalClass = g.getProperty("CGMES.originalClass", "SynchronousMachine")) {
                case "EquivalentInjection": {
                    SteadyStateHypothesisExport.writeEquivalentInjection(context.getNamingStrategy().getCgmesId((Identifiable<?>)g), -g.getTargetP(), -g.getTargetQ(), g.isVoltageRegulatorOn(), g.getTargetV(), cimNamespace, writer, context);
                    continue block10;
                }
                case "ExternalNetworkInjection": {
                    SteadyStateHypothesisExport.writeExternalNetworkInjection(context.getNamingStrategy().getCgmesId((Identifiable<?>)g), g.isVoltageRegulatorOn(), -g.getTargetP(), -g.getTargetQ(), ReferencePriority.get((Injection)g), cimNamespace, writer, context);
                    SteadyStateHypothesisExport.addRegulatingControlView(g, regulatingControlViews, context);
                    continue block10;
                }
                case "SynchronousMachine": {
                    SteadyStateHypothesisExport.writeSynchronousMachine(context.getNamingStrategy().getCgmesId((Identifiable<?>)g), g.isVoltageRegulatorOn(), -g.getTargetP(), -g.getTargetQ(), ReferencePriority.get((Injection)g), SteadyStateHypothesisExport.obtainOperatingMode(g, g.getMinP(), g.getMaxP(), g.getTargetP()), cimNamespace, writer, context);
                    SteadyStateHypothesisExport.addRegulatingControlView(g, regulatingControlViews, context);
                    continue block10;
                }
            }
            throw new PowsyblException("Unexpected cgmes equipment " + cgmesOriginalClass);
        }
    }

    private static void writeExternalNetworkInjection(String id, boolean controlEnabled, double p, double q, int referencePriority, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("ExternalNetworkInjection", id, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, REGULATING_COND_EQ_CONTROL_ENABLED);
        writer.writeCharacters(Boolean.toString(controlEnabled));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "ExternalNetworkInjection.p");
        writer.writeCharacters(CgmesExportUtil.format(p));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "ExternalNetworkInjection.q");
        writer.writeCharacters(CgmesExportUtil.format(q));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "ExternalNetworkInjection.referencePriority");
        writer.writeCharacters(Integer.toString(referencePriority));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void writeSynchronousMachine(String id, boolean controlEnabled, double p, double q, int referencePriority, String mode, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("SynchronousMachine", id, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, REGULATING_COND_EQ_CONTROL_ENABLED);
        writer.writeCharacters(Boolean.toString(controlEnabled));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, ROTATING_MACHINE_P);
        writer.writeCharacters(CgmesExportUtil.format(p));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, ROTATING_MACHINE_Q);
        writer.writeCharacters(CgmesExportUtil.format(q));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "SynchronousMachine.referencePriority");
        writer.writeCharacters(Integer.toString(referencePriority));
        writer.writeEndElement();
        writer.writeEmptyElement(cimNamespace, "SynchronousMachine.operatingMode");
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + "SynchronousMachineOperatingMode." + mode);
        writer.writeEndElement();
    }

    private static void writeBatteries(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Battery b : network.getBatteries()) {
            SteadyStateHypothesisExport.writeSynchronousMachine(context.getNamingStrategy().getCgmesId((Identifiable<?>)b), false, -b.getTargetP(), -b.getTargetQ(), ReferencePriority.get((Injection)b), SteadyStateHypothesisExport.obtainOperatingMode(b, b.getMinP(), b.getMaxP(), b.getTargetP()), cimNamespace, writer, context);
        }
    }

    private static <I extends ReactiveLimitsHolder & Injection<I>> String obtainOperatingMode(I i, double minP, double maxP, double targetP) {
        String kind = ((Identifiable)i).getProperty("CGMES.synchronousMachineType");
        String operatingMode = ((Identifiable)i).getProperty("CGMES.synchronousMachineOperatingMode");
        String calculatedKind = CgmesExportUtil.obtainCalculatedSynchronousMachineKind(minP, maxP, CgmesExportUtil.obtainCurve(i), kind);
        String calculatedOperatingMode = SteadyStateHypothesisExport.obtainOperatingMode(targetP);
        return operatingMode != null && calculatedKind.contains(operatingMode) ? operatingMode : calculatedOperatingMode;
    }

    private static String obtainOperatingMode(double targetP) {
        if (targetP < 0.0) {
            return "motor";
        }
        if (targetP > 0.0) {
            return "generator";
        }
        return "condenser";
    }

    private static void addRegulatingControlView(Generator g, Map<String, List<RegulatingControlView>> regulatingControlViews, CgmesExportContext context) {
        if (g.hasProperty(REGULATING_CONTROL_PROPERTY)) {
            String rcid = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)g, REGULATING_CONTROL_PROPERTY);
            double targetDeadband = 0.0;
            RegulatingControlView rcv = new RegulatingControlView(rcid, RegulatingControlType.REGULATING_CONTROL, false, g.isVoltageRegulatorOn(), targetDeadband, g.getTargetV(), "k");
            regulatingControlViews.computeIfAbsent(rcid, k -> new ArrayList()).add(rcv);
        }
    }

    private static boolean isValidSvcVolatgeSetpoint(double v) {
        return Double.isFinite(v) && v > 0.0;
    }

    private static boolean isValidSvcReactivePowerSetpoint(double q) {
        return Double.isFinite(q);
    }

    private static void writeStaticVarCompensators(Network network, String cimNamespace, Map<String, List<RegulatingControlView>> regulatingControlViews, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (StaticVarCompensator svc : network.getStaticVarCompensators()) {
            String multiplier;
            double targetValue;
            StaticVarCompensator.RegulationMode regulationMode = svc.getRegulationMode();
            boolean controlEnabled = regulationMode != StaticVarCompensator.RegulationMode.OFF;
            CgmesExportUtil.writeStartAbout("StaticVarCompensator", context.getNamingStrategy().getCgmesId((Identifiable<?>)svc), cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, REGULATING_COND_EQ_CONTROL_ENABLED);
            writer.writeCharacters(Boolean.toString(controlEnabled));
            writer.writeEndElement();
            writer.writeStartElement(cimNamespace, "StaticVarCompensator.q");
            writer.writeCharacters(CgmesExportUtil.format(svc.getTerminal().getQ()));
            writer.writeEndElement();
            writer.writeEndElement();
            if (!svc.hasProperty(REGULATING_CONTROL_PROPERTY)) continue;
            String rcid = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)svc, REGULATING_CONTROL_PROPERTY);
            double targetDeadband = 0.0;
            if (regulationMode == StaticVarCompensator.RegulationMode.VOLTAGE || regulationMode == StaticVarCompensator.RegulationMode.OFF && SteadyStateHypothesisExport.isValidSvcVolatgeSetpoint(svc.getVoltageSetpoint())) {
                targetValue = svc.getVoltageSetpoint();
                multiplier = "k";
            } else if (regulationMode == StaticVarCompensator.RegulationMode.REACTIVE_POWER || regulationMode == StaticVarCompensator.RegulationMode.OFF && SteadyStateHypothesisExport.isValidSvcReactivePowerSetpoint(svc.getReactivePowerSetpoint())) {
                targetValue = svc.getReactivePowerSetpoint();
                multiplier = "M";
            } else {
                targetValue = 0.0;
                multiplier = "k";
            }
            RegulatingControlView rcv = new RegulatingControlView(rcid, RegulatingControlType.REGULATING_CONTROL, false, controlEnabled, targetDeadband, targetValue, multiplier);
            regulatingControlViews.computeIfAbsent(rcid, k -> new ArrayList()).add(rcv);
        }
    }

    private static void writeTapChanger(String type, String id, TapChanger<?, ?, ?, ?> tc, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        SteadyStateHypothesisExport.writeTapChanger(type, id, tc.isRegulating(), tc.getTapPosition(), cimNamespace, writer, context);
    }

    private static void writeTapChanger(String type, String id, boolean controlEnabled, int step, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout(type, id, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "TapChanger.controlEnabled");
        writer.writeCharacters(Boolean.toString(controlEnabled));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "TapChanger.step");
        writer.writeCharacters(CgmesExportUtil.format(step));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void addRegulatingControlView(TapChanger<?, ?, ?, ?> tc, CgmesTapChanger cgmesTc, Map<String, List<RegulatingControlView>> regulatingControlViews) {
        if (cgmesTc != null && cgmesTc.getControlId() != null) {
            PhaseTapChanger phaseTapChanger;
            RatioTapChanger ratioTapChanger;
            String controlId = cgmesTc.getControlId();
            RegulatingControlView rcv = null;
            if (tc instanceof RatioTapChanger && CgmesExportUtil.regulatingControlIsDefined(ratioTapChanger = (RatioTapChanger)tc)) {
                rcv = new RegulatingControlView(controlId, RegulatingControlType.TAP_CHANGER_CONTROL, true, ratioTapChanger.isRegulating(), ratioTapChanger.getTargetDeadband(), ratioTapChanger.getTargetV(), "k");
            } else if (tc instanceof PhaseTapChanger && CgmesExportUtil.regulatingControlIsDefined(phaseTapChanger = (PhaseTapChanger)tc)) {
                String unitMultiplier;
                boolean valid;
                switch (phaseTapChanger.getRegulationMode()) {
                    case CURRENT_LIMITER: {
                        valid = true;
                        String string = "none";
                        break;
                    }
                    case ACTIVE_POWER_CONTROL: {
                        valid = true;
                        String string = "M";
                        break;
                    }
                    default: {
                        valid = false;
                        String string = unitMultiplier = "none";
                    }
                }
                if (valid) {
                    rcv = new RegulatingControlView(controlId, RegulatingControlType.TAP_CHANGER_CONTROL, true, phaseTapChanger.isRegulating(), phaseTapChanger.getTargetDeadband(), phaseTapChanger.getRegulationValue(), unitMultiplier);
                }
            }
            if (rcv != null) {
                regulatingControlViews.computeIfAbsent(controlId, k -> new ArrayList()).add(rcv);
            }
        }
    }

    private static void writeHiddenTapChanger(CgmesTapChanger cgmesTc, String defaultType, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        SteadyStateHypothesisExport.writeTapChanger(Optional.ofNullable(cgmesTc.getType()).orElse(defaultType), cgmesTc.getId(), false, cgmesTc.getStep().orElseThrow(() -> new PowsyblException("Non null step expected for tap changer " + cgmesTc.getId())), cimNamespace, writer, context);
    }

    private static void writeRegulatingControls(Map<String, List<RegulatingControlView>> regulatingControlViews, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (List<RegulatingControlView> views : regulatingControlViews.values()) {
            SteadyStateHypothesisExport.writeRegulatingControl(SteadyStateHypothesisExport.combineRegulatingControlViews(views), cimNamespace, writer, context);
        }
    }

    private static RegulatingControlView combineRegulatingControlViews(List<RegulatingControlView> rcs) {
        RegulatingControlView combined = rcs.get(0);
        if (rcs.size() > 1 && LOG.isWarnEnabled()) {
            LOG.warn("Multiple views ({}) for regulating control {} are combined", (Object)rcs.size(), (Object)rcs.get((int)0).id);
        }
        for (int k = 1; k < rcs.size(); ++k) {
            RegulatingControlView current = rcs.get(k);
            if (combined.targetDeadband == 0.0 && current.targetDeadband > 0.0) {
                combined.targetDeadband = current.targetDeadband;
            }
            if (!combined.discrete && current.discrete) {
                combined.discrete = true;
            }
            if (combined.controlEnabled || !current.controlEnabled) continue;
            combined.controlEnabled = true;
        }
        return combined;
    }

    private static void writeRegulatingControl(RegulatingControlView rc, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout(SteadyStateHypothesisExport.regulatingControlClassname(rc.type), rc.id, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "RegulatingControl.discrete");
        writer.writeCharacters(Boolean.toString(rc.discrete));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "RegulatingControl.enabled");
        writer.writeCharacters(Boolean.toString(rc.controlEnabled));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "RegulatingControl.targetDeadband");
        writer.writeCharacters(CgmesExportUtil.format(rc.targetDeadband));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "RegulatingControl.targetValue");
        writer.writeCharacters(CgmesExportUtil.format(rc.targetValue));
        writer.writeEndElement();
        writer.writeEmptyElement(cimNamespace, "RegulatingControl.targetValueUnitMultiplier");
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + "UnitMultiplier." + rc.targetValueUnitMultiplier);
        writer.writeEndElement();
    }

    private static String regulatingControlClassname(RegulatingControlType type) {
        if (type == RegulatingControlType.TAP_CHANGER_CONTROL) {
            return "TapChangerControl";
        }
        return "RegulatingControl";
    }

    private static void writeSwitch(Switch sw, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        try {
            String switchType = sw.getProperty("CGMES.switchType");
            String className = switchType != null ? switchType : CgmesExportUtil.switchClassname(sw.getKind());
            CgmesExportUtil.writeStartAbout(className, context.getNamingStrategy().getCgmesId((Identifiable<?>)sw), cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, "Switch.open");
            writer.writeCharacters(Boolean.toString(sw.isOpen()));
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeTerminal(Terminal t, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        SteadyStateHypothesisExport.writeTerminal(CgmesExportUtil.getTerminalId(t, context), t.isConnected(), cimNamespace, writer, context);
    }

    private static void writeTerminal(String terminalId, boolean connected, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        try {
            CgmesExportUtil.writeStartAbout("Terminal", terminalId, cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, "ACDCTerminal.connected");
            writer.writeCharacters(Boolean.toString(connected));
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeEquivalentInjection(String cgmesId, double p, double q, boolean regulationStatus, double regulationTarget, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("EquivalentInjection", cgmesId, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "EquivalentInjection.p");
        writer.writeCharacters(CgmesExportUtil.format(p));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "EquivalentInjection.q");
        writer.writeCharacters(CgmesExportUtil.format(q));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "EquivalentInjection.regulationStatus");
        writer.writeCharacters(Boolean.toString(regulationStatus));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "EquivalentInjection.regulationTarget");
        writer.writeCharacters(CgmesExportUtil.format(regulationTarget));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void writeLoads(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        block13: for (Load load : network.getLoads()) {
            String className;
            if (!context.isExportedEquipment((Identifiable<?>)load)) continue;
            switch (className = SteadyStateHypothesisExport.obtainLoadClassName(load, context)) {
                case "AsynchronousMachine": {
                    SteadyStateHypothesisExport.writeAsynchronousMachine(context.getNamingStrategy().getCgmesId((Identifiable<?>)load), load.getP0(), load.getQ0(), cimNamespace, writer, context);
                    continue block13;
                }
                case "EnergySource": {
                    SteadyStateHypothesisExport.writeEnergySource(context.getNamingStrategy().getCgmesId((Identifiable<?>)load), load.getP0(), load.getQ0(), cimNamespace, writer, context);
                    continue block13;
                }
                case "EnergyConsumer": 
                case "ConformLoad": 
                case "NonConformLoad": 
                case "StationSupply": {
                    SteadyStateHypothesisExport.writeSshEnergyConsumer(context.getNamingStrategy().getCgmesId((Identifiable<?>)load), className, load.getP0(), load.getQ0(), cimNamespace, writer, context);
                    continue block13;
                }
            }
            throw new PowsyblException("Unexpected class name: " + className);
        }
    }

    private static String obtainLoadClassName(Load load, CgmesExportContext context) {
        String originalClassName = load.getProperty("CGMES.originalClass");
        return originalClassName != null && !context.isExportEquipment() ? originalClassName : CgmesExportUtil.loadClassName(load);
    }

    private static void writeAsynchronousMachine(String id, double p, double q, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("AsynchronousMachine", id, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, ROTATING_MACHINE_P);
        writer.writeCharacters(CgmesExportUtil.format(p));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, ROTATING_MACHINE_Q);
        writer.writeCharacters(CgmesExportUtil.format(q));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void writeEnergySource(String id, double p, double q, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("EnergySource", id, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "EnergySource.activePower");
        writer.writeCharacters(CgmesExportUtil.format(p));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "EnergySource.reactivePower");
        writer.writeCharacters(CgmesExportUtil.format(q));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void writeSshEnergyConsumer(String id, String className, double p, double q, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout(className, id, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "EnergyConsumer.p");
        writer.writeCharacters(CgmesExportUtil.format(p));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "EnergyConsumer.q");
        writer.writeCharacters(CgmesExportUtil.format(q));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void writeConverters(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (HvdcConverterStation converterStation : network.getHvdcConverterStations()) {
            double ppcc;
            CgmesExportUtil.writeStartAbout(CgmesExportUtil.converterClassName(converterStation), context.getNamingStrategy().getCgmesId((Identifiable<?>)converterStation), cimNamespace, writer, context);
            if (CgmesExportUtil.isConverterStationRectifier(converterStation)) {
                ppcc = converterStation.getHvdcLine().getActivePowerSetpoint();
            } else {
                double otherConverterStationLossFactor = converterStation.getOtherConverterStation().map(HvdcConverterStation::getLossFactor).orElse(Float.valueOf(0.0f)).floatValue();
                double pDCInverter = converterStation.getHvdcLine().getActivePowerSetpoint() * (1.0 - otherConverterStationLossFactor / 100.0);
                double poleLoss = (double)(converterStation.getLossFactor() / 100.0f) * pDCInverter;
                ppcc = -(pDCInverter - poleLoss);
            }
            writer.writeStartElement(cimNamespace, "ACDCConverter.targetPpcc");
            writer.writeCharacters(CgmesExportUtil.format(ppcc));
            writer.writeEndElement();
            writer.writeStartElement(cimNamespace, "ACDCConverter.targetUdc");
            writer.writeCharacters(CgmesExportUtil.format(0.0));
            writer.writeEndElement();
            if (converterStation instanceof LccConverterStation) {
                LccConverterStation lccConverterStation = (LccConverterStation)converterStation;
                SteadyStateHypothesisExport.writePandQ(cimNamespace, ppcc, SteadyStateHypothesisExport.getQfromPowerFactor(ppcc, lccConverterStation.getPowerFactor()), writer);
                writer.writeStartElement(cimNamespace, "CsConverter.targetAlpha");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
                writer.writeStartElement(cimNamespace, "CsConverter.targetGamma");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
                writer.writeStartElement(cimNamespace, "CsConverter.targetIdc");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
                writer.writeEmptyElement(cimNamespace, "CsConverter.operatingMode");
                writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + SteadyStateHypothesisExport.converterOperatingMode(converterStation));
                writer.writeEmptyElement(cimNamespace, "CsConverter.pPccControl");
                writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + "CsPpccControlKind.activePower");
            } else if (converterStation instanceof VscConverterStation) {
                VscConverterStation vscConverterStation = (VscConverterStation)converterStation;
                SteadyStateHypothesisExport.writePandQ(cimNamespace, ppcc, vscConverterStation.getReactivePowerSetpoint(), writer);
                writer.writeStartElement(cimNamespace, "VsConverter.droop");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
                writer.writeStartElement(cimNamespace, "VsConverter.droopCompensation");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
                writer.writeStartElement(cimNamespace, "VsConverter.qShare");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
                writer.writeStartElement(cimNamespace, "VsConverter.targetQpcc");
                writer.writeCharacters(CgmesExportUtil.format(vscConverterStation.getReactivePowerSetpoint()));
                writer.writeEndElement();
                writer.writeStartElement(cimNamespace, "VsConverter.targetUpcc");
                writer.writeCharacters(CgmesExportUtil.format(vscConverterStation.getVoltageSetpoint()));
                writer.writeEndElement();
                writer.writeEmptyElement(cimNamespace, "VsConverter.pPccControl");
                writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + SteadyStateHypothesisExport.converterOperatingMode(converterStation));
                writer.writeEmptyElement(cimNamespace, "VsConverter.qPccControl");
                writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + "VsQpccControlKind." + (vscConverterStation.isVoltageRegulatorOn() ? "voltagePcc" : "reactivePcc"));
            }
            writer.writeEndElement();
        }
    }

    private static void writePandQ(String cimNamespace, double p, double q, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(cimNamespace, "ACDCConverter.p");
        writer.writeCharacters(CgmesExportUtil.format(p));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "ACDCConverter.q");
        writer.writeCharacters(CgmesExportUtil.format(q));
        writer.writeEndElement();
    }

    public static String converterOperatingMode(HvdcConverterStation<?> converterStation) {
        if (CgmesExportUtil.isConverterStationRectifier(converterStation)) {
            return SteadyStateHypothesisExport.converterStationRectifier(converterStation);
        }
        return SteadyStateHypothesisExport.converterStationInverter(converterStation);
    }

    public static String converterStationRectifier(HvdcConverterStation<?> converterStation) {
        if (converterStation instanceof LccConverterStation) {
            return "CsOperatingModeKind.rectifier";
        }
        if (converterStation instanceof VscConverterStation) {
            return "VsPpccControlKind.pPcc";
        }
        throw new PowsyblException("Invalid converter type");
    }

    public static String converterStationInverter(HvdcConverterStation<?> converterStation) {
        if (converterStation instanceof LccConverterStation) {
            return "CsOperatingModeKind.inverter";
        }
        if (converterStation instanceof VscConverterStation) {
            return "VsPpccControlKind.udc";
        }
        throw new PowsyblException("Invalid converter type");
    }

    private static double getQfromPowerFactor(double p, double powerFactor) {
        if (powerFactor == 0.0) {
            return 0.0;
        }
        return p * Math.sqrt((1.0 - powerFactor * powerFactor) / (powerFactor * powerFactor));
    }

    private static void writeGeneratingUnitsParticitationFactors(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        GeneratingUnit gu;
        HashMap<String, GeneratingUnit> generatingUnits = new HashMap<String, GeneratingUnit>();
        for (Generator g : network.getGenerators()) {
            gu = SteadyStateHypothesisExport.generatingUnitForGeneratorAndBatteries(g, context);
            if (gu == null) continue;
            generatingUnits.put(gu.id, gu);
        }
        for (Battery b : network.getBatteries()) {
            gu = SteadyStateHypothesisExport.generatingUnitForGeneratorAndBatteries(b, context);
            if (gu == null) continue;
            generatingUnits.put(gu.id, gu);
        }
        for (GeneratingUnit gu2 : generatingUnits.values()) {
            SteadyStateHypothesisExport.writeGeneratingUnitParticipationFactor(gu2, cimNamespace, writer, context);
        }
    }

    private static GeneratingUnit generatingUnitForGeneratorAndBatteries(Injection<?> i, CgmesExportContext context) {
        if (i.hasProperty(GENERATING_UNIT_PROPERTY) && (i.getExtension(ActivePowerControl.class) != null || i.hasProperty("CGMES.normalPF"))) {
            GeneratingUnit gu = new GeneratingUnit();
            gu.id = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)i, GENERATING_UNIT_PROPERTY);
            gu.participationFactor = i.getExtension(ActivePowerControl.class) != null ? ((ActivePowerControl)i.getExtension(ActivePowerControl.class)).getParticipationFactor() : Double.parseDouble(i.getProperty("CGMES.normalPF"));
            gu.className = SteadyStateHypothesisExport.generatingUnitClassname(i);
            return gu;
        }
        return null;
    }

    private static void writeGeneratingUnitParticipationFactor(GeneratingUnit gu, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout(gu.className, gu.id, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "GeneratingUnit.normalPF");
        writer.writeCharacters(CgmesExportUtil.format(gu.participationFactor));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static String generatingUnitClassname(Injection<?> i) {
        if (i instanceof Generator) {
            Generator generator = (Generator)i;
            EnergySource energySource = generator.getEnergySource();
            if (energySource == EnergySource.HYDRO) {
                return "HydroGeneratingUnit";
            }
            if (energySource == EnergySource.NUCLEAR) {
                return "NuclearGeneratingUnit";
            }
            if (energySource == EnergySource.SOLAR) {
                return "SolarGeneratingUnit";
            }
            if (energySource == EnergySource.THERMAL) {
                return "ThermalGeneratingUnit";
            }
            if (energySource == EnergySource.WIND) {
                return "WindGeneratingUnit";
            }
            return "GeneratingUnit";
        }
        if (i instanceof Battery) {
            return "HydroGeneratingUnit";
        }
        throw new PowsyblException("Unexpected class for " + i.getId() + " using generating units: " + i.getClass());
    }

    private static void writeControlAreas(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesControlAreas areas = (CgmesControlAreas)network.getExtension(CgmesControlAreas.class);
        for (CgmesControlArea area : areas.getCgmesControlAreas()) {
            SteadyStateHypothesisExport.writeControlArea(area, cimNamespace, writer, context);
        }
    }

    private static void writeControlArea(CgmesControlArea area, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String areaId = context.getNamingStrategy().getCgmesId(area.getId());
        CgmesExportUtil.writeStartAbout("ControlArea", areaId, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "ControlArea.netInterchange");
        writer.writeCharacters(CgmesExportUtil.format(area.getNetInterchange()));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, "ControlArea.pTolerance");
        writer.writeCharacters(CgmesExportUtil.format(area.getPTolerance()));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    static class RegulatingControlView {
        String id;
        RegulatingControlType type;
        boolean discrete;
        boolean controlEnabled;
        double targetDeadband;
        double targetValue;
        String targetValueUnitMultiplier;

        RegulatingControlView(String id, RegulatingControlType type, boolean discrete, boolean controlEnabled, double targetDeadband, double targetValue, String targetValueUnitMultiplier) {
            this.id = id;
            this.type = type;
            this.discrete = discrete;
            this.controlEnabled = controlEnabled;
            this.targetDeadband = targetDeadband;
            this.targetValue = targetValue;
            this.targetValueUnitMultiplier = targetValueUnitMultiplier;
        }
    }

    private static enum RegulatingControlType {
        REGULATING_CONTROL,
        TAP_CHANGER_CONTROL;

    }

    private static final class GeneratingUnit {
        String id;
        String className;
        double participationFactor;

        private GeneratingUnit() {
        }
    }
}

