/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export.elements;

import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.iidm.network.EnergySource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class GeneratingUnitEq {
    private static final String EQ_GENERATINGUNIT_MINP = "GeneratingUnit.minOperatingP";
    private static final String EQ_GENERATINGUNIT_MAXP = "GeneratingUnit.maxOperatingP";
    private static final String EQ_GENERATINGUNIT_INITIALP = "GeneratingUnit.initialP";

    public static void write(String id, String generatingUnitName, EnergySource energySource, double minP, double maxP, double initialP, String cimNamespace, boolean writeInitialP, String equipmentContainer, String hydroPowerPlantId, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName(GeneratingUnitEq.generatingUnitClassName(energySource), id, generatingUnitName, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, EQ_GENERATINGUNIT_MINP);
        writer.writeCharacters(CgmesExportUtil.format(minP));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, EQ_GENERATINGUNIT_MAXP);
        writer.writeCharacters(CgmesExportUtil.format(maxP));
        writer.writeEndElement();
        if (writeInitialP) {
            writer.writeStartElement(cimNamespace, EQ_GENERATINGUNIT_INITIALP);
            writer.writeCharacters(CgmesExportUtil.format(initialP));
            writer.writeEndElement();
        }
        if (equipmentContainer != null) {
            CgmesExportUtil.writeReference("Equipment.EquipmentContainer", equipmentContainer, cimNamespace, writer, context);
        }
        if (energySource == EnergySource.WIND) {
            writer.writeEmptyElement(cimNamespace, "WindGeneratingUnit.windGenUnitType");
            writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", String.format("%s%s", cimNamespace, "WindGenUnitKind.onshore"));
        }
        if (hydroPowerPlantId != null) {
            CgmesExportUtil.writeReference("HydroGeneratingUnit.HydroPowerPlant", hydroPowerPlantId, cimNamespace, writer, context);
        }
        writer.writeEndElement();
    }

    private static String generatingUnitClassName(EnergySource energySource) {
        if (EnergySource.HYDRO.equals((Object)energySource)) {
            return "HydroGeneratingUnit";
        }
        if (EnergySource.NUCLEAR.equals((Object)energySource)) {
            return "NuclearGeneratingUnit";
        }
        if (EnergySource.THERMAL.equals((Object)energySource)) {
            return "ThermalGeneratingUnit";
        }
        if (EnergySource.WIND.equals((Object)energySource)) {
            return "WindGeneratingUnit";
        }
        if (EnergySource.SOLAR.equals((Object)energySource)) {
            return "SolarGeneratingUnit";
        }
        if (EnergySource.OTHER.equals((Object)energySource)) {
            return "GeneratingUnit";
        }
        return "GeneratingUnit";
    }

    private GeneratingUnitEq() {
    }
}

