/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export.elements;

import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.LoadingLimits;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class LoadingLimitEq {
    public static void write(String id, LoadingLimits loadingLimits, String name, double value, String operationalLimitTypeId, String operationalLimitSetId, String cimNamespace, String valueAttributeName, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String cgmesClass = LoadingLimitEq.loadingLimitClassName(loadingLimits);
        CgmesExportUtil.writeStartIdName(cgmesClass, id, name, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, cgmesClass + "." + valueAttributeName);
        writer.writeCharacters(CgmesExportUtil.format(value));
        writer.writeEndElement();
        CgmesExportUtil.writeReference("OperationalLimit.OperationalLimitSet", operationalLimitSetId, cimNamespace, writer, context);
        CgmesExportUtil.writeReference("OperationalLimit.OperationalLimitType", operationalLimitTypeId, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    public static String loadingLimitClassName(LoadingLimits loadingLimits) {
        if (loadingLimits instanceof CurrentLimits) {
            return "CurrentLimit";
        }
        if (loadingLimits instanceof ActivePowerLimits) {
            return "ActivePowerLimit";
        }
        if (loadingLimits instanceof ApparentPowerLimits) {
            return "ApparentPowerLimit";
        }
        throw new PowsyblException("Unsupported loading limits " + loadingLimits.getClass().getSimpleName());
    }

    private LoadingLimitEq() {
    }
}

