/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export.elements;

import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class RegulatingControlEq {
    public static final String REGULATING_CONTROL_VOLTAGE = "RegulatingControlModeKind.voltage";

    public static String writeKindVoltage(Connectable<?> c, String terminalId, Set<String> regulatingControlsWritten, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String regulatingControlId = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)c, "CGMES.RegulatingControl");
        if (regulatingControlId != null && !regulatingControlsWritten.contains(regulatingControlId)) {
            String regulatingControlName = "RC_" + c.getNameOrId();
            RegulatingControlEq.writeKindVoltage(regulatingControlId, regulatingControlName, terminalId, cimNamespace, writer, context);
            regulatingControlsWritten.add(regulatingControlId);
        }
        return regulatingControlId;
    }

    private static void writeKindVoltage(String id, String regulatingControlName, String terminalId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("RegulatingControl", id, regulatingControlName, cimNamespace, writer, context);
        CgmesExportUtil.writeReference("RegulatingControl.Terminal", terminalId, cimNamespace, writer, context);
        writer.writeEmptyElement(cimNamespace, "RegulatingControl.mode");
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + REGULATING_CONTROL_VOLTAGE);
        writer.writeEndElement();
    }

    private RegulatingControlEq() {
    }
}

