/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.naming;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.NameBasedGenerator;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCgmesAliasNamingStrategy
implements NamingStrategy {
    private final BiMap<String, String> idByUuid = HashBiMap.create();
    private final Map<String, String> uuidSeed = new HashMap<String, String>();
    private final NameBasedGenerator nameBasedGenerator;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCgmesAliasNamingStrategy.class);

    protected AbstractCgmesAliasNamingStrategy(UUID uuidNamespace) {
        this.nameBasedGenerator = uuidNamespace == null ? Generators.nameBasedGenerator() : Generators.nameBasedGenerator((UUID)uuidNamespace);
    }

    @Override
    public String getIidmId(String type, String id) {
        return (String)this.idByUuid.getOrDefault((Object)id, (Object)id);
    }

    @Override
    public String getIidmName(String type, String name) {
        return name;
    }

    @Override
    public String getCgmesId(Identifiable<?> identifiable) {
        String identifier = identifiable.getId();
        if (this.idByUuid.containsValue((Object)identifier)) {
            return (String)this.idByUuid.inverse().get((Object)identifier);
        }
        if (CgmesExportUtil.isValidCimMasterRID(identifier)) {
            return identifier;
        }
        String uuid = this.getCgmesId(CgmesObjectReference.refTyped(identifiable));
        this.idByUuid.put((Object)uuid, (Object)identifier);
        return uuid;
    }

    @Override
    public String getCgmesIdFromAlias(Identifiable<?> identifiable, String aliasType) {
        String id;
        if (identifiable instanceof DanglingLine) {
            DanglingLine dl = (DanglingLine)identifiable;
            id = (String)identifiable.getAliasFromType(aliasType).or(() -> dl.getTieLine().flatMap(tl -> tl.getAliasFromType(aliasType))).orElseThrow(() -> new PowsyblException("Missing alias " + aliasType + " in " + identifiable.getId()));
        } else {
            id = (String)identifiable.getAliasFromType(aliasType).orElseThrow(() -> new PowsyblException("Missing alias " + aliasType + " in " + identifiable.getId()));
        }
        return this.getCgmesId(id);
    }

    @Override
    public String getCgmesIdFromProperty(Identifiable<?> identifiable, String propertyName) {
        String id = identifiable.getProperty(propertyName);
        if (id == null) {
            return null;
        }
        return this.getCgmesId(id);
    }

    @Override
    public String getCgmesId(String identifier) {
        String uuid;
        if (this.idByUuid.containsValue((Object)identifier)) {
            return (String)this.idByUuid.inverse().get((Object)identifier);
        }
        if (CgmesExportUtil.isValidCimMasterRID(identifier)) {
            uuid = identifier;
        } else {
            uuid = this.getCgmesId(CgmesObjectReference.ref(identifier));
            this.idByUuid.put((Object)uuid, (Object)identifier);
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debug(String baseName, DataSource ds) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String mappingFilename = baseName + "_debug_naming_strategy.csv";
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(ds.newOutputStream(mappingFilename, false)));){
            CsvWriterSettings settings = new CsvWriterSettings();
            ((CsvFormat)settings.getFormat()).setLineSeparator(System.lineSeparator());
            ((CsvFormat)settings.getFormat()).setDelimiter(';');
            ((CsvFormat)settings.getFormat()).setQuoteEscape('\"');
            try (CsvWriter csvWriter = new CsvWriter((Writer)writer, settings);){
                String uuid;
                String[] nextLine = new String[]{"CgmesUuid", "IidmId", "Seed"};
                csvWriter.writeRow(nextLine);
                for (Map.Entry entry : this.idByUuid.entrySet()) {
                    nextLine[0] = uuid = (String)entry.getKey();
                    nextLine[1] = (String)entry.getValue();
                    nextLine[2] = this.uuidSeed.get(uuid);
                    csvWriter.writeRow(nextLine);
                }
                for (Map.Entry entry : this.uuidSeed.entrySet()) {
                    uuid = (String)entry.getKey();
                    if (this.idByUuid.containsKey((Object)uuid)) continue;
                    nextLine[0] = uuid;
                    nextLine[1] = "unknown";
                    nextLine[2] = this.uuidSeed.get(uuid);
                    csvWriter.writeRow(nextLine);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getCgmesId(CgmesObjectReference ... refs) {
        String seed = "_" + CgmesObjectReference.combine(refs);
        String uuid = this.nameBasedGenerator.generate(seed).toString();
        if (this.uuidSeed.containsKey(uuid)) {
            LOG.debug("Unique ID for seed {} called multiple times ", (Object)seed);
        }
        this.uuidSeed.put(uuid, seed);
        return uuid;
    }
}

