/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.google.auto.service.AutoService;
import com.google.common.io.ByteStreams;
import com.powsybl.cgmes.conversion.CgmesImportPostProcessor;
import com.powsybl.cgmes.conversion.CgmesImportPreProcessor;
import com.powsybl.cgmes.conversion.Conversion;
import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.naming.NamingStrategyFactory;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelFactory;
import com.powsybl.cgmes.model.CgmesOnDataSource;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.GenericReadOnlyDataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.parameters.ConfiguredParameter;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterScope;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.triplestore.api.TripleStoreFactory;
import com.powsybl.triplestore.api.TripleStoreOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Importer.class})
public class CgmesImport
implements Importer {
    private static final String FORMAT = "CGMES";
    public static final String BOUNDARY_LOCATION = "iidm.import.cgmes.boundary-location";
    public static final String CONVERT_BOUNDARY = "iidm.import.cgmes.convert-boundary";
    public static final String CONVERT_SV_INJECTIONS = "iidm.import.cgmes.convert-sv-injections";
    public static final String CREATE_ACTIVE_POWER_CONTROL_EXTENSION = "iidm.import.cgmes.create-active-power-control-extension";
    public static final String CREATE_BUSBAR_SECTION_FOR_EVERY_CONNECTIVITY_NODE = "iidm.import.cgmes.create-busbar-section-for-every-connectivity-node";
    public static final String CREATE_FICTITIOUS_SWITCHES_FOR_DISCONNECTED_TERMINALS_MODE = "iidm.import.cgmes.create-fictitious-switches-for-disconnected-terminals-mode";
    public static final String DECODE_ESCAPED_IDENTIFIERS = "iidm.import.cgmes.decode-escaped-identifiers";
    public static final String ENSURE_ID_ALIAS_UNICITY = "iidm.import.cgmes.ensure-id-alias-unicity";
    public static final String IMPORT_CONTROL_AREAS = "iidm.import.cgmes.import-control-areas";
    public static final String NAMING_STRATEGY = "iidm.import.cgmes.naming-strategy";
    public static final String PRE_PROCESSORS = "iidm.import.cgmes.pre-processors";
    public static final String POST_PROCESSORS = "iidm.import.cgmes.post-processors";
    public static final String POWSYBL_TRIPLESTORE = "iidm.import.cgmes.powsybl-triplestore";
    public static final String PROFILE_FOR_INITIAL_VALUES_SHUNT_SECTIONS_TAP_POSITIONS = "iidm.import.cgmes.profile-for-initial-values-shunt-sections-tap-positions";
    public static final String SOURCE_FOR_IIDM_ID = "iidm.import.cgmes.source-for-iidm-id";
    public static final String STORE_CGMES_MODEL_AS_NETWORK_EXTENSION = "iidm.import.cgmes.store-cgmes-model-as-network-extension";
    public static final String STORE_CGMES_CONVERSION_CONTEXT_AS_NETWORK_EXTENSION = "iidm.import.cgmes.store-cgmes-conversion-context-as-network-extension";
    public static final String IMPORT_NODE_BREAKER_AS_BUS_BREAKER = "iidm.import.cgmes.import-node-breaker-as-bus-breaker";
    public static final String DISCONNECT_DANGLING_LINE_IF_BOUNDARY_SIDE_IS_DISCONNECTED = "iidm.import.cgmes.disconnect-dangling-line-if-boundary-side-is-disconnected";
    public static final String MISSING_PERMANENT_LIMIT_PERCENTAGE = "iidm.import.cgmes.missing-permanent-limit-percentage";
    public static final String IMPORT_CGM_WITH_SUBNETWORKS = "iidm.import.cgmes.cgm-with-subnetworks";
    public static final String IMPORT_CGM_WITH_SUBNETWORKS_DEFINED_BY = "iidm.import.cgmes.cgm-with-subnetworks-defined-by";
    public static final String CREATE_FICTITIOUS_VOLTAGE_LEVEL_FOR_EVERY_NODE = "iidm.import.cgmes.create-fictitious-voltage-level-for-every-node";
    public static final String SOURCE_FOR_IIDM_ID_MRID = "mRID";
    public static final String SOURCE_FOR_IIDM_ID_RDFID = "rdfID";
    private static final Parameter CONVERT_BOUNDARY_PARAMETER = new Parameter("iidm.import.cgmes.convert-boundary", ParameterType.BOOLEAN, "Convert boundary during import", (Object)Boolean.FALSE).addAdditionalNames(new String[]{"convertBoundary"});
    private static final Parameter CONVERT_SV_INJECTIONS_PARAMETER = new Parameter("iidm.import.cgmes.convert-sv-injections", ParameterType.BOOLEAN, "Convert SV injections during import", (Object)Boolean.TRUE);
    private static final Parameter CREATE_BUSBAR_SECTION_FOR_EVERY_CONNECTIVITY_NODE_PARAMETER = new Parameter("iidm.import.cgmes.create-busbar-section-for-every-connectivity-node", ParameterType.BOOLEAN, "Create busbar section for every connectivity node", (Object)Boolean.FALSE).addAdditionalNames(new String[]{"createBusbarSectionForEveryConnectivityNode"});
    private static final Parameter ENSURE_ID_ALIAS_UNICITY_PARAMETER = new Parameter("iidm.import.cgmes.ensure-id-alias-unicity", ParameterType.BOOLEAN, "Ensure IDs and aliases are unique", (Object)Boolean.FALSE);
    private static final Parameter NAMING_STRATEGY_PARAMETER = new Parameter("iidm.import.cgmes.naming-strategy", ParameterType.STRING, "Configure what type of naming strategy you want to use", (Object)"identity", new ArrayList<String>(NamingStrategyFactory.LIST));
    private static final Parameter IMPORT_CONTROL_AREAS_PARAMETER = new Parameter("iidm.import.cgmes.import-control-areas", ParameterType.BOOLEAN, "Import control areas", (Object)Boolean.TRUE);
    private static final Parameter POWSYBL_TRIPLESTORE_PARAMETER = new Parameter("iidm.import.cgmes.powsybl-triplestore", ParameterType.STRING, "The triplestore used during the import", (Object)TripleStoreFactory.defaultImplementation(), null, ParameterScope.TECHNICAL).addAdditionalNames(new String[]{"powsyblTripleStore"});
    private static final Parameter PROFILE_FOR_INITIAL_VALUES_SHUNT_SECTIONS_TAP_POSITIONS_PARAMETER = new Parameter("iidm.import.cgmes.profile-for-initial-values-shunt-sections-tap-positions", ParameterType.STRING, "Profile used for initial state values", (Object)"SSH", List.of("SSH", "SV")).addAdditionalNames(new String[]{"iidm.import.cgmes.profile-used-for-initial-state-values"});
    private static final Parameter STORE_CGMES_CONVERSION_CONTEXT_AS_NETWORK_EXTENSION_PARAMETER = new Parameter("iidm.import.cgmes.store-cgmes-conversion-context-as-network-extension", ParameterType.BOOLEAN, "Store the CGMES-IIDM terminal mapping as a network extension", (Object)Boolean.FALSE);
    private static final Parameter CREATE_ACTIVE_POWER_CONTROL_EXTENSION_PARAMETER = new Parameter("iidm.import.cgmes.create-active-power-control-extension", ParameterType.BOOLEAN, "Create active power control extension during import", (Object)Boolean.TRUE);
    private static final Parameter CREATE_FICTITIOUS_SWITCHES_FOR_DISCONNECTED_TERMINALS_MODE_PARAMETER = new Parameter("iidm.import.cgmes.create-fictitious-switches-for-disconnected-terminals-mode", ParameterType.STRING, "Defines in which case fictitious switches for disconnected terminals are created (relevant for node-breaker models only): always, always except for switches or never", (Object)FictitiousSwitchesCreationMode.ALWAYS.name(), Arrays.stream(FictitiousSwitchesCreationMode.values()).map(Enum::name).collect(Collectors.toList()));
    private static final Parameter STORE_CGMES_MODEL_AS_NETWORK_EXTENSION_PARAMETER = new Parameter("iidm.import.cgmes.store-cgmes-model-as-network-extension", ParameterType.BOOLEAN, "Store the initial CGMES model as a network extension", (Object)Boolean.TRUE).addAdditionalNames(new String[]{"storeCgmesModelAsNetworkExtension"});
    private static final Parameter SOURCE_FOR_IIDM_ID_PARAMETER = new Parameter("iidm.import.cgmes.source-for-iidm-id", ParameterType.STRING, "Source for IIDM identifiers", (Object)"mRID", List.of("mRID", "rdfID"));
    private static final Parameter DECODE_ESCAPED_IDENTIFIERS_PARAMETER = new Parameter("iidm.import.cgmes.decode-escaped-identifiers", ParameterType.BOOLEAN, "Decode escaped special characters in IDs", (Object)Boolean.TRUE);
    public static final Parameter IMPORT_NODE_BREAKER_AS_BUS_BREAKER_PARAMETER = new Parameter("iidm.import.cgmes.import-node-breaker-as-bus-breaker", ParameterType.BOOLEAN, "Force import of CGMES node/breaker models as bus/breaker", (Object)Boolean.FALSE);
    public static final Parameter DISCONNECT_DANGLING_LINE_IF_BOUNDARY_SIDE_IS_DISCONNECTED_PARAMETER = new Parameter("iidm.import.cgmes.disconnect-dangling-line-if-boundary-side-is-disconnected", ParameterType.BOOLEAN, "Force disconnection of dangling line network side if boundary side is disconnected", (Object)Boolean.TRUE);
    private static final Parameter IMPORT_CGM_WITH_SUBNETWORKS_PARAMETER = new Parameter("iidm.import.cgmes.cgm-with-subnetworks", ParameterType.BOOLEAN, "Import CGM with subnetworks", (Object)Boolean.TRUE);
    private static final Parameter IMPORT_CGM_WITH_SUBNETWORKS_DEFINED_BY_PARAMETER = new Parameter("iidm.import.cgmes.cgm-with-subnetworks-defined-by", ParameterType.STRING, "Choose how subnetworks from CGM must be imported: defined by filenames or by modeling authority", (Object)SubnetworkDefinedBy.MODELING_AUTHORITY.name(), Arrays.stream(SubnetworkDefinedBy.values()).map(Enum::name).collect(Collectors.toList()));
    public static final Parameter MISSING_PERMANENT_LIMIT_PERCENTAGE_PARAMETER = new Parameter("iidm.import.cgmes.missing-permanent-limit-percentage", ParameterType.DOUBLE, "Percentage applied to lowest TATL limit to use as PATL when PATL is missing", (Object)100.0);
    private static final Parameter CREATE_FICTITIOUS_VOLTAGE_LEVEL_FOR_EVERY_NODE_PARAMETER = new Parameter("iidm.import.cgmes.create-fictitious-voltage-level-for-every-node", ParameterType.BOOLEAN, "Create fictitious voltage level for every node", (Object)Boolean.TRUE).addAdditionalNames(new String[]{"createFictitiousVoltageLevelForEveryNode"});
    private static final List<Parameter> STATIC_PARAMETERS = List.of(CONVERT_BOUNDARY_PARAMETER, CONVERT_SV_INJECTIONS_PARAMETER, CREATE_BUSBAR_SECTION_FOR_EVERY_CONNECTIVITY_NODE_PARAMETER, ENSURE_ID_ALIAS_UNICITY_PARAMETER, NAMING_STRATEGY_PARAMETER, IMPORT_CONTROL_AREAS_PARAMETER, POWSYBL_TRIPLESTORE_PARAMETER, PROFILE_FOR_INITIAL_VALUES_SHUNT_SECTIONS_TAP_POSITIONS_PARAMETER, SOURCE_FOR_IIDM_ID_PARAMETER, STORE_CGMES_CONVERSION_CONTEXT_AS_NETWORK_EXTENSION_PARAMETER, STORE_CGMES_MODEL_AS_NETWORK_EXTENSION_PARAMETER, CREATE_ACTIVE_POWER_CONTROL_EXTENSION_PARAMETER, DECODE_ESCAPED_IDENTIFIERS_PARAMETER, CREATE_FICTITIOUS_SWITCHES_FOR_DISCONNECTED_TERMINALS_MODE_PARAMETER, IMPORT_NODE_BREAKER_AS_BUS_BREAKER_PARAMETER, DISCONNECT_DANGLING_LINE_IF_BOUNDARY_SIDE_IS_DISCONNECTED_PARAMETER, IMPORT_CGM_WITH_SUBNETWORKS_PARAMETER, IMPORT_CGM_WITH_SUBNETWORKS_DEFINED_BY_PARAMETER, MISSING_PERMANENT_LIMIT_PERCENTAGE_PARAMETER, CREATE_FICTITIOUS_VOLTAGE_LEVEL_FOR_EVERY_NODE_PARAMETER);
    private final Parameter boundaryLocationParameter;
    private final Parameter preProcessorsParameter;
    private final Parameter postProcessorsParameter;
    private final Map<String, CgmesImportPostProcessor> postProcessors;
    private final Map<String, CgmesImportPreProcessor> preProcessors;
    private final ParameterDefaultValueConfig defaultValueConfig;
    private final PlatformConfig platformConfig;
    private static final Logger LOGGER = LoggerFactory.getLogger(CgmesImport.class);
    private static final boolean IMPORT_CIM_14 = false;

    public CgmesImport(PlatformConfig platformConfig, List<CgmesImportPreProcessor> preProcessors, List<CgmesImportPostProcessor> postProcessors) {
        this.platformConfig = platformConfig;
        this.defaultValueConfig = new ParameterDefaultValueConfig(platformConfig);
        this.preProcessors = Objects.requireNonNull(preProcessors).stream().collect(Collectors.toMap(CgmesImportPreProcessor::getName, e -> e));
        this.postProcessors = Objects.requireNonNull(postProcessors).stream().collect(Collectors.toMap(CgmesImportPostProcessor::getName, e -> e));
        String boundaryPath = platformConfig.getConfigDir().map(dir -> dir.resolve(FORMAT).resolve("boundary")).map(Path::toString).orElse(null);
        this.boundaryLocationParameter = new Parameter(BOUNDARY_LOCATION, ParameterType.STRING, "The location of boundary files", (Object)boundaryPath, null, ParameterScope.TECHNICAL);
        this.preProcessorsParameter = new Parameter(PRE_PROCESSORS, ParameterType.STRING_LIST, "Pre processors", Collections.emptyList(), preProcessors.stream().map(CgmesImportPreProcessor::getName).collect(Collectors.toList()));
        this.postProcessorsParameter = new Parameter(POST_PROCESSORS, ParameterType.STRING_LIST, "Post processors", Collections.emptyList(), postProcessors.stream().map(CgmesImportPostProcessor::getName).collect(Collectors.toList()));
    }

    public CgmesImport(PlatformConfig platformConfig) {
        this(platformConfig, new ServiceLoaderCache(CgmesImportPreProcessor.class).getServices(), new ServiceLoaderCache(CgmesImportPostProcessor.class).getServices());
    }

    public CgmesImport(List<CgmesImportPreProcessor> preProcessors, List<CgmesImportPostProcessor> postProcessors) {
        this(PlatformConfig.defaultConfig(), preProcessors, postProcessors);
    }

    public CgmesImport() {
        this(PlatformConfig.defaultConfig());
    }

    public List<Parameter> getParameters() {
        ArrayList<Parameter> allParams = new ArrayList<Parameter>(STATIC_PARAMETERS);
        allParams.add(this.boundaryLocationParameter);
        allParams.add(this.postProcessorsParameter);
        return ConfiguredParameter.load(allParams, (String)this.getFormat(), (ParameterDefaultValueConfig)this.defaultValueConfig);
    }

    public boolean exists(ReadOnlyDataSource ds) {
        CgmesOnDataSource cds = new CgmesOnDataSource(ds);
        try {
            return cds.exists();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getComment() {
        return "ENTSO-E CGMES version 2.4.15";
    }

    public String getFormat() {
        return FORMAT;
    }

    public List<String> getSupportedExtensions() {
        return List.of("xml");
    }

    public Network importData(ReadOnlyDataSource ds, NetworkFactory networkFactory, Properties p, ReportNode reportNode) {
        SubnetworkDefinedBy separatingBy;
        Set<ReadOnlyDataSource> dss;
        Objects.requireNonNull(ds);
        Objects.requireNonNull(networkFactory);
        Objects.requireNonNull(reportNode);
        if (Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)IMPORT_CGM_WITH_SUBNETWORKS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig) && (dss = new MultipleGridModelChecker(ds).separate(separatingBy = SubnetworkDefinedBy.valueOf(Parameter.readString((String)this.getFormat(), (Properties)p, (Parameter)IMPORT_CGM_WITH_SUBNETWORKS_DEFINED_BY_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)))).size() > 1) {
            return Network.merge((Network[])((Network[])dss.stream().map(ds1 -> this.importData1((ReadOnlyDataSource)ds1, networkFactory, p, reportNode)).toArray(Network[]::new)));
        }
        return this.importData1(ds, networkFactory, p, reportNode);
    }

    private Network importData1(ReadOnlyDataSource ds, NetworkFactory networkFactory, Properties p, ReportNode reportNode) {
        CgmesModel cgmes = this.readCgmes(ds, p, reportNode);
        ReportNode conversionReportNode = ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("CGMESConversion", "Importing CGMES file(s)")).add();
        return new Conversion(cgmes, this.config(p), this.activatedPreProcessors(p), this.activatedPostProcessors(p), networkFactory).convert(conversionReportNode);
    }

    public CgmesModel readCgmes(ReadOnlyDataSource ds, Properties p, ReportNode reportNode) {
        TripleStoreOptions options = new TripleStoreOptions();
        String sourceForIidmIds = Parameter.readString((String)this.getFormat(), (Properties)p, (Parameter)SOURCE_FOR_IIDM_ID_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig);
        if (sourceForIidmIds.equalsIgnoreCase(SOURCE_FOR_IIDM_ID_MRID)) {
            options.setRemoveInitialUnderscoreForIdentifiers(true);
        } else if (sourceForIidmIds.equalsIgnoreCase(SOURCE_FOR_IIDM_ID_RDFID)) {
            options.setRemoveInitialUnderscoreForIdentifiers(false);
        }
        options.decodeEscapedIdentifiers(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)DECODE_ESCAPED_IDENTIFIERS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig));
        ReportNode tripleStoreReportNode = ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("CGMESTriplestore", "Reading CGMES Triplestore")).add();
        return CgmesModelFactory.create((ReadOnlyDataSource)ds, (ReadOnlyDataSource)this.boundary(p), (String)this.tripleStore(p), (ReportNode)tripleStoreReportNode, (TripleStoreOptions)options);
    }

    public void copy(ReadOnlyDataSource from, DataSource to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        try {
            CgmesOnDataSource fromCgmes = new CgmesOnDataSource(from);
            for (String name : fromCgmes.names()) {
                this.copyStream(from, to, name, name);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ReadOnlyDataSource boundary(Properties p) {
        String location = Parameter.readString((String)this.getFormat(), (Properties)p, (Parameter)this.boundaryLocationParameter, (ParameterDefaultValueConfig)this.defaultValueConfig);
        if (location == null) {
            return null;
        }
        Path path = this.boundaryPath(location);
        if (path == null) {
            return null;
        }
        GenericReadOnlyDataSource ds = new GenericReadOnlyDataSource(path);
        if (new CgmesOnDataSource((ReadOnlyDataSource)ds).names().isEmpty()) {
            return null;
        }
        return ds;
    }

    Path boundaryPath(String location) {
        FileSystem configFileSystem;
        Path path = null;
        Optional configDir = this.platformConfig.getConfigDir();
        if (configDir.isPresent() && (configFileSystem = ((Path)configDir.get()).getFileSystem()) != FileSystems.getDefault() && !Files.exists(path = configFileSystem.getPath(location, new String[0]), new LinkOption[0])) {
            LOGGER.warn("Location of boundaries ({}) not found in config file system. An attempt to load boundaries from the default file system will be made", (Object)location);
            path = null;
        }
        if (path == null && !Files.exists(path = Path.of(location, new String[0]), new LinkOption[0])) {
            LOGGER.warn("Location of boundaries ({}) not found in default file system. No attempt to load boundaries will be made", (Object)location);
        }
        return path;
    }

    private String tripleStore(Properties p) {
        return Parameter.readString((String)this.getFormat(), (Properties)p, (Parameter)POWSYBL_TRIPLESTORE_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig);
    }

    private Conversion.Config config(Properties p) {
        Conversion.Config config = new Conversion.Config().setConvertBoundary(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)CONVERT_BOUNDARY_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setConvertSvInjections(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)CONVERT_SV_INJECTIONS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setCreateBusbarSectionForEveryConnectivityNode(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)CREATE_BUSBAR_SECTION_FOR_EVERY_CONNECTIVITY_NODE_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setEnsureIdAliasUnicity(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)ENSURE_ID_ALIAS_UNICITY_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setImportControlAreas(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)IMPORT_CONTROL_AREAS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setProfileForInitialValuesShuntSectionsTapPositions(Parameter.readString((String)this.getFormat(), (Properties)p, (Parameter)PROFILE_FOR_INITIAL_VALUES_SHUNT_SECTIONS_TAP_POSITIONS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setStoreCgmesModelAsNetworkExtension(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)STORE_CGMES_MODEL_AS_NETWORK_EXTENSION_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setStoreCgmesConversionContextAsNetworkExtension(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)STORE_CGMES_CONVERSION_CONTEXT_AS_NETWORK_EXTENSION_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setCreateActivePowerControlExtension(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)CREATE_ACTIVE_POWER_CONTROL_EXTENSION_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).createFictitiousSwitchesForDisconnectedTerminalsMode(FictitiousSwitchesCreationMode.valueOf(Parameter.readString((String)this.getFormat(), (Properties)p, (Parameter)CREATE_FICTITIOUS_SWITCHES_FOR_DISCONNECTED_TERMINALS_MODE_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig))).setImportNodeBreakerAsBusBreaker(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)IMPORT_NODE_BREAKER_AS_BUS_BREAKER_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setDisconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)DISCONNECT_DANGLING_LINE_IF_BOUNDARY_SIDE_IS_DISCONNECTED_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setMissingPermanentLimitPercentage(Parameter.readDouble((String)this.getFormat(), (Properties)p, (Parameter)MISSING_PERMANENT_LIMIT_PERCENTAGE_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setCreateFictitiousVoltageLevelsForEveryNode(Parameter.readBoolean((String)this.getFormat(), (Properties)p, (Parameter)CREATE_FICTITIOUS_VOLTAGE_LEVEL_FOR_EVERY_NODE_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig));
        String namingStrategy = Parameter.readString((String)this.getFormat(), (Properties)p, (Parameter)NAMING_STRATEGY_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig);
        UUID uuidNamespace = CgmesExportContext.DEFAULT_UUID_NAMESPACE;
        config.setNamingStrategy(NamingStrategyFactory.create(namingStrategy, uuidNamespace));
        return config;
    }

    private List<CgmesImportPreProcessor> activatedPreProcessors(Properties p) {
        return Parameter.readStringList((String)this.getFormat(), (Properties)p, (Parameter)this.preProcessorsParameter, (ParameterDefaultValueConfig)this.defaultValueConfig).stream().filter(name -> {
            boolean found = this.preProcessors.containsKey(name);
            if (!found) {
                LOGGER.warn("CGMES pre processor {} not found", name);
            }
            return found;
        }).map(this.preProcessors::get).collect(Collectors.toList());
    }

    private List<CgmesImportPostProcessor> activatedPostProcessors(Properties p) {
        return Parameter.readStringList((String)this.getFormat(), (Properties)p, (Parameter)this.postProcessorsParameter, (ParameterDefaultValueConfig)this.defaultValueConfig).stream().filter(name -> {
            boolean found = this.postProcessors.containsKey(name);
            if (!found) {
                LOGGER.warn("CGMES post processor {} not found", name);
            }
            return found;
        }).map(this.postProcessors::get).collect(Collectors.toList());
    }

    private void copyStream(ReadOnlyDataSource from, DataSource to, String fromName, String toName) throws IOException {
        if (from.exists(fromName)) {
            try (InputStream is = from.newInputStream(fromName);
                 OutputStream os = to.newOutputStream(toName, false);){
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
        }
    }

    public static enum SubnetworkDefinedBy {
        FILENAME,
        MODELING_AUTHORITY;

    }

    static class MultipleGridModelChecker {
        private final ReadOnlyDataSource dataSource;
        private XMLInputFactory xmlInputFactory;

        MultipleGridModelChecker(ReadOnlyDataSource dataSource) {
            this.dataSource = dataSource;
        }

        Set<ReadOnlyDataSource> separate(SubnetworkDefinedBy separatingBy) {
            return switch (separatingBy) {
                default -> throw new IncompatibleClassChangeError();
                case SubnetworkDefinedBy.MODELING_AUTHORITY -> this.separateByModelingAuthority();
                case SubnetworkDefinedBy.FILENAME -> this.separateByIgmName();
            };
        }

        private Set<ReadOnlyDataSource> separateByModelingAuthority() {
            this.xmlInputFactory = XMLInputFactory.newInstance();
            Map<String, List> igmNames = new CgmesOnDataSource(this.dataSource).names().stream().filter(arg_0 -> ((CgmesSubset)CgmesSubset.EQUIPMENT).isValidName(arg_0)).map(name -> this.readModelingAuthority((String)name).map(ma -> Map.entry(ma, name))).flatMap(Optional::stream).collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList<String>(List.of((String)e.getValue()))));
            if (!igmNames.isEmpty()) {
                LOGGER.info("IGM EQ files identified by Modeling Authority:");
                igmNames.forEach((k, v) -> LOGGER.info("  {} {}", k, v.get(0)));
            }
            if (igmNames.size() == 1) {
                return Set.of(this.dataSource);
            }
            HashSet shared = new HashSet();
            new CgmesOnDataSource(this.dataSource).names().stream().filter(Predicate.not(arg_0 -> ((CgmesSubset)CgmesSubset.EQUIPMENT).isValidName(arg_0))).filter(Predicate.not(MultipleGridModelChecker::isBoundary)).forEach(name -> {
                Optional<String> ma = this.readModelingAuthority((String)name);
                if (ma.isPresent() && igmNames.containsKey(ma.get())) {
                    ((List)igmNames.get(ma.get())).add(name);
                } else {
                    shared.add(name);
                }
            });
            if (!igmNames.isEmpty()) {
                LOGGER.info("IGM files identified by Modeling Authority:");
                igmNames.forEach((k, v) -> LOGGER.info("  {} {}", k, (Object)String.join((CharSequence)",", v)));
                if (!shared.isEmpty()) {
                    LOGGER.info("Shared files:");
                    shared.forEach(name -> LOGGER.info("  {}", name));
                }
                LOGGER.info("Boundaries:");
                try {
                    this.dataSource.listNames(".*").stream().filter(MultipleGridModelChecker::isBoundary).forEach(name -> LOGGER.info("  {}", name));
                }
                catch (IOException e2) {
                    throw new PowsyblException((Throwable)e2);
                }
            }
            return igmNames.keySet().stream().map(ma -> new FilteredReadOnlyDataSource(this.dataSource, name -> MultipleGridModelChecker.isBoundary(name) || ((List)igmNames.get(ma)).contains(name) || shared.contains(name))).collect(Collectors.toSet());
        }

        private Optional<String> readModelingAuthority(String name) {
            String modellingAuthority = null;
            try (InputStream is = this.dataSource.newInputStream(name);){
                XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(is);
                boolean stopReading = false;
                while (reader.hasNext() && !stopReading) {
                    int token = reader.next();
                    if (token == 1 && reader.getLocalName().equals("Model.modelingAuthoritySet")) {
                        modellingAuthority = reader.getElementText();
                        stopReading = true;
                        continue;
                    }
                    if (token != 2 || !reader.getLocalName().equals("FullModel")) continue;
                    stopReading = true;
                }
                reader.close();
            }
            catch (IOException | XMLStreamException e) {
                throw new PowsyblException((Throwable)e);
            }
            return Optional.ofNullable(modellingAuthority);
        }

        private Set<ReadOnlyDataSource> separateByIgmName() {
            Set igmNames = new CgmesOnDataSource(this.dataSource).names().stream().filter(arg_0 -> ((CgmesSubset)CgmesSubset.EQUIPMENT).isValidName(arg_0)).map(name -> name.split("_")[2]).collect(Collectors.toSet());
            return igmNames.stream().map(igmName -> new FilteredReadOnlyDataSource(this.dataSource, name -> name.contains((CharSequence)igmName) || MultipleGridModelChecker.isBoundary(name) || MultipleGridModelChecker.isShared(name, igmNames))).collect(Collectors.toSet());
        }

        private static boolean isBoundary(String name) {
            return CgmesSubset.EQUIPMENT_BOUNDARY.isValidName(name) || CgmesSubset.TOPOLOGY_BOUNDARY.isValidName(name);
        }

        private static boolean isShared(String name, Set<String> allIgmNames) {
            return allIgmNames.stream().filter(name::contains).findAny().isEmpty();
        }
    }

    public static enum FictitiousSwitchesCreationMode {
        ALWAYS,
        ALWAYS_EXCEPT_SWITCHES,
        NEVER;

    }

    static class FilteredReadOnlyDataSource
    implements ReadOnlyDataSource {
        private final ReadOnlyDataSource ds;
        private final Predicate<String> filter;

        FilteredReadOnlyDataSource(ReadOnlyDataSource ds, Predicate<String> filter) {
            this.ds = ds;
            this.filter = filter;
        }

        public String getBaseName() {
            return this.ds.getBaseName();
        }

        public boolean exists(String suffix, String ext) throws IOException {
            return this.ds.exists(suffix, ext) && this.filter.test(DataSourceUtil.getFileName((String)this.getBaseName(), (String)suffix, (String)ext));
        }

        public boolean isDataExtension(String ext) {
            return this.ds.isDataExtension(ext);
        }

        public boolean exists(String fileName) throws IOException {
            return this.ds.exists(fileName) && this.filter.test(fileName);
        }

        public InputStream newInputStream(String suffix, String ext) throws IOException {
            if (this.filter.test(DataSourceUtil.getFileName((String)this.getBaseName(), (String)suffix, (String)ext))) {
                return this.ds.newInputStream(suffix, ext);
            }
            throw new IOException(DataSourceUtil.getFileName((String)this.getBaseName(), (String)suffix, (String)ext) + " not found");
        }

        public InputStream newInputStream(String fileName) throws IOException {
            if (this.filter.test(fileName)) {
                return this.ds.newInputStream(fileName);
            }
            throw new IOException(fileName + " not found");
        }

        public Set<String> listNames(String regex) throws IOException {
            return this.ds.listNames(regex).stream().filter(this.filter).collect(Collectors.toSet());
        }
    }
}

