/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;

public final class CgmesReports {
    private CgmesReports() {
    }

    public static ReportNode applyingPreprocessorsReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("applyingPreprocessors", "Applying preprocessors.")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void applyingProcessorReport(ReportNode reportNode, String processorName) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("applyingProcessor", "Applying processor: {processorName}.")).withUntypedValue("processorName", processorName)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode buildingMappingsReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("buildingMappings", "Building mappings.")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode convertingElementTypeReport(ReportNode reportNode, String elementType) {
        return ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("convertingElementType", "Converting ${elementType}.")).withUntypedValue("elementType", elementType)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode fixingDanglingLinesIssuesReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("fixingDanglingLinesIssues", "Fixing issues with dangling lines.")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode settingVoltagesAndAnglesReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("settingVoltagesAndAngles", "Setting voltages and angles.")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode applyingPostprocessorsReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("applyingPostprocessors", "Applying postprocessors.")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void importedCgmesNetworkReport(ReportNode reportNode, String networkId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("importedCgmesNetwork", "CGMES network ${networkId} is imported.")).withUntypedValue("networkId", networkId)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void badVoltageTargetValueRegulatingControlReport(ReportNode reportNode, String eqId, double targetValue) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("badVoltageTargetValueRegulatingControl", "Equipment ${equipmentId} has a regulating control with bad target value for voltage: ${targetValue}.")).withUntypedValue("equipmentId", eqId)).withTypedValue("targetValue", targetValue, "VOLTAGE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void badTargetDeadbandRegulatingControlReport(ReportNode reportNode, String eqId, double targetDeadband) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("badTargetDeadbandRegulatingControl", "Equipment ${equipmentId} has a regulating control with bad target deadband: ${targetDeadband}.")).withUntypedValue("equipmentId", eqId)).withTypedValue("targetDeadband", targetDeadband, "VOLTAGE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void invalidAngleVoltageBusReport(ReportNode reportNode, Bus bus, String nodeId, double v, double angle) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("invalidAngleVoltageBus", "Node ${nodeId} in substation ${substation}, voltageLevel ${voltageLevel}, bus ${bus} has invalid value for voltage and/or angle. Voltage magnitude is ${voltage}, angle is ${angle}.")).withUntypedValue("substation", bus.getVoltageLevel().getSubstation().map(Identifiable::getNameOrId).orElse("unknown"))).withUntypedValue("voltageLevel", bus.getVoltageLevel().getNameOrId())).withUntypedValue("bus", bus.getId())).withUntypedValue("nodeId", nodeId)).withTypedValue("voltage", v, "VOLTAGE")).withTypedValue("angle", angle, "ANGLE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void invalidAngleVoltageNodeReport(ReportNode reportNode, String nodeId, double v, double angle) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("invalidAngleVoltageNode", "Node ${nodeId} has invalid value for voltage and/or angle. Voltage magnitude is ${voltage}, angle is ${angle}.")).withUntypedValue("nodeId", nodeId)).withTypedValue("voltage", v, "VOLTAGE")).withTypedValue("angle", angle, "ANGLE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void removingUnattachedHvdcConverterStationReport(ReportNode reportNode, String converterId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("removingUnattachedHvdcConverterStation", "HVDC Converter Station ${converterId} will be removed since it has no attached HVDC line.")).withUntypedValue("converterId", converterId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void voltageLevelMappingReport(ReportNode reportNode, int voltageLevelMappingSize, String mapAsString) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("voltageLevelMapping", "Original ${voltageLevelMappingSize} VoltageLevel container(s) connected by switches have been merged in IIDM. Map of original VoltageLevel to IIDM: ${mapAsString}.")).withUntypedValue("voltageLevelMappingSize", voltageLevelMappingSize)).withUntypedValue("mapAsString", mapAsString)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void substationMappingReport(ReportNode reportNode, int substationMappingSize, String mapAsString) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("substationMapping", "Original ${substationMappingSize} Substation container(s) connected by transformers have been merged in IIDM. Map of original Substation to IIDM: ${mapAsString}.")).withUntypedValue("substationMappingSize", substationMappingSize)).withUntypedValue("mapAsString", mapAsString)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void nominalVoltageIsZeroReport(ReportNode reportNode, String voltageLevelId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("nominalVoltageIsZero", "Ignoring VoltageLevel: ${voltageLevelId} for its nominal voltage is equal to 0.")).withUntypedValue("voltageLevelId", voltageLevelId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void inconsistentProfilesTPRequiredReport(ReportNode reportNode, String networkId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("inconsistentProfilesTPRequired", "Network contains node/breaker ${networkId} information. References to Topological Nodes in SSH/SV files will not be valid if TP is not exported.")).withUntypedValue("networkId", networkId)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void danglingLineDisconnectedAtBoundaryHasBeenDisconnectedReport(ReportNode reportNode, String danglingLineId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("danglingLineDisconnectedAtBoundaryHasBeenDisconnected", "DanglingLine ${danglingLineId} was connected at network side and disconnected at boundary side. It has been disconnected also at network side.")).withUntypedValue("danglingLineId", danglingLineId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void multipleUnpairedDanglingLinesAtSameBoundaryReport(ReportNode reportNode, String danglingLineId, double p0, double q0, double p0Adjusted, double q0Adjusted) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("multipleUnpairedDanglingLinesAtSameBoundary", "Multiple unpaired DanglingLines were connected at the same boundary side. Adjusted original injection from (${p0}, ${q0}) to (${p0Adjusted}, ${q0Adjusted}) for dangling line ${danglingLineId}.")).withUntypedValue("danglingLineId", danglingLineId)).withUntypedValue("p0", p0)).withUntypedValue("q0", q0)).withUntypedValue("p0Adjusted", p0Adjusted)).withUntypedValue("q0Adjusted", q0Adjusted)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void missingMandatoryAttributeReport(ReportNode reportNode, String attributeName, String objectClass, String objectId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("missingMandatoryAttribute", "Could't retrieve mandatory attribute: ${attributeName} of ${objectClass}: ${objectId}.")).withUntypedValue("attributeName", attributeName)).withUntypedValue("objectClass", objectClass)).withUntypedValue("objectId", objectId)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }
}

