/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.CgmesBoundary;
import com.powsybl.cgmes.conversion.Conversion;
import com.powsybl.cgmes.conversion.LoadingLimitsMapping;
import com.powsybl.cgmes.conversion.NodeContainerMapping;
import com.powsybl.cgmes.conversion.NodeMapping;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.TerminalMapping;
import com.powsybl.cgmes.conversion.elements.hvdc.DcMapping;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private final CgmesModel cgmes;
    private final Network network;
    private final Conversion.Config config;
    private final boolean nodeBreaker;
    private final NamingStrategy namingStrategy;
    private final NodeContainerMapping nodeContainerMapping;
    private final CgmesBoundary cgmesBoundary;
    private final TerminalMapping terminalMapping;
    private final NodeMapping nodeMapping;
    private final DcMapping dcMapping;
    private final LoadingLimitsMapping loadingLimitsMapping;
    private final RegulatingControlMapping regulatingControlMapping;
    private final Map<String, PropertyBags> ratioTapChangerTables;
    private final Map<String, PropertyBags> phaseTapChangerTables;
    private final Map<String, PropertyBags> reactiveCapabilityCurveData;
    private final Map<String, PropertyBag> powerTransformerRatioTapChangers;
    private final Map<String, PropertyBag> powerTransformerPhaseTapChangers;
    private static final Logger LOG = LoggerFactory.getLogger(Context.class);

    public Context(CgmesModel cgmes, Conversion.Config config, Network network) {
        this(cgmes, config, network, ReportNode.NO_OP);
    }

    public Context(CgmesModel cgmes, Conversion.Config config, Network network, ReportNode reportNode) {
        this.cgmes = Objects.requireNonNull(cgmes);
        this.config = Objects.requireNonNull(config);
        this.network = Objects.requireNonNull(network);
        this.pushReportNode(Objects.requireNonNull(reportNode));
        this.nodeBreaker = cgmes.isNodeBreaker() && !config.importNodeBreakerAsBusBreaker();
        this.namingStrategy = config.getNamingStrategy();
        this.cgmesBoundary = new CgmesBoundary(cgmes);
        this.nodeContainerMapping = new NodeContainerMapping(this);
        this.terminalMapping = new TerminalMapping();
        this.dcMapping = new DcMapping(this);
        this.loadingLimitsMapping = new LoadingLimitsMapping(this);
        this.regulatingControlMapping = new RegulatingControlMapping(this);
        this.nodeMapping = new NodeMapping(this);
        this.ratioTapChangerTables = new HashMap<String, PropertyBags>();
        this.phaseTapChangerTables = new HashMap<String, PropertyBags>();
        this.reactiveCapabilityCurveData = new HashMap<String, PropertyBags>();
        this.powerTransformerRatioTapChangers = new HashMap<String, PropertyBag>();
        this.powerTransformerPhaseTapChangers = new HashMap<String, PropertyBag>();
    }

    public CgmesModel cgmes() {
        return this.cgmes;
    }

    public Network network() {
        return this.network;
    }

    public Conversion.Config config() {
        return this.config;
    }

    public boolean nodeBreaker() {
        return this.nodeBreaker;
    }

    public NamingStrategy namingStrategy() {
        return this.namingStrategy;
    }

    public TerminalMapping terminalMapping() {
        return this.terminalMapping;
    }

    public void convertedTerminal(String terminalId, Terminal t, int n, PowerFlow f) {
        this.terminalMapping().add(terminalId, t, n);
        if (f.defined() && this.setPQAllowed(t)) {
            t.setP(f.p());
            t.setQ(f.q());
        }
    }

    private boolean setPQAllowed(Terminal t) {
        return t.getConnectable().getType() != IdentifiableType.BUSBAR_SECTION;
    }

    public NodeMapping nodeMapping() {
        return this.nodeMapping;
    }

    public NodeContainerMapping nodeContainerMapping() {
        return this.nodeContainerMapping;
    }

    public CgmesBoundary boundary() {
        return this.cgmesBoundary;
    }

    public DcMapping dc() {
        return this.dcMapping;
    }

    public LoadingLimitsMapping loadingLimitsMapping() {
        return this.loadingLimitsMapping;
    }

    public RegulatingControlMapping regulatingControlMapping() {
        return this.regulatingControlMapping;
    }

    public static String boundaryVoltageLevelId(String nodeId) {
        Objects.requireNonNull(nodeId);
        return nodeId + "_VL";
    }

    public static String boundarySubstationId(String nodeId) {
        Objects.requireNonNull(nodeId);
        return nodeId + "_S";
    }

    public void loadReactiveCapabilityCurveData() {
        PropertyBags rccdata = this.cgmes.reactiveCapabilityCurveData();
        if (rccdata == null) {
            return;
        }
        rccdata.forEach(p -> {
            String curveId = p.getId("ReactiveCapabilityCurve");
            this.reactiveCapabilityCurveData.computeIfAbsent(curveId, cid -> new PropertyBags()).add(p);
        });
    }

    public PropertyBags reactiveCapabilityCurveData(String curveId) {
        return this.reactiveCapabilityCurveData.get(curveId);
    }

    public void loadRatioTapChangers() {
        this.cgmes.ratioTapChangers().forEach(ratio -> {
            String id = ratio.getId("RatioTapChanger");
            this.powerTransformerRatioTapChangers.put(id, (PropertyBag)ratio);
        });
    }

    public PropertyBag ratioTapChanger(String id) {
        return this.powerTransformerRatioTapChangers.get(id);
    }

    public void loadPhaseTapChangers() {
        this.cgmes.phaseTapChangers().forEach(phase -> {
            String id = phase.getId("PhaseTapChanger");
            this.powerTransformerPhaseTapChangers.put(id, (PropertyBag)phase);
        });
    }

    public PropertyBag phaseTapChanger(String id) {
        return this.powerTransformerPhaseTapChangers.get(id);
    }

    public void loadRatioTapChangerTables() {
        PropertyBags rtcpoints = this.cgmes.ratioTapChangerTablesPoints();
        if (rtcpoints == null) {
            return;
        }
        rtcpoints.forEach(p -> {
            String tableId = p.getId("RatioTapChangerTable");
            this.ratioTapChangerTables.computeIfAbsent(tableId, tid -> new PropertyBags()).add(p);
        });
    }

    public void loadPhaseTapChangerTables() {
        PropertyBags ptcpoints = this.cgmes.phaseTapChangerTablesPoints();
        if (ptcpoints == null) {
            return;
        }
        ptcpoints.forEach(p -> {
            String tableId = p.getId("PhaseTapChangerTable");
            this.phaseTapChangerTables.computeIfAbsent(tableId, tid -> new PropertyBags()).add(p);
        });
    }

    public PropertyBags ratioTapChangerTable(String tableId) {
        return this.ratioTapChangerTables.get(tableId);
    }

    public PropertyBags phaseTapChangerTable(String tableId) {
        return this.phaseTapChangerTables.get(tableId);
    }

    public ReportNode getReportNode() {
        return this.network.getReportNodeContext().getReportNode();
    }

    public void pushReportNode(ReportNode node) {
        this.network.getReportNodeContext().pushReportNode(node);
    }

    public ReportNode popReportNode() {
        return this.network.getReportNodeContext().popReportNode();
    }

    public void invalid(String what, String reason) {
        this.handleIssue(ConversionIssueCategory.INVALID, what, reason);
    }

    public void invalid(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.INVALID, what, reason);
    }

    public void ignored(String what, String reason) {
        this.handleIssue(ConversionIssueCategory.IGNORED, what, reason);
    }

    public void ignored(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.IGNORED, what, reason);
    }

    public void pending(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.PENDING, what, reason);
    }

    public void fixed(String what, String reason) {
        this.handleIssue(ConversionIssueCategory.FIXED, what, reason);
    }

    public void fixed(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.FIXED, what, reason);
    }

    public void fixed(String what, String reason, double wrong, double fixed) {
        Supplier<String> reason1 = () -> String.format("%s. Wrong %.4f, was fixed to %.4f", reason, wrong, fixed);
        this.handleIssue(ConversionIssueCategory.FIXED, what, reason1);
    }

    public void missing(String what) {
        String reason1 = "";
        this.handleIssue(ConversionIssueCategory.MISSING, what, reason1);
    }

    public void missing(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.MISSING, what, reason);
    }

    public void missing(String what, double defaultValue) {
        Supplier<String> reason1 = () -> String.format("Using default value %.4f", defaultValue);
        this.handleIssue(ConversionIssueCategory.MISSING, what, reason1);
    }

    private void handleIssue(ConversionIssueCategory category, String what, String reason) {
        this.handleIssue(category, what, () -> reason);
    }

    private void handleIssue(ConversionIssueCategory category, String what, Supplier<String> reason) {
        Context.logIssue(category, what, reason);
    }

    private static void logIssue(ConversionIssueCategory category, String what, Supplier<String> reason) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("{}: {}. Reason: {}", new Object[]{category, what, reason.get()});
        }
    }

    private static enum ConversionIssueCategory {
        INVALID("Invalid"),
        IGNORED("Ignored"),
        MISSING("Missing"),
        FIXED("Fixed"),
        PENDING("Pending");

        private final String description;

        private ConversionIssueCategory(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

