/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class LoadingLimitsMapping {
    private final Context context;
    private final Map<OperationalLimitsGroup, CurrentLimitsAdder> currentLimitsAdders;
    private final Map<OperationalLimitsGroup, ActivePowerLimitsAdder> activePowerLimitsAdders;
    private final Map<OperationalLimitsGroup, ApparentPowerLimitsAdder> apparentPowerLimitsAdders;

    LoadingLimitsMapping(Context context) {
        this.context = Objects.requireNonNull(context);
        this.currentLimitsAdders = new HashMap<OperationalLimitsGroup, CurrentLimitsAdder>();
        this.activePowerLimitsAdders = new HashMap<OperationalLimitsGroup, ActivePowerLimitsAdder>();
        this.apparentPowerLimitsAdders = new HashMap<OperationalLimitsGroup, ApparentPowerLimitsAdder>();
    }

    public LoadingLimitsAdder getLoadingLimitsAdder(OperationalLimitsGroup limitsGroup, String limitSubClass) {
        return switch (limitSubClass) {
            case "CurrentLimit" -> this.currentLimitsAdders.computeIfAbsent(limitsGroup, s -> limitsGroup.newCurrentLimits());
            case "ActivePowerLimit" -> this.activePowerLimitsAdders.computeIfAbsent(limitsGroup, s -> limitsGroup.newActivePowerLimits());
            case "ApparentPowerLimit" -> this.apparentPowerLimitsAdders.computeIfAbsent(limitsGroup, s -> limitsGroup.newApparentPowerLimits());
            default -> throw new IllegalArgumentException();
        };
    }

    void addAll() {
        Stream.of(this.currentLimitsAdders, this.activePowerLimitsAdders, this.apparentPowerLimitsAdders).flatMap(m -> m.values().stream()).filter(adder -> !Double.isNaN(adder.getPermanentLimit()) || adder.hasTemporaryLimits()).forEach(adder -> adder.fixLimits(this.context.config().getMissingPermanentLimitPercentage(), this.context::fixed).add());
        Stream.of(this.currentLimitsAdders, this.activePowerLimitsAdders, this.apparentPowerLimitsAdders).forEach(Map::clear);
    }
}

