/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.model.CgmesContainer;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeContainerMapping {
    private final Context context;
    private final Map<String, String> substationMapping;
    private final Map<String, String> voltageLevelMapping;
    private final Map<String, ContainerR> fictitiousVoltageLevels;
    private final Map<String, String> referenceVoltageLevels;
    private static final Logger LOG = LoggerFactory.getLogger(NodeContainerMapping.class);

    public NodeContainerMapping(Context context) {
        this.context = context;
        this.substationMapping = new HashMap<String, String>();
        this.voltageLevelMapping = new HashMap<String, String>();
        this.fictitiousVoltageLevels = new HashMap<String, ContainerR>();
        this.referenceVoltageLevels = new HashMap<String, String>();
    }

    public boolean substationIsMapped(String cgmesIdentifier) {
        String sid = this.context.namingStrategy().getIidmId("Substation", cgmesIdentifier);
        return this.substationMapping.containsKey(sid);
    }

    public String substationIidm(String cgmesIdentifier) {
        String sid = this.context.namingStrategy().getIidmId("Substation", cgmesIdentifier);
        if (this.substationMapping.containsKey(sid)) {
            return this.substationMapping.get(sid);
        }
        return sid;
    }

    public Set<String> mergedSubstations(String cgmesIdentifier) {
        String sid = this.context.namingStrategy().getIidmId("Substation", cgmesIdentifier);
        return this.substationMapping.entrySet().stream().filter(r -> ((String)r.getValue()).equals(sid)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean voltageLevelIsMapped(String cgmesIdentifier) {
        String vlid = this.context.namingStrategy().getIidmId("VoltageLevel", cgmesIdentifier);
        return this.voltageLevelMapping.containsKey(vlid);
    }

    public String voltageLevelIidm(String cgmesIdentifier) {
        String vlid = this.context.namingStrategy().getIidmId("VoltageLevel", cgmesIdentifier);
        if (this.voltageLevelMapping.containsKey(vlid)) {
            return this.voltageLevelMapping.get(vlid);
        }
        return vlid;
    }

    public Set<String> mergedVoltageLevels(String cgmesIdentifier) {
        String vlid = this.context.namingStrategy().getIidmId("VoltageLevel", cgmesIdentifier);
        return this.voltageLevelMapping.entrySet().stream().filter(r -> ((String)r.getValue()).equals(vlid)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void build() {
        HashMap<String, Set<String>> voltageLevelAdjacency = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> substationAdjacency = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> fictitiousVoltageLevelAdjacency = new HashMap<String, Set<String>>();
        this.buildAdjacency(voltageLevelAdjacency, substationAdjacency, fictitiousVoltageLevelAdjacency);
        this.buildVoltageLevelMapping(voltageLevelAdjacency);
        this.buildSubstationMapping(substationAdjacency);
        this.buildReferenceVoltageLevels(fictitiousVoltageLevelAdjacency);
        this.fictitiousVoltageLevels.keySet().stream().filter(this::isSubstationContainer).map(this::voltageLevelIidm).filter(voltageLevelRepresentative -> this.fictitiousVoltageLevels.containsKey(voltageLevelRepresentative) && this.isSubstationContainer((String)voltageLevelRepresentative)).findFirst().ifPresent(fictitiousVoltageLevelForSubstationContainer -> {
            String containerId = this.getContainerId((String)fictitiousVoltageLevelForSubstationContainer).orElseThrow();
            throw new ConversionException("Substation container directly associated with connectivity or topological nodes. It is not expected to create a fictitious voltage level: " + containerId);
        });
    }

    private void buildAdjacency(Map<String, Set<String>> voltageLevelAdjacency, Map<String, Set<String>> substationAdjacency, Map<String, Set<String>> fictitiousVoltageLevelAdjacency) {
        boolean fictitiousVoltageLevelForEveryNode = this.context.config().getCreateFictitiousVoltageLevelsForEveryNode();
        this.context.cgmes().switches().forEach(sw -> this.addAdjacencyThroughSwitch(voltageLevelAdjacency, substationAdjacency, (PropertyBag)sw, fictitiousVoltageLevelForEveryNode));
        this.context.cgmes().groupedTransformerEnds().forEach((t, tends) -> this.addAdjacencyThroughTransformerEnds(substationAdjacency, (PropertyBags)tends));
        this.context.cgmes().acLineSegments().forEach(ac -> this.addAdjacencyThroughBranch(fictitiousVoltageLevelAdjacency, (PropertyBag)ac, fictitiousVoltageLevelForEveryNode));
        this.context.cgmes().seriesCompensators().forEach(sc -> this.addAdjacencyThroughBranch(fictitiousVoltageLevelAdjacency, (PropertyBag)sc, fictitiousVoltageLevelForEveryNode));
    }

    private void addAdjacencyThroughSwitch(Map<String, Set<String>> voltageLevelAdjacency, Map<String, Set<String>> substationAdjacency, PropertyBag sw, boolean fictitiousVoltageLevelForEveryNode) {
        CgmesTerminal t1 = this.context.cgmes().terminal(sw.getId("Terminal1"));
        CgmesTerminal t2 = this.context.cgmes().terminal(sw.getId("Terminal2"));
        Optional nodeId1 = this.context.cgmes().node(t1, this.context.nodeBreaker());
        Optional nodeId2 = this.context.cgmes().node(t2, this.context.nodeBreaker());
        if (nodeId1.isPresent() && !this.context.boundary().containsNode((String)nodeId1.get()) && nodeId2.isPresent() && !this.context.boundary().containsNode((String)nodeId2.get())) {
            Optional cgmesContainer1 = this.context.cgmes().nodeContainer((String)nodeId1.get());
            Optional cgmesContainer2 = this.context.cgmes().nodeContainer((String)nodeId2.get());
            if (cgmesContainer1.isPresent() && cgmesContainer2.isPresent()) {
                String voltageLevelId1 = this.findVoltageLevelAndRecordItIfItIsFictitious((CgmesContainer)cgmesContainer1.get(), (String)nodeId1.get(), fictitiousVoltageLevelForEveryNode);
                String voltageLevelId2 = this.findVoltageLevelAndRecordItIfItIsFictitious((CgmesContainer)cgmesContainer2.get(), (String)nodeId2.get(), fictitiousVoltageLevelForEveryNode);
                NodeContainerMapping.addAdjacency(voltageLevelAdjacency, voltageLevelId1, voltageLevelId2);
                NodeContainerMapping.addAdjacency(substationAdjacency, ((CgmesContainer)cgmesContainer1.get()).substation(), ((CgmesContainer)cgmesContainer2.get()).substation());
            }
        }
    }

    private String findVoltageLevelAndRecordItIfItIsFictitious(CgmesContainer cgmesContainer, String nodeId, boolean fictitiousVoltageLevelForEveryNode) {
        if (cgmesContainer.isVoltageLevel()) {
            return cgmesContainer.voltageLevel();
        }
        String fictitiousVoltageLevelId = NodeContainerMapping.getFictitiousVoltageLevelForContainer(cgmesContainer.id(), nodeId, fictitiousVoltageLevelForEveryNode);
        NodeContainerMapping.recordFictitiousVoltageLevel(this.fictitiousVoltageLevels, fictitiousVoltageLevelId, cgmesContainer.id(), nodeId);
        return fictitiousVoltageLevelId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void recordFictitiousVoltageLevel(Map<String, ContainerR> fictitiousVoltageLevels, String fictitiousVoltageLevelId, String cgmesContainerId, String nodeId) {
        if (fictitiousVoltageLevels.containsKey(fictitiousVoltageLevelId)) {
            if (!fictitiousVoltageLevels.get(fictitiousVoltageLevelId).containerId().equals(cgmesContainerId)) throw new ConversionException("Unexpected cgmesContainerId: " + cgmesContainerId);
            fictitiousVoltageLevels.get(fictitiousVoltageLevelId).nodeIdSet().add(nodeId);
            return;
        } else {
            HashSet<String> nodeIdSet = new HashSet<String>();
            nodeIdSet.add(nodeId);
            fictitiousVoltageLevels.put(fictitiousVoltageLevelId, new ContainerR(cgmesContainerId, nodeIdSet));
        }
    }

    private void addAdjacencyThroughTransformerEnds(Map<String, Set<String>> substationAdjacency, PropertyBags tends) {
        List<String> substationsIds = this.substationsIds(tends);
        if (substationsIds.size() <= 1) {
            return;
        }
        String sub0 = substationsIds.get(0);
        for (int i = 1; i < substationsIds.size(); ++i) {
            NodeContainerMapping.addAdjacency(substationAdjacency, sub0, substationsIds.get(i));
        }
    }

    private void addAdjacencyThroughBranch(Map<String, Set<String>> fictitiousVoltageLevelAdjacency, PropertyBag equipment, boolean fictitiousVoltageLevelByNode) {
        CgmesTerminal t1 = this.context.cgmes().terminal(equipment.getId("Terminal1"));
        CgmesTerminal t2 = this.context.cgmes().terminal(equipment.getId("Terminal2"));
        Optional nodeId1 = this.context.cgmes().node(t1, this.context.nodeBreaker());
        Optional nodeId2 = this.context.cgmes().node(t2, this.context.nodeBreaker());
        if (nodeId1.isPresent() && !this.context.boundary().containsNode((String)nodeId1.get()) && nodeId2.isPresent() && !this.context.boundary().containsNode((String)nodeId2.get())) {
            Optional cgmesContainer1 = this.context.cgmes().nodeContainer((String)nodeId1.get());
            Optional cgmesContainer2 = this.context.cgmes().nodeContainer((String)nodeId2.get());
            if (cgmesContainer1.isPresent() && cgmesContainer2.isPresent() && NodeContainerMapping.isValidReference((CgmesContainer)cgmesContainer1.get(), (CgmesContainer)cgmesContainer2.get())) {
                String voltageLevelId1 = this.findVoltageLevelAndRecordItIfItIsFictitious((CgmesContainer)cgmesContainer1.get(), (String)nodeId1.get(), fictitiousVoltageLevelByNode);
                String voltageLevelId2 = this.findVoltageLevelAndRecordItIfItIsFictitious((CgmesContainer)cgmesContainer2.get(), (String)nodeId2.get(), fictitiousVoltageLevelByNode);
                NodeContainerMapping.addAdjacency(fictitiousVoltageLevelAdjacency, voltageLevelId1, voltageLevelId2);
            }
        }
    }

    private static boolean isValidReference(CgmesContainer cgmesContainer1, CgmesContainer cgmesContainer2) {
        return !cgmesContainer1.isVoltageLevel() || !cgmesContainer2.isVoltageLevel();
    }

    private static void addAdjacency(Map<String, Set<String>> adjacency, String id1, String id2) {
        if (NodeContainerMapping.isValidAdjacency(id1, id2)) {
            adjacency.computeIfAbsent(id1, k -> new HashSet()).add(id2);
            adjacency.computeIfAbsent(id2, k -> new HashSet()).add(id1);
        }
    }

    private static boolean isValidAdjacency(String ad1, String ad2) {
        return ad1 != null && ad2 != null && !ad1.equals(ad2);
    }

    private void buildVoltageLevelMapping(Map<String, Set<String>> voltageLevelAdjacency) {
        HashSet<String> visitedVoltageLevels = new HashSet<String>();
        for (String vl : voltageLevelAdjacency.keySet()) {
            if (visitedVoltageLevels.contains(vl)) continue;
            Set<String> vlAds = NodeContainerMapping.allConnected(voltageLevelAdjacency, visitedVoltageLevels, vl);
            String selectedVoltageLevelId = this.representativeVoltageLevelId(vlAds);
            NodeContainerMapping.recordMergedIds(this.voltageLevelMapping, vlAds, selectedVoltageLevelId);
        }
        if (!this.voltageLevelMapping.isEmpty()) {
            CgmesReports.voltageLevelMappingReport(this.context.getReportNode(), this.voltageLevelMapping.size(), this.voltageLevelMapping.toString());
            LOG.warn("Original {} VoltageLevel container(s) connected by switches have been merged in IIDM. Map of original VoltageLevel to IIDM: {}", (Object)this.voltageLevelMapping.size(), this.voltageLevelMapping);
        }
    }

    private void buildSubstationMapping(Map<String, Set<String>> substationAdjacency) {
        HashSet<String> visitedSubstations = new HashSet<String>();
        for (String sub : substationAdjacency.keySet()) {
            if (visitedSubstations.contains(sub)) continue;
            Set<String> subAds = NodeContainerMapping.allConnected(substationAdjacency, visitedSubstations, sub);
            String selectedSubstationId = this.representativeSubstationId(subAds);
            NodeContainerMapping.recordMergedIds(this.substationMapping, subAds, selectedSubstationId);
        }
        if (!this.substationMapping.isEmpty()) {
            CgmesReports.substationMappingReport(this.context.getReportNode(), this.substationMapping.size(), this.substationMapping.toString());
            LOG.warn("Original {} Substation container(s) connected by transformers have been merged in IIDM. Map of original Substation to IIDM: {}", (Object)this.substationMapping.size(), this.substationMapping);
        }
    }

    private void buildReferenceVoltageLevels(Map<String, Set<String>> fictitiousVoltageLevelAdjacency) {
        this.voltageLevelMapping.forEach((key, value) -> {
            if (this.fictitiousVoltageLevels.containsKey(key) && !this.fictitiousVoltageLevels.containsKey(value)) {
                this.referenceVoltageLevels.put((String)key, (String)value);
            }
        });
        HashSet<String> visited = new HashSet<String>();
        for (String fictitiousVoltageLevelId : fictitiousVoltageLevelAdjacency.keySet()) {
            if (visited.contains(fictitiousVoltageLevelId)) continue;
            Set<String> vlAds = NodeContainerMapping.allConnected(fictitiousVoltageLevelAdjacency, visited, fictitiousVoltageLevelId);
            this.referenceVoltageLevel(vlAds).ifPresent(referenceId -> this.recordReferenceVoltageLevel(vlAds, (String)referenceId));
        }
        this.fictitiousVoltageLevels.keySet().stream().filter(fictitiousVoltageLevel -> !this.referenceVoltageLevels.containsKey(fictitiousVoltageLevel)).findFirst().ifPresent(fictitiousVoltageLevelIdWithoutReference -> {
            throw new ConversionException("Fictitious voltage level without reference: " + fictitiousVoltageLevelIdWithoutReference);
        });
    }

    private Optional<String> referenceVoltageLevel(Set<String> voltageLevelIds) {
        return voltageLevelIds.stream().filter(vl -> !this.fictitiousVoltageLevels.containsKey(vl)).min(Comparator.naturalOrder());
    }

    private void recordReferenceVoltageLevel(Set<String> voltageLevelIds, String referenceId) {
        voltageLevelIds.stream().filter(this.fictitiousVoltageLevels::containsKey).forEach(vl -> this.referenceVoltageLevels.put((String)vl, referenceId));
    }

    private static Set<String> allConnected(Map<String, Set<String>> adjacency, Set<String> visited, String id) {
        ArrayList<String> allConnected = new ArrayList<String>();
        allConnected.add(id);
        visited.add(id);
        for (int k = 0; k < allConnected.size(); ++k) {
            String vl0 = (String)allConnected.get(k);
            if (!adjacency.containsKey(vl0)) continue;
            adjacency.get(vl0).forEach(ad -> {
                if (visited.contains(ad)) {
                    return;
                }
                allConnected.add((String)ad);
                visited.add((String)ad);
            });
        }
        return new HashSet<String>(allConnected);
    }

    private String representativeVoltageLevelId(Collection<String> voltageLevelIds) {
        Optional<String> existingVoltageLevelId = voltageLevelIds.stream().filter(voltageLevelId -> !this.fictitiousVoltageLevels.containsKey(voltageLevelId)).min(Comparator.naturalOrder());
        if (existingVoltageLevelId.isPresent()) {
            return existingVoltageLevelId.get();
        }
        Optional<String> fictitiousVoltageLevelIdForLineContainer = voltageLevelIds.stream().filter(voltageLevelId -> !this.isSubstationContainer((String)voltageLevelId)).min(Comparator.naturalOrder());
        return fictitiousVoltageLevelIdForLineContainer.orElseGet(() -> (String)voltageLevelIds.stream().min(Comparator.naturalOrder()).orElseThrow(() -> new IllegalStateException("Unexpected: voltageLevelIds list is empty")));
    }

    private String representativeSubstationId(Collection<String> substationIds) {
        return substationIds.stream().filter(substationId -> this.context.config().substationIdsExcludedFromMapping().stream().noneMatch(substationId::matches)).min(Comparator.naturalOrder()).orElse(substationIds.iterator().next());
    }

    private static void recordMergedIds(Map<String, String> mapping, Collection<String> mergedIds, String representativeId) {
        for (String id : mergedIds) {
            if (id.equals(representativeId)) continue;
            mapping.put(id, representativeId);
        }
    }

    private List<String> substationsIds(PropertyBags tends) {
        ArrayList<String> substationsIds = new ArrayList<String>();
        for (PropertyBag end : tends) {
            String sid;
            Optional cgmesContainer;
            CgmesTerminal t = this.context.cgmes().terminal(end.getId("Terminal"));
            Optional nodeId = this.context.cgmes().node(t, this.context.nodeBreaker());
            if (!nodeId.isPresent() || this.context.boundary().containsNode((String)nodeId.get()) || !(cgmesContainer = this.context.cgmes().nodeContainer((String)nodeId.get())).isPresent() || (sid = ((CgmesContainer)cgmesContainer.get()).substation()) == null) continue;
            substationsIds.add(this.context.namingStrategy().getIidmId("Substation", sid));
        }
        return substationsIds;
    }

    Set<String> getFictitiousVoltageLevelsForLineContainersToBeCreated() {
        return this.fictitiousVoltageLevels.keySet().stream().filter(fictitiousVoltageLevelId -> !this.isSubstationContainer((String)fictitiousVoltageLevelId)).map(this::voltageLevelIidm).filter(this.fictitiousVoltageLevels::containsKey).collect(Collectors.toSet());
    }

    Optional<String> getContainerId(String fictitiousVoltageLevelId) {
        return this.fictitiousVoltageLevels.containsKey(fictitiousVoltageLevelId) ? Optional.of(this.fictitiousVoltageLevels.get(fictitiousVoltageLevelId).containerId()) : Optional.empty();
    }

    Optional<String> getContainerName(String fictitiousVoltageLevelId) {
        Optional<String> containerId = this.getContainerId(fictitiousVoltageLevelId);
        if (containerId.isPresent()) {
            CgmesContainer cgmesContainer = this.context.cgmes().container(containerId.get());
            return cgmesContainer != null ? Optional.of(cgmesContainer.name()) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean isSubstationContainer(String fictitiousVoltageLevelId) {
        Optional<String> containerId = this.getContainerId(fictitiousVoltageLevelId);
        if (containerId.isPresent()) {
            CgmesContainer cgmesContainer = this.context.cgmes().container(containerId.get());
            return cgmesContainer != null && cgmesContainer.isSubstation();
        }
        return false;
    }

    Optional<String> getReferenceVoltageLevelId(String fictitiousVoltageLevelId) {
        if (this.referenceVoltageLevels.containsKey(fictitiousVoltageLevelId)) {
            String referenceVoltageLevelId = this.referenceVoltageLevels.get(fictitiousVoltageLevelId);
            return Optional.ofNullable(this.voltageLevelIidm(referenceVoltageLevelId));
        }
        return Optional.empty();
    }

    public String getFictitiousVoltageLevelForContainer(String containerId, String nodeId) {
        return NodeContainerMapping.getFictitiousVoltageLevelForContainer(containerId, nodeId, this.context.config().getCreateFictitiousVoltageLevelsForEveryNode());
    }

    private static String getFictitiousVoltageLevelForContainer(String containerId, String nodeId, boolean fictitiousVoltageLevelForEveryNode) {
        return fictitiousVoltageLevelForEveryNode ? nodeId + "_VL" : containerId + "_VL";
    }

    private record ContainerR(String containerId, Set<String> nodeIdSet) {
    }
}

