/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.conversion.CgmesImportPostProcessor;
import com.powsybl.cgmes.conversion.CgmesModelExtension;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerPhaseAngleClockAdder;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerPhaseAngleClockAdder;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import com.powsybl.triplestore.api.TripleStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={CgmesImportPostProcessor.class})
public class PhaseAngleClock
implements CgmesImportPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PhaseAngleClock.class);

    @Override
    public String getName() {
        return "PhaseAngleClock";
    }

    @Override
    public void process(Network network, TripleStore tripleStore) {
        CgmesModelExtension cgmesExtension = (CgmesModelExtension)network.getExtension(CgmesModelExtension.class);
        if (cgmesExtension == null) {
            LOG.warn("PhaseAngleClock-PostProcessor: Unexpected null cgmesExtension pointer");
            return;
        }
        CgmesModel cgmes = cgmesExtension.getCgmesModel();
        if (cgmes == null) {
            LOG.warn("PhaseAngleClock-PostProcessor: Unexpected null cgmesModel pointer");
            return;
        }
        cgmes.groupedTransformerEnds().forEach((t, ends) -> {
            if (ends.size() == 2) {
                this.phaseAngleClockTwoWindingTransformer((PropertyBags)ends, network);
            } else if (ends.size() == 3) {
                this.phaseAngleClockThreeWindingTransformer((PropertyBags)ends, network);
            } else {
                throw new PowsyblException(String.format("Unexpected TransformerEnds: ends %d", ends.size()));
            }
        });
    }

    private void phaseAngleClockTwoWindingTransformer(PropertyBags ends, Network network) {
        PropertyBag end1 = (PropertyBag)ends.get(0);
        PropertyBag end2 = (PropertyBag)ends.get(1);
        int phaseAngleClock1 = end1.asInt("phaseAngleClock", 0);
        int phaseAngleClock2 = end2.asInt("phaseAngleClock", 0);
        if (phaseAngleClock1 == 0 && phaseAngleClock2 == 0) {
            return;
        }
        String id = end1.getId("PowerTransformer");
        TwoWindingsTransformer tx = (TwoWindingsTransformer)network.getIdentifiable(id);
        if (tx != null) {
            if (phaseAngleClock1 != 0) {
                String reason = "Unsupported modelling: twoWindingsTransformer with phaseAngleClock at end1";
                String what = "PhaseAngleClock-PostProcessor";
                LOG.warn("Ignored {}. Reason: {}.", (Object)what, (Object)reason);
            }
            if (phaseAngleClock2 != 0) {
                ((TwoWindingsTransformerPhaseAngleClockAdder)tx.newExtension(TwoWindingsTransformerPhaseAngleClockAdder.class)).withPhaseAngleClock(phaseAngleClock2).add();
            }
        }
    }

    private void phaseAngleClockThreeWindingTransformer(PropertyBags ends, Network network) {
        PropertyBag end1 = (PropertyBag)ends.get(0);
        PropertyBag end2 = (PropertyBag)ends.get(1);
        PropertyBag end3 = (PropertyBag)ends.get(2);
        int phaseAngleClock1 = end1.asInt("phaseAngleClock", 0);
        int phaseAngleClock2 = end2.asInt("phaseAngleClock", 0);
        int phaseAngleClock3 = end3.asInt("phaseAngleClock", 0);
        if (phaseAngleClock1 == 0 && phaseAngleClock2 == 0 && phaseAngleClock3 == 0) {
            return;
        }
        String id = end1.getId("PowerTransformer");
        ThreeWindingsTransformer tx = (ThreeWindingsTransformer)network.getIdentifiable(id);
        if (tx != null) {
            if (phaseAngleClock1 != 0) {
                String reason = "Unsupported modelling: threeWindingsTransformer with phaseAngleClock at end1";
                String what = "PhaseAngleClock-PostProcessor";
                LOG.warn("Ignored {}. Reason: {}.", (Object)what, (Object)reason);
            }
            if (phaseAngleClock2 != 0 || phaseAngleClock3 != 0) {
                ((ThreeWindingsTransformerPhaseAngleClockAdder)tx.newExtension(ThreeWindingsTransformerPhaseAngleClockAdder.class)).withPhaseAngleClockLeg2(phaseAngleClock2).withPhaseAngleClockLeg3(phaseAngleClock3).add();
            }
        }
    }
}

