/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegulatingControlMappingForTransformers {
    private static final String TAP_CHANGER_CONTROL = "TapChangerControl";
    private final RegulatingControlMapping parent;
    private final Context context;
    private final Map<String, CgmesRegulatingControlForTwoWindingsTransformer> t2xMapping;
    private final Map<String, CgmesRegulatingControlForThreeWindingsTransformer> t3xMapping;
    private static final Logger LOG = LoggerFactory.getLogger(RegulatingControlMappingForTransformers.class);

    RegulatingControlMappingForTransformers(RegulatingControlMapping parent, Context context) {
        this.parent = parent;
        this.context = context;
        this.t2xMapping = new HashMap<String, CgmesRegulatingControlForTwoWindingsTransformer>();
        this.t3xMapping = new HashMap<String, CgmesRegulatingControlForThreeWindingsTransformer>();
    }

    public void add(String transformerId, CgmesRegulatingControlRatio rcRtc, CgmesRegulatingControlPhase rcPtc) {
        CgmesRegulatingControlForTwoWindingsTransformer rc = new CgmesRegulatingControlForTwoWindingsTransformer();
        rc.ratioTapChanger = rcRtc;
        rc.phaseTapChanger = rcPtc;
        this.t2xMapping.put(transformerId, rc);
    }

    public void add(String transformerId, CgmesRegulatingControlRatio rcRtc1, CgmesRegulatingControlPhase rcPtc1, CgmesRegulatingControlRatio rcRtc2, CgmesRegulatingControlPhase rcPtc2, CgmesRegulatingControlRatio rcRtc3, CgmesRegulatingControlPhase rcPtc3) {
        CgmesRegulatingControlForThreeWindingsTransformer rc = new CgmesRegulatingControlForThreeWindingsTransformer();
        rc.ratioTapChanger1 = rcRtc1;
        rc.phaseTapChanger1 = rcPtc1;
        rc.ratioTapChanger2 = rcRtc2;
        rc.phaseTapChanger2 = rcPtc2;
        rc.ratioTapChanger3 = rcRtc3;
        rc.phaseTapChanger3 = rcPtc3;
        this.t3xMapping.put(transformerId, rc);
    }

    public CgmesRegulatingControlRatio buildRegulatingControlRatio(String id, String regulatingControlId, String tculControlMode, boolean tapChangerControlEnabled) {
        CgmesRegulatingControlRatio rtc = new CgmesRegulatingControlRatio();
        rtc.id = id;
        rtc.regulatingControlId = regulatingControlId;
        rtc.tculControlMode = tculControlMode;
        rtc.tapChangerControlEnabled = tapChangerControlEnabled;
        return rtc;
    }

    public CgmesRegulatingControlPhase buildRegulatingControlPhase(String id, String regulatingControlId, boolean tapChangerControlEnabled, boolean ltcFlag) {
        CgmesRegulatingControlPhase rtc = new CgmesRegulatingControlPhase();
        rtc.id = id;
        rtc.regulatingControlId = regulatingControlId;
        rtc.tapChangerControlEnabled = tapChangerControlEnabled;
        rtc.ltcFlag = ltcFlag;
        return rtc;
    }

    void applyTapChangersRegulatingControl(Network network) {
        network.getTwoWindingsTransformerStream().forEach(this::applyTapChangersRegulatingControl);
        network.getThreeWindingsTransformerStream().forEach(this::applyTapChangersRegulatingControl);
    }

    private void applyTapChangersRegulatingControl(TwoWindingsTransformer twt) {
        CgmesRegulatingControlForTwoWindingsTransformer rc = this.t2xMapping.get(twt.getId());
        this.applyTapChangersRegulatingControl(twt, rc);
    }

    private void applyTapChangersRegulatingControl(TwoWindingsTransformer twt, CgmesRegulatingControlForTwoWindingsTransformer rc) {
        if (rc == null) {
            return;
        }
        RegulatingControlMapping.RegulatingControl rtcControl = this.getTapChangerControl(rc.ratioTapChanger);
        boolean rtcRegulating = RegulatingControlMappingForTransformers.isTapChangerRegulating(rtcControl, rc.ratioTapChanger);
        RegulatingControlMapping.RegulatingControl ptcControl = this.getTapChangerControl(rc.phaseTapChanger);
        boolean ptcRegulating = RegulatingControlMappingForTransformers.isTapChangerRegulating(ptcControl, rc.phaseTapChanger);
        this.setPhaseTapChangerControl(ptcRegulating, rc.phaseTapChanger, ptcControl, twt.getPhaseTapChanger());
        boolean regulatingSet = twt.hasPhaseTapChanger() && twt.getPhaseTapChanger().isRegulating();
        rtcRegulating = this.checkOnlyOneEnabled(twt.getId(), rtcRegulating, regulatingSet, "ratioTapChanger");
        this.setRatioTapChangerControl(rtcRegulating, rc.ratioTapChanger, rtcControl, twt.getRatioTapChanger());
    }

    private void applyTapChangersRegulatingControl(ThreeWindingsTransformer twt) {
        CgmesRegulatingControlForThreeWindingsTransformer rc = this.t3xMapping.get(twt.getId());
        this.applyTapChangersRegulatingControl(twt, rc);
    }

    private void applyTapChangersRegulatingControl(ThreeWindingsTransformer twt, CgmesRegulatingControlForThreeWindingsTransformer rc) {
        if (rc == null) {
            return;
        }
        RegulatingControlMapping.RegulatingControl rtcControl1 = this.getTapChangerControl(rc.ratioTapChanger1);
        boolean rtcRegulating1 = RegulatingControlMappingForTransformers.isTapChangerRegulating(rtcControl1, rc.ratioTapChanger1);
        RegulatingControlMapping.RegulatingControl ptcControl1 = this.getTapChangerControl(rc.phaseTapChanger1);
        boolean ptcRegulating1 = RegulatingControlMappingForTransformers.isTapChangerRegulating(ptcControl1, rc.phaseTapChanger1);
        RegulatingControlMapping.RegulatingControl rtcControl2 = this.getTapChangerControl(rc.ratioTapChanger2);
        boolean rtcRegulating2 = RegulatingControlMappingForTransformers.isTapChangerRegulating(rtcControl2, rc.ratioTapChanger2);
        RegulatingControlMapping.RegulatingControl ptcControl2 = this.getTapChangerControl(rc.phaseTapChanger2);
        boolean ptcRegulating2 = RegulatingControlMappingForTransformers.isTapChangerRegulating(ptcControl2, rc.phaseTapChanger2);
        RegulatingControlMapping.RegulatingControl rtcControl3 = this.getTapChangerControl(rc.ratioTapChanger3);
        boolean rtcRegulating3 = RegulatingControlMappingForTransformers.isTapChangerRegulating(rtcControl3, rc.ratioTapChanger3);
        RegulatingControlMapping.RegulatingControl ptcControl3 = this.getTapChangerControl(rc.phaseTapChanger3);
        boolean ptcRegulating3 = RegulatingControlMappingForTransformers.isTapChangerRegulating(ptcControl3, rc.phaseTapChanger3);
        this.setPhaseTapChangerControl(ptcRegulating1, rc.phaseTapChanger1, ptcControl1, twt.getLeg1().getPhaseTapChanger());
        boolean regulatingSet = twt.getLeg1().hasPhaseTapChanger() && twt.getLeg1().getPhaseTapChanger().isRegulating();
        rtcRegulating1 = this.checkOnlyOneEnabled(twt.getId(), rtcRegulating1, regulatingSet, "ratioTapChanger at Leg1");
        this.setRatioTapChangerControl(rtcRegulating1, rc.ratioTapChanger1, rtcControl1, twt.getLeg1().getRatioTapChanger());
        regulatingSet = regulatingSet || twt.getLeg1().hasRatioTapChanger() && twt.getLeg1().getRatioTapChanger().isRegulating();
        ptcRegulating2 = this.checkOnlyOneEnabled(twt.getId(), ptcRegulating2, regulatingSet, "phaseTapChanger at Leg2");
        this.setPhaseTapChangerControl(ptcRegulating2, rc.phaseTapChanger2, ptcControl2, twt.getLeg2().getPhaseTapChanger());
        regulatingSet = regulatingSet || twt.getLeg2().hasPhaseTapChanger() && twt.getLeg2().getPhaseTapChanger().isRegulating();
        rtcRegulating2 = this.checkOnlyOneEnabled(twt.getId(), rtcRegulating2, regulatingSet, "ratioTapChanger at Leg2");
        this.setRatioTapChangerControl(rtcRegulating2, rc.ratioTapChanger2, rtcControl2, twt.getLeg2().getRatioTapChanger());
        regulatingSet = regulatingSet || twt.getLeg2().hasRatioTapChanger() && twt.getLeg2().getRatioTapChanger().isRegulating();
        ptcRegulating3 = this.checkOnlyOneEnabled(twt.getId(), ptcRegulating3, regulatingSet, "phaseTapChanger at Leg3");
        this.setPhaseTapChangerControl(ptcRegulating3, rc.phaseTapChanger3, ptcControl3, twt.getLeg3().getPhaseTapChanger());
        regulatingSet = regulatingSet || twt.getLeg3().hasPhaseTapChanger() && twt.getLeg3().getPhaseTapChanger().isRegulating();
        rtcRegulating3 = this.checkOnlyOneEnabled(twt.getId(), rtcRegulating3, regulatingSet, "ratioTapChanger at Leg3");
        this.setRatioTapChangerControl(rtcRegulating3, rc.ratioTapChanger3, rtcControl3, twt.getLeg3().getRatioTapChanger());
    }

    private static boolean isTapChangerRegulating(RegulatingControlMapping.RegulatingControl rc, CgmesRegulatingControl tcrc) {
        return rc != null && rc.enabled && tcrc.tapChangerControlEnabled;
    }

    private boolean checkOnlyOneEnabled(String transformerId, boolean regulating, boolean setRegulating, String disabledTapChanger) {
        if (!regulating) {
            return false;
        }
        if (setRegulating) {
            this.context.fixed(transformerId, "Unsupported more than one regulating control enabled. Disable " + disabledTapChanger);
            return false;
        }
        return true;
    }

    private void setRatioTapChangerControl(boolean regulating, CgmesRegulatingControlRatio rc, RegulatingControlMapping.RegulatingControl control, RatioTapChanger rtc) {
        if (control == null || rtc == null) {
            return;
        }
        boolean okSet = false;
        if (RegulatingControlMapping.isControlModeVoltage(control.mode)) {
            okSet = this.setRtcRegulatingControlVoltage(rc.id, regulating, control, rtc, this.context);
        } else if (!RegulatingControlMappingForTransformers.isControlModeFixed(control.mode)) {
            this.context.fixed(control.mode, "Unsupported regulation mode for Ratio tap changer. Considered as a fixed ratio tap changer.");
        }
        control.setCorrectlySet(okSet);
    }

    private boolean setRtcRegulatingControlVoltage(String rtcId, boolean regulating, RegulatingControlMapping.RegulatingControl control, RatioTapChanger rtc, Context context) {
        boolean validTargetDeadband;
        boolean validTargetValue;
        Optional<Terminal> regulatingTerminal = RegulatingTerminalMapper.mapForVoltageControl(control.cgmesTerminal, context);
        if (regulatingTerminal.isEmpty()) {
            context.missing(String.format("IIDM terminal for this CGMES terminal: %s", control.cgmesTerminal));
            return false;
        }
        boolean bl = validTargetValue = control.targetValue > 0.0;
        if (!validTargetValue) {
            context.invalid(rtcId, "Regulating control has a bad target voltage " + control.targetValue);
            CgmesReports.badVoltageTargetValueRegulatingControlReport(context.getReportNode(), rtcId, control.targetValue);
        }
        boolean bl2 = validTargetDeadband = control.targetDeadband >= 0.0;
        if (!validTargetDeadband) {
            context.invalid(rtcId, "Regulating control has a bad target deadband " + control.targetDeadband);
            CgmesReports.badTargetDeadbandRegulatingControlReport(context.getReportNode(), rtcId, control.targetDeadband);
        }
        ((RatioTapChanger)((RatioTapChanger)rtc.setRegulationTerminal(regulatingTerminal.get())).setTargetV(control.targetValue).setTargetDeadband(validTargetDeadband ? control.targetDeadband : Double.NaN)).setRegulating(regulating && validTargetValue && validTargetDeadband);
        return true;
    }

    private void setPhaseTapChangerControl(boolean regulating, CgmesRegulatingControlPhase rc, RegulatingControlMapping.RegulatingControl control, PhaseTapChanger ptc) {
        if (control == null || ptc == null) {
            return;
        }
        boolean okSet = false;
        if (control.mode.endsWith("currentflow")) {
            okSet = this.setPtcRegulatingControlCurrentFlow(rc.id, regulating, rc.ltcFlag, control, ptc, this.context);
        } else if (control.mode.endsWith("activepower")) {
            okSet = this.setPtcRegulatingControlActivePower(rc.id, regulating, rc.ltcFlag, control, ptc, this.context);
        } else if (!control.mode.endsWith("fixed")) {
            this.context.fixed(control.mode, "Unsupported regulating mode for Phase tap changer. Considered as FIXED_TAP");
        }
        control.setCorrectlySet(okSet);
    }

    private boolean setPtcRegulatingControlCurrentFlow(String ptcId, boolean regulating, boolean ltcFlag, RegulatingControlMapping.RegulatingControl control, PhaseTapChanger ptc, Context context) {
        PhaseTapChanger.RegulationMode regulationMode = this.getPtcRegulatingMode(ltcFlag, PhaseTapChanger.RegulationMode.CURRENT_LIMITER);
        return this.setPtcRegulatingControl(ptcId, regulating, regulationMode, control, ptc, context);
    }

    private boolean setPtcRegulatingControlActivePower(String ptcId, boolean regulating, boolean ltcFlag, RegulatingControlMapping.RegulatingControl control, PhaseTapChanger ptc, Context context) {
        PhaseTapChanger.RegulationMode regulationMode = this.getPtcRegulatingMode(ltcFlag, PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL);
        return this.setPtcRegulatingControl(ptcId, regulating, regulationMode, control, ptc, context);
    }

    private boolean setPtcRegulatingControl(String ptcId, boolean regulating, PhaseTapChanger.RegulationMode regulationMode, RegulatingControlMapping.RegulatingControl control, PhaseTapChanger ptc, Context context) {
        boolean validTargetDeadband;
        RegulatingTerminalMapper.TerminalAndSign mappedRegulatingTerminal = RegulatingTerminalMapper.mapForFlowControl(control.cgmesTerminal, context).orElseGet(() -> new RegulatingTerminalMapper.TerminalAndSign(null, 1));
        if (mappedRegulatingTerminal.getTerminal() == null) {
            context.missing(String.format("IIDM terminal for this CGMES terminal: %s", control.cgmesTerminal));
            return false;
        }
        boolean fixedRegulating = regulating;
        if (regulating && regulationMode == PhaseTapChanger.RegulationMode.FIXED_TAP) {
            context.fixed(ptcId, "RegulationMode: regulating is set to true whereas regulationMode is set to FIXED_TAP: regulating fixed to false");
            fixedRegulating = false;
        }
        boolean bl = validTargetDeadband = control.targetDeadband >= 0.0;
        if (!validTargetDeadband) {
            context.invalid(ptcId, "Regulating control has a bad target deadband " + control.targetDeadband);
            CgmesReports.badTargetDeadbandRegulatingControlReport(context.getReportNode(), ptcId, control.targetDeadband);
        }
        ((PhaseTapChanger)((PhaseTapChanger)ptc.setRegulationTerminal(mappedRegulatingTerminal.getTerminal())).setRegulationValue(control.targetValue * (double)mappedRegulatingTerminal.getSign()).setTargetDeadband(validTargetDeadband ? control.targetDeadband : Double.NaN)).setRegulationMode(regulationMode).setRegulating(fixedRegulating && validTargetDeadband);
        return true;
    }

    private PhaseTapChanger.RegulationMode getPtcRegulatingMode(boolean ltcFlag, PhaseTapChanger.RegulationMode regulationMode) {
        PhaseTapChanger.RegulationMode finalRegulationMode = PhaseTapChanger.RegulationMode.FIXED_TAP;
        if (ltcFlag) {
            finalRegulationMode = regulationMode;
        }
        return finalRegulationMode;
    }

    private RegulatingControlMapping.RegulatingControl getTapChangerControl(CgmesRegulatingControl rc) {
        if (rc == null) {
            return null;
        }
        String controlId = rc.regulatingControlId;
        if (controlId == null) {
            LOG.trace("Regulating control Id not present for tap changer {}", (Object)rc.id);
            return null;
        }
        RegulatingControlMapping.RegulatingControl control = this.parent.cachedRegulatingControls().get(controlId);
        if (control == null) {
            this.context.missing(String.format("Regulating control %s", controlId));
            return null;
        }
        return control;
    }

    public static String getRegulatingControlId(PropertyBag p) {
        return p.getId(TAP_CHANGER_CONTROL);
    }

    public boolean getRegulating(String controlId) {
        RegulatingControlMapping.RegulatingControl control;
        if (controlId != null && (control = this.parent.cachedRegulatingControls().get(controlId)) != null) {
            return control.enabled;
        }
        return false;
    }

    private static boolean isControlModeFixed(String controlMode) {
        return controlMode != null && controlMode.endsWith("fixed");
    }

    private static final class CgmesRegulatingControlForTwoWindingsTransformer {
        CgmesRegulatingControlRatio ratioTapChanger;
        CgmesRegulatingControlPhase phaseTapChanger;

        private CgmesRegulatingControlForTwoWindingsTransformer() {
        }
    }

    public static class CgmesRegulatingControlRatio
    extends CgmesRegulatingControl {
        String tculControlMode;
    }

    public static class CgmesRegulatingControlPhase
    extends CgmesRegulatingControl {
        boolean ltcFlag;
    }

    private static final class CgmesRegulatingControlForThreeWindingsTransformer {
        CgmesRegulatingControlRatio ratioTapChanger1;
        CgmesRegulatingControlPhase phaseTapChanger1;
        CgmesRegulatingControlRatio ratioTapChanger2;
        CgmesRegulatingControlPhase phaseTapChanger2;
        CgmesRegulatingControlRatio ratioTapChanger3;
        CgmesRegulatingControlPhase phaseTapChanger3;

        private CgmesRegulatingControlForThreeWindingsTransformer() {
        }
    }

    private static class CgmesRegulatingControl {
        String id;
        String regulatingControlId;
        boolean tapChangerControlEnabled;

        private CgmesRegulatingControl() {
        }
    }
}

