/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.elements.AbstractBranchConversion;
import com.powsybl.cgmes.conversion.elements.EquipmentAtBoundaryConversion;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.util.TieLineUtil;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;

public class ACLineSegmentConversion
extends AbstractBranchConversion
implements EquipmentAtBoundaryConversion {
    private DanglingLine danglingLine;

    public ACLineSegmentConversion(PropertyBag line, Context context) {
        super("ACLineSegment", line, context);
    }

    @Override
    public boolean valid() {
        for (int k = 1; k <= 2; ++k) {
            if (this.nodeId(k) != null) continue;
            this.missing(this.nodeIdPropertyName() + k);
            return false;
        }
        return true;
    }

    @Override
    public void convert() {
        this.convertLine();
    }

    @Override
    public void convertAtBoundary() {
        if (this.isBoundary(1)) {
            this.convertLineAtBoundary(1);
        } else if (this.isBoundary(2)) {
            this.convertLineAtBoundary(2);
        } else {
            throw new ConversionException("Boundary must be at one end of the line");
        }
    }

    @Override
    public Optional<DanglingLine> getDanglingLine() {
        return Optional.ofNullable(this.danglingLine);
    }

    public boolean isConnectedAtBothEnds() {
        return this.terminalConnected(1) && this.terminalConnected(2);
    }

    public static void convertToTieLine(Context context, DanglingLine dl1, DanglingLine dl2) {
        TieLineAdder adder = context.network().newTieLine().setDanglingLine1(dl1.getId()).setDanglingLine2(dl2.getId());
        ACLineSegmentConversion.identify(context, adder, context.namingStrategy().getIidmId("TieLine", TieLineUtil.buildMergedId((String)dl1.getId(), (String)dl2.getId())), TieLineUtil.buildMergedName((String)dl1.getId(), (String)dl2.getId(), (String)dl1.getNameOrId(), (String)dl2.getNameOrId()));
        adder.add();
    }

    private void convertLine() {
        double r = this.p.asDouble("r");
        double x = this.p.asDouble("x");
        double gch = this.p.asDouble("gch", 0.0);
        double bch = this.p.asDouble("bch");
        this.convertBranch(r, x, gch, bch);
    }

    private void convertLineAtBoundary(int boundarySide) {
        if (this.context.config().convertBoundary()) {
            this.convertLine();
        } else {
            double r = this.p.asDouble("r");
            double x = this.p.asDouble("x");
            double gch = this.p.asDouble("gch", 0.0);
            double bch = this.p.asDouble("bch");
            String eqInstance = (String)this.p.get((Object)"graph");
            this.danglingLine = this.convertToDanglingLine(eqInstance, boundarySide, r, x, gch, bch);
        }
    }
}

