/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentInjectionConversion;
import com.powsybl.cgmes.extensions.CgmesDanglingLineBoundaryNodeAdder;
import com.powsybl.cgmes.model.CgmesContainer;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.BranchAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.SV;
import com.powsybl.iidm.network.util.TieLineUtil;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.List;
import java.util.Optional;

public abstract class AbstractConductingEquipmentConversion
extends AbstractIdentifiedObjectConversion {
    private final int numTerminals;
    private final TerminalData[] terminals;
    private final PowerFlow steadyStatePowerFlow;

    protected AbstractConductingEquipmentConversion(String type, PropertyBag p, Context context) {
        super(type, p, context);
        this.numTerminals = 1;
        this.terminals = new TerminalData[]{null, null, null};
        this.terminals[0] = new TerminalData("Terminal", p, context);
        this.steadyStatePowerFlow = new PowerFlow(p, "p", "q");
    }

    protected AbstractConductingEquipmentConversion(String type, PropertyBag p, Context context, int numTerminals) {
        super(type, p, context);
        if (numTerminals > 3) {
            throw new IllegalArgumentException("Invalid number of terminals at " + this.id + ": " + numTerminals);
        }
        this.terminals = new TerminalData[]{null, null, null};
        this.numTerminals = numTerminals;
        for (int k = 1; k <= numTerminals; ++k) {
            int k0 = k - 1;
            this.terminals[k0] = new TerminalData("Terminal" + k, p, context);
        }
        this.steadyStatePowerFlow = PowerFlow.UNDEFINED;
    }

    protected AbstractConductingEquipmentConversion(String type, PropertyBags ps, Context context) {
        super(type, ps, context);
        this.numTerminals = ps.size();
        this.terminals = new TerminalData[]{null, null, null};
        if (this.numTerminals > 3) {
            throw new IllegalStateException("numTerminals should be less or equal to 3 but is " + this.numTerminals);
        }
        for (int k = 1; k <= this.numTerminals; ++k) {
            int k0 = k - 1;
            this.terminals[k0] = new TerminalData("Terminal", (PropertyBag)ps.get(k0), context);
        }
        this.steadyStatePowerFlow = PowerFlow.UNDEFINED;
    }

    public String findPairingKey(String boundaryNode) {
        return AbstractConductingEquipmentConversion.findPairingKey(this.context, boundaryNode);
    }

    public static String findPairingKey(Context context, String boundaryNode) {
        return context.boundary().nameAtBoundary(boundaryNode);
    }

    public String boundaryNode() {
        if (this.isBoundary(1)) {
            return this.nodeId(1);
        }
        if (this.isBoundary(2)) {
            return this.nodeId(2);
        }
        return null;
    }

    @Override
    public boolean insideBoundary() {
        for (int k = 1; k <= this.numTerminals; ++k) {
            if (this.context.boundary().containsNode(this.nodeId(k))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void convertInsideBoundary() {
        if (this.context.config().convertBoundary()) {
            if (this.valid()) {
                this.convert();
            }
        } else {
            for (int k = 1; k <= this.numTerminals; ++k) {
                if (!this.terminalConnected(k)) continue;
                this.context.boundary().addPowerFlowAtNode(this.nodeId(k), this.powerFlowSV(k));
            }
        }
    }

    @Override
    public boolean valid() {
        for (int k = 1; k <= this.numTerminals; ++k) {
            if (this.nodeId(k) == null) {
                this.missing(this.nodeIdPropertyName() + k);
                return false;
            }
            if (!this.voltageLevel(k).isEmpty()) continue;
            this.missing(String.format("VoltageLevel of terminal %d %s (iidm %s)", k, this.cgmesVoltageLevelId(k), this.iidmVoltageLevelId(k)));
            return false;
        }
        return true;
    }

    boolean validNodes() {
        for (int k = 1; k <= this.numTerminals; ++k) {
            if (this.nodeId(k) != null) continue;
            this.missing(this.nodeIdPropertyName() + k);
            return false;
        }
        return true;
    }

    protected String nodeIdPropertyName() {
        return this.context.nodeBreaker() ? "ConnectivityNode" : "TopologicalNode";
    }

    String terminalId() {
        return this.terminals[0].t.id();
    }

    String terminalId(int n) {
        return this.terminals[n - 1].t.id();
    }

    protected String nodeId() {
        return this.context.nodeBreaker() ? this.terminals[0].t.connectivityNode() : this.terminals[0].t.topologicalNode();
    }

    protected String nodeId(int n) {
        return this.context.nodeBreaker() ? this.terminals[n - 1].t.connectivityNode() : this.terminals[n - 1].t.topologicalNode();
    }

    protected String topologicalNodeId(int n) {
        return this.terminals[n - 1].t.topologicalNode();
    }

    protected String connectivityNodeId(int n) {
        return this.terminals[n - 1].t.connectivityNode();
    }

    protected boolean isBoundary(int n) {
        return this.voltageLevel(n).isEmpty() || this.context.boundary().containsNode(this.nodeId(n));
    }

    public DanglingLine convertToDanglingLine(String eqInstance, int boundarySide) {
        return this.convertToDanglingLine(eqInstance, boundarySide, 0.0, 0.0, 0.0, 0.0);
    }

    public DanglingLine convertToDanglingLine(String eqInstance, int boundarySide, double r, double x, double gch, double bch) {
        DanglingLine dl;
        int modelSide = 3 - boundarySide;
        String boundaryNode = this.nodeId(boundarySide);
        if (!this.isBoundary(boundarySide) || this.isBoundary(modelSide)) {
            throw new PowsyblException(String.format("Unexpected boundarySide and modelSide at boundaryNode: %s", boundaryNode));
        }
        PowerFlow f = new PowerFlow(0.0, 0.0);
        if (this.terminalConnected(boundarySide) && this.context.boundary().hasPowerFlow(boundaryNode)) {
            f = this.context.boundary().powerFlowAtNode(boundaryNode);
        }
        if (this.terminalConnected(boundarySide) && !this.context.boundary().hasPowerFlow(boundaryNode) && this.context.boundary().equivalentInjectionsAtNode(boundaryNode).isEmpty()) {
            this.missing("Equipment for modeling consumption/injection at boundary node");
        }
        DanglingLineAdder dlAdder = this.voltageLevel(modelSide).map(vl -> ((DanglingLineAdder)vl.newDanglingLine().setEnsureIdUnicity(this.context.config().isEnsureIdAliasUnicity())).setR(r).setX(x).setG(gch).setB(bch).setPairingKey(this.findPairingKey(boundaryNode))).orElseThrow(() -> new CgmesModelException("Dangling line " + this.id + " has no container"));
        this.identify((IdentifiableAdder<?, ?>)dlAdder);
        this.connect((InjectionAdder<?, ?>)dlAdder, modelSide);
        Optional<EquivalentInjectionConversion> equivalentInjectionConversion = AbstractConductingEquipmentConversion.getEquivalentInjectionConversionForDanglingLine(this.context, boundaryNode, eqInstance);
        if (equivalentInjectionConversion.isPresent()) {
            dl = equivalentInjectionConversion.get().convertOverDanglingLine(dlAdder, f);
            Optional.ofNullable(dl.getGeneration()).ifPresent(equivalentInjectionConversion.get()::convertReactiveLimits);
        } else {
            dl = dlAdder.setP0(f.p()).setQ0(f.q()).add();
        }
        this.context.terminalMapping().add(this.terminalId(boundarySide), dl.getBoundary(), 2);
        dl.addAlias(this.terminalId(boundarySide), "CGMES.Terminal_Boundary");
        dl.setProperty("CGMES.Terminal_Boundary", this.terminalId(boundarySide));
        dl.addAlias(this.terminalId(boundarySide == 1 ? 2 : 1), "CGMES.Terminal1");
        dl.setProperty("CGMES.Terminal", this.terminalId(boundarySide == 1 ? 2 : 1));
        Optional.ofNullable(this.topologicalNodeId(boundarySide)).ifPresent(tn -> dl.setProperty("CGMES.TopologicalNode_Boundary", tn));
        Optional.ofNullable(this.connectivityNodeId(boundarySide)).ifPresent(cn -> dl.setProperty("CGMES.ConnectivityNode_Boundary", cn));
        this.setBoundaryNodeInfo(boundaryNode, dl);
        this.context.convertedTerminal(this.terminalId(modelSide), dl.getTerminal(), 1, this.powerFlowSV(modelSide));
        if (this.context.config().computeFlowsAtBoundaryDanglingLines() && this.terminalConnected(modelSide) && !this.powerFlowSV(modelSide).defined() && this.context.boundary().hasVoltage(boundaryNode)) {
            if (this.isZ0(dl)) {
                Optional<DanglingLine.Generation> generation = Optional.ofNullable(dl.getGeneration());
                dl.getTerminal().setP(dl.getP0() - generation.map(DanglingLine.Generation::getTargetP).orElse(0.0));
                dl.getTerminal().setQ(dl.getQ0() - generation.map(DanglingLine.Generation::getTargetQ).orElse(0.0));
            } else {
                this.setDanglingLineModelSideFlow(dl, boundaryNode);
            }
        }
        return dl;
    }

    public static void calculateVoltageAndAngleInBoundaryBus(DanglingLine dl) {
        double angle;
        double v = dl.getBoundary().getV();
        if (AbstractConductingEquipmentConversion.isVoltageDefined(v, angle = dl.getBoundary().getAngle())) {
            AbstractConductingEquipmentConversion.setVoltageProperties(dl, v, angle);
        }
    }

    public static void calculateVoltageAndAngleInBoundaryBus(DanglingLine dl1, DanglingLine dl2) {
        double angle;
        double v = TieLineUtil.getBoundaryV((DanglingLine)dl1, (DanglingLine)dl2);
        if (!AbstractConductingEquipmentConversion.isVoltageDefined(v, angle = TieLineUtil.getBoundaryAngle((DanglingLine)dl1, (DanglingLine)dl2))) {
            v = dl1.getBoundary().getV();
            angle = dl1.getBoundary().getAngle();
        }
        if (!AbstractConductingEquipmentConversion.isVoltageDefined(v, angle)) {
            v = dl2.getBoundary().getV();
            angle = dl2.getBoundary().getAngle();
        }
        if (AbstractConductingEquipmentConversion.isVoltageDefined(v, angle)) {
            AbstractConductingEquipmentConversion.setVoltageProperties(dl1, v, angle);
            AbstractConductingEquipmentConversion.setVoltageProperties(dl2, v, angle);
        }
    }

    private static boolean isVoltageDefined(double v, double angle) {
        return !Double.isNaN(v) && !Double.isNaN(angle);
    }

    private static void setVoltageProperties(DanglingLine dl, double v, double angle) {
        dl.setProperty("v", Double.toString(v));
        dl.setProperty("angle", Double.toString(angle));
    }

    private void setBoundaryNodeInfo(String boundaryNode, DanglingLine dl) {
        if (this.context.boundary().isHvdc(boundaryNode) || this.context.boundary().lineAtBoundary(boundaryNode) != null) {
            ((CgmesDanglingLineBoundaryNodeAdder)dl.newExtension(CgmesDanglingLineBoundaryNodeAdder.class)).setHvdc(this.context.boundary().isHvdc(boundaryNode)).setLineEnergyIdentificationCodeEic(this.context.boundary().lineAtBoundary(boundaryNode)).add();
            if (this.context.boundary().isHvdc(boundaryNode)) {
                dl.setProperty("isHvdc", "true");
            }
            if (this.context.boundary().lineAtBoundary(boundaryNode) != null) {
                dl.setProperty("lineEnergyIdentificationCodeEIC", this.context.boundary().lineAtBoundary(boundaryNode));
            }
        }
    }

    private boolean isZ0(DanglingLine dl) {
        return dl.getR() == 0.0 && dl.getX() == 0.0 && dl.getG() == 0.0 && dl.getB() == 0.0;
    }

    private void setDanglingLineModelSideFlow(DanglingLine dl, String boundaryNode) {
        double v = this.context.boundary().vAtBoundary(boundaryNode);
        double angle = this.context.boundary().angleAtBoundary(boundaryNode);
        Optional<DanglingLine.Generation> generation = Optional.ofNullable(dl.getGeneration());
        double p = dl.getP0() - generation.map(DanglingLine.Generation::getTargetP).orElse(0.0);
        double q = dl.getQ0() - generation.map(DanglingLine.Generation::getTargetQ).orElse(0.0);
        SV svboundary = new SV(-p, -q, v, angle, TwoSides.ONE);
        double g = dl.getG() / 2.0;
        double b = dl.getB() / 2.0;
        SV svmodel = svboundary.otherSide(dl.getR(), dl.getX(), g, b, g, b, 1.0, 0.0);
        dl.getTerminal().setP(svmodel.getP());
        dl.getTerminal().setQ(svmodel.getQ());
    }

    private static Optional<EquivalentInjectionConversion> getEquivalentInjectionConversionForDanglingLine(Context context, String boundaryNode, String eqInstance) {
        List<PropertyBag> eis = context.boundary().equivalentInjectionsAtNode(boundaryNode);
        if (eis.isEmpty()) {
            return Optional.empty();
        }
        if (eis.size() == 1) {
            return Optional.of(new EquivalentInjectionConversion(eis.get(0), context));
        }
        String eqInstancePropertyName = "graph";
        List<PropertyBag> eisEqInstance = eis.stream().filter(eik -> eik.getId(eqInstancePropertyName).equals(eqInstance)).toList();
        if (eisEqInstance.size() == 1) {
            return Optional.of(new EquivalentInjectionConversion(eisEqInstance.get(0), context));
        }
        context.invalid("Boundary node " + boundaryNode, "Assembled model does not contain only one equivalent injection in the same graph " + eqInstance);
        return Optional.empty();
    }

    int iidmNode() {
        return this.iidmNode(1, true);
    }

    int iidmNode(int n) {
        return this.iidmNode(n, true);
    }

    int iidmNode(int n, boolean equipmentIsConnected) {
        if (!this.context.nodeBreaker()) {
            throw new ConversionException("Can't request an iidmNode if conversion context is not node-breaker");
        }
        VoltageLevel vl = this.terminals[n - 1].voltageLevel;
        CgmesTerminal t = this.terminals[n - 1].t;
        return this.context.nodeMapping().iidmNodeForTerminal(t, this.type.equals("Switch"), vl, equipmentIsConnected);
    }

    String busId() {
        return this.terminals[0].busId;
    }

    String busId(int n) {
        return this.terminals[n - 1].busId;
    }

    boolean terminalConnected() {
        return this.terminals[0].t.connected();
    }

    boolean terminalConnected(int n) {
        return this.terminals[n - 1].t.connected();
    }

    String cgmesVoltageLevelId(int n) {
        return this.terminals[n - 1].cgmesVoltageLevelId;
    }

    String iidmVoltageLevelId(int n) {
        return this.terminals[n - 1].iidmVoltageLevelId;
    }

    protected VoltageLevel voltageLevel() {
        if (this.terminals[0].iidmVoltageLevelId != null) {
            VoltageLevel vl = this.context.network().getVoltageLevel(this.terminals[0].iidmVoltageLevelId);
            if (vl != null) {
                return vl;
            }
            throw new CgmesModelException(this.type + " " + this.id + " voltage level " + this.terminals[0].iidmVoltageLevelId + " has not been created in IIDM");
        }
        if (this.terminals[0].voltageLevel != null) {
            return this.terminals[0].voltageLevel;
        }
        throw new CgmesModelException(this.type + " " + this.id + " has no container");
    }

    Optional<VoltageLevel> voltageLevel(int n) {
        if (this.terminals[n - 1].iidmVoltageLevelId != null) {
            return Optional.ofNullable(this.context.network().getVoltageLevel(this.terminals[n - 1].iidmVoltageLevelId));
        }
        if (this.terminals[n - 1].voltageLevel != null) {
            return Optional.of(this.terminals[n - 1].voltageLevel);
        }
        return Optional.empty();
    }

    protected Optional<Substation> substation() {
        return this.terminals[0].voltageLevel != null ? this.terminals[0].voltageLevel.getSubstation() : Optional.empty();
    }

    private PowerFlow stateVariablesPowerFlow() {
        return this.terminals[0].t.flow();
    }

    public PowerFlow stateVariablesPowerFlow(int n) {
        return this.terminals[n - 1].t.flow();
    }

    private PowerFlow steadyStateHypothesisPowerFlow() {
        return this.steadyStatePowerFlow;
    }

    PowerFlow powerFlow() {
        if (this.steadyStateHypothesisPowerFlow().defined()) {
            return this.steadyStateHypothesisPowerFlow();
        }
        if (this.stateVariablesPowerFlow().defined()) {
            return this.stateVariablesPowerFlow();
        }
        return PowerFlow.UNDEFINED;
    }

    PowerFlow powerFlowSV() {
        if (this.stateVariablesPowerFlow().defined()) {
            return this.stateVariablesPowerFlow();
        }
        return PowerFlow.UNDEFINED;
    }

    PowerFlow powerFlowSV(int n) {
        if (this.stateVariablesPowerFlow(n).defined()) {
            return this.stateVariablesPowerFlow(n);
        }
        return PowerFlow.UNDEFINED;
    }

    protected void convertedTerminals(Terminal ... ts) {
        if (ts.length != this.numTerminals) {
            throw new IllegalStateException();
        }
        for (int k = 0; k < ts.length; ++k) {
            int n = k + 1;
            Terminal t = ts[k];
            this.context.convertedTerminal(this.terminalId(n), t, n, this.powerFlowSV(n));
        }
    }

    public void connect(InjectionAdder<?, ?> adder) {
        if (this.context.nodeBreaker()) {
            adder.setNode(this.iidmNode());
        } else {
            adder.setBus(this.terminalConnected() ? this.busId() : null).setConnectableBus(this.busId());
        }
    }

    public void connect(InjectionAdder<?, ?> adder, int terminal) {
        if (this.context.nodeBreaker()) {
            adder.setNode(this.iidmNode(terminal));
        } else {
            adder.setBus(this.terminalConnected(terminal) ? this.busId(terminal) : null).setConnectableBus(this.busId(terminal));
        }
    }

    public void connect(BranchAdder<?, ?> adder) {
        if (this.context.nodeBreaker()) {
            adder.setVoltageLevel1(this.iidmVoltageLevelId(1)).setVoltageLevel2(this.iidmVoltageLevelId(2)).setNode1(this.iidmNode(1)).setNode2(this.iidmNode(2));
        } else {
            String busId1 = this.busId(1);
            String busId2 = this.busId(2);
            adder.setVoltageLevel1(this.iidmVoltageLevelId(1)).setVoltageLevel2(this.iidmVoltageLevelId(2)).setBus1(this.terminalConnected(1) ? busId1 : null).setBus2(this.terminalConnected(2) ? busId2 : null).setConnectableBus1(busId1).setConnectableBus2(busId2);
        }
    }

    public static void connect(Context context, InjectionAdder<?, ?> adder, String busId, boolean connected, int node) {
        if (context.nodeBreaker()) {
            adder.setNode(node);
        } else {
            adder.setBus(connected ? busId : null).setConnectableBus(busId);
        }
    }

    public void connect(BranchAdder<?, ?> adder, String iidmVoltageLevelId1, String busId1, boolean t1Connected, int node1, String iidmVoltageLevelId2, String busId2, boolean t2Connected, int node2) {
        AbstractConductingEquipmentConversion.connect(this.context, adder, iidmVoltageLevelId1, busId1, t1Connected, node1, iidmVoltageLevelId2, busId2, t2Connected, node2);
    }

    public static void connect(Context context, BranchAdder<?, ?> adder, String iidmVoltageLevelId1, String busId1, boolean t1Connected, int node1, String iidmVoltageLevelId2, String busId2, boolean t2Connected, int node2) {
        if (context.nodeBreaker()) {
            adder.setVoltageLevel1(iidmVoltageLevelId1).setVoltageLevel2(iidmVoltageLevelId2).setNode1(node1).setNode2(node2);
        } else {
            adder.setVoltageLevel1(iidmVoltageLevelId1).setVoltageLevel2(iidmVoltageLevelId2).setBus1(t1Connected ? busId1 : null).setBus2(t2Connected ? busId2 : null).setConnectableBus1(busId1).setConnectableBus2(busId2);
        }
    }

    public void connect(BranchAdder<?, ?> adder, boolean t1Connected, boolean t2Connected) {
        this.connect(adder, t1Connected, t2Connected, true);
    }

    public void connect(BranchAdder<?, ?> adder, boolean t1Connected, boolean t2Connected, boolean branchIsClosed) {
        if (this.context.nodeBreaker()) {
            adder.setVoltageLevel1(this.iidmVoltageLevelId(1)).setVoltageLevel2(this.iidmVoltageLevelId(2)).setNode1(this.iidmNode(1, branchIsClosed)).setNode2(this.iidmNode(2, branchIsClosed));
        } else {
            String busId1 = this.busId(1);
            String busId2 = this.busId(2);
            adder.setVoltageLevel1(this.iidmVoltageLevelId(1)).setVoltageLevel2(this.iidmVoltageLevelId(2)).setBus1(t1Connected && branchIsClosed ? busId1 : null).setBus2(t2Connected && branchIsClosed ? busId2 : null).setConnectableBus1(busId1).setConnectableBus2(busId2);
        }
    }

    public void connect(VoltageLevel.NodeBreakerView.SwitchAdder adder, boolean open) {
        if (!this.context.nodeBreaker()) {
            throw new ConversionException("Not in node breaker context");
        }
        adder.setNode1(this.iidmNode(1)).setNode2(this.iidmNode(2)).setOpen(open);
    }

    public void connect(VoltageLevel.BusBreakerView.SwitchAdder adder, boolean open) {
        adder.setBus1(this.busId(1)).setBus2(this.busId(2)).setOpen(open || !this.terminalConnected(1) || !this.terminalConnected(2));
    }

    public void connect(ThreeWindingsTransformerAdder.LegAdder adder, int terminal) {
        if (this.context.nodeBreaker()) {
            adder.setVoltageLevel(this.iidmVoltageLevelId(terminal)).setNode(this.iidmNode(terminal));
        } else {
            adder.setVoltageLevel(this.iidmVoltageLevelId(terminal)).setBus(this.terminalConnected(terminal) ? this.busId(terminal) : null).setConnectableBus(this.busId(terminal));
        }
    }

    protected void addAliasesAndProperties(Identifiable<?> identifiable) {
        int i = 1;
        for (TerminalData td : this.terminals) {
            if (td == null) break;
            identifiable.addAlias(td.t.id(), "CGMES.Terminal" + i, this.context.config().isEnsureIdAliasUnicity());
            ++i;
        }
    }

    protected double p0() {
        return this.powerFlow().defined() ? this.powerFlow().p() : 0.0;
    }

    protected double q0() {
        return this.powerFlow().defined() ? this.powerFlow().q() : 0.0;
    }

    static class TerminalData {
        private final CgmesTerminal t;
        private final String busId;
        private final String cgmesVoltageLevelId;
        private final String iidmVoltageLevelId;
        private final VoltageLevel voltageLevel;

        TerminalData(String terminalPropertyName, PropertyBag p, Context context) {
            this.t = context.cgmes().terminal(p.getId(terminalPropertyName));
            String nodeId = context.nodeBreaker() ? this.t.connectivityNode() : this.t.topologicalNode();
            this.busId = context.namingStrategy().getIidmId("Bus", nodeId);
            this.cgmesVoltageLevelId = context.config().convertBoundary() && context.boundary().containsNode(nodeId) ? Context.boundaryVoltageLevelId(nodeId) : TerminalData.findCgmesVoltageLevelIdForContainer(nodeId, context);
            if (this.cgmesVoltageLevelId != null) {
                String iidmVl = context.namingStrategy().getIidmId("VoltageLevel", this.cgmesVoltageLevelId);
                this.iidmVoltageLevelId = context.nodeContainerMapping().voltageLevelIidm(iidmVl);
                this.voltageLevel = context.network().getVoltageLevel(this.iidmVoltageLevelId);
            } else {
                this.iidmVoltageLevelId = null;
                this.voltageLevel = null;
            }
        }

        private static String findCgmesVoltageLevelIdForContainer(String nodeId, Context context) {
            String cgmesVoltageLevelId = null;
            Optional cgmesContainer = context.cgmes().nodeContainer(nodeId);
            if (cgmesContainer.isPresent() && (cgmesVoltageLevelId = ((CgmesContainer)cgmesContainer.get()).voltageLevel()) == null) {
                cgmesVoltageLevelId = context.nodeContainerMapping().getFictitiousVoltageLevelForContainer(((CgmesContainer)cgmesContainer.get()).id(), nodeId);
            }
            return cgmesVoltageLevelId;
        }
    }
}

