/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class AbstractObjectConversion {
    protected final String type;
    protected final PropertyBag p;
    protected final PropertyBags ps;
    protected final Context context;

    protected AbstractObjectConversion(String type, PropertyBag properties, Context context) {
        this.type = Objects.requireNonNull(type);
        this.p = Objects.requireNonNull(properties);
        this.ps = null;
        this.context = Objects.requireNonNull(context);
    }

    protected AbstractObjectConversion(String type, PropertyBags properties, Context context) {
        this.type = Objects.requireNonNull(type);
        this.p = null;
        this.ps = Objects.requireNonNull(properties);
        this.context = Objects.requireNonNull(context);
    }

    public boolean insideBoundary() {
        return false;
    }

    public void convertInsideBoundary() {
        throw new ConversionException("No implementation at this level");
    }

    public abstract boolean valid();

    public abstract void convert();

    public abstract String what();

    protected abstract String complete(String var1);

    public static int fromContinuous(double value) {
        return (int)Math.round(value);
    }

    public void invalid(String reason) {
        this.context.invalid(this.what(), reason);
    }

    public void ignored(String reason) {
        this.context.ignored(this.what(), reason);
    }

    public void ignored(Supplier<String> reason) {
        this.context.ignored(this.what(), reason);
    }

    public void ignored(String what, Supplier<String> reason) {
        this.context.ignored(this.complete(what), reason);
    }

    public void fixed(String what, String reason) {
        this.context.fixed(this.complete(what), reason);
    }

    public void fixed(String what, Supplier<String> reason) {
        this.context.fixed(this.complete(what), reason);
    }

    public void fixed(String what, String reason, double wrong, double fixed) {
        this.context.fixed(this.complete(what), reason, wrong, fixed);
    }

    public void missing(String what) {
        this.context.missing(this.complete(what));
    }

    public void missing(String what, double defaultValue) {
        this.context.missing(this.complete(what), defaultValue);
    }
}

