/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.extensions.LoadDetailAdder;
import com.powsybl.triplestore.api.PropertyBag;

public class EnergyConsumerConversion
extends AbstractConductingEquipmentConversion {
    private final String loadKind;

    public EnergyConsumerConversion(PropertyBag ec, Context context) {
        super("EnergyConsumer", ec, context);
        this.loadKind = ec.getLocal("type");
    }

    @Override
    public void convert() {
        LoadType loadType = this.loadKind.equals("StationSupply") ? LoadType.AUXILIARY : (this.id.contains("fict") ? LoadType.FICTITIOUS : LoadType.UNDEFINED);
        LoadAdder adder = this.voltageLevel().newLoad().setP0(this.p0()).setQ0(this.q0()).setLoadType(loadType);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect((InjectionAdder<?, ?>)adder);
        this.model(adder);
        Load load = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)load);
        this.convertedTerminals(load.getTerminal());
        EnergyConsumerConversion.setLoadDetail(this.loadKind, load);
        EnergyConsumerConversion.addSpecificProperties(load, this.loadKind);
    }

    private static void addSpecificProperties(Load load, String loadKind) {
        load.setProperty("CGMES.originalClass", loadKind);
    }

    private void model(LoadAdder adder) {
        this.p.asBoolean("exponentModel").ifPresent(exponentModel -> {
            if (Boolean.TRUE.equals(exponentModel)) {
                boolean constantPower;
                double pVoltageExponent = this.p.asDouble("pVoltageExponent", 0.0);
                double qVoltageExponent = this.p.asDouble("qVoltageExponent", 0.0);
                boolean bl = constantPower = pVoltageExponent == 0.0 && qVoltageExponent == 0.0;
                if (!constantPower) {
                    adder.newExponentialModel().setNp(pVoltageExponent).setNq(qVoltageExponent).add();
                }
            } else {
                this.addZipModel(adder);
            }
        });
    }

    private void addZipModel(LoadAdder adder) {
        double pConstantPower = this.p.asDouble("pConstantPower");
        double pConstantCurrent = this.p.asDouble("pConstantCurrent");
        double pConstantImpedance = this.p.asDouble("pConstantImpedance");
        double qConstantPower = this.p.asDouble("qConstantPower");
        double qConstantCurrent = this.p.asDouble("qConstantCurrent");
        double qConstantImpedance = this.p.asDouble("qConstantImpedance");
        if (!(Double.isNaN(pConstantPower) || Double.isNaN(pConstantCurrent) || Double.isNaN(pConstantImpedance) || Double.isNaN(qConstantPower) || Double.isNaN(qConstantCurrent) || Double.isNaN(qConstantImpedance))) {
            boolean constantPower;
            boolean bl = constantPower = pConstantPower == 1.0 && pConstantCurrent == 0.0 && pConstantImpedance == 0.0 && qConstantPower == 1.0 && qConstantCurrent == 0.0 && qConstantImpedance == 0.0;
            if (!constantPower) {
                double qSum;
                double pSum = pConstantPower + pConstantCurrent + pConstantImpedance;
                if (Math.abs(pSum - 1.0) > 1.0E-8) {
                    pConstantPower /= pSum;
                    pConstantCurrent /= pSum;
                    pConstantImpedance /= pSum;
                    this.fixed("active coefficients of zip load", "sum of pConstantPower, pConstantCurrent and pConstantImpedance is not equals to 1");
                }
                if (Math.abs((qSum = qConstantPower + qConstantCurrent + qConstantImpedance) - 1.0) > 1.0E-8) {
                    qConstantPower /= qSum;
                    qConstantCurrent /= qSum;
                    qConstantImpedance /= qSum;
                    this.fixed("reactive coefficients of zip load", "sum of qConstantPower, qConstantCurrent and qConstantImpedance is not equals to 1");
                }
                adder.newZipModel().setC0p(pConstantPower).setC1p(pConstantCurrent).setC2p(pConstantImpedance).setC0q(qConstantPower).setC1q(qConstantCurrent).setC2q(qConstantImpedance).add();
            }
        }
    }

    private static void setLoadDetail(String type, Load load) {
        if (type.equals("ConformLoad")) {
            ((LoadDetailAdder)load.newExtension(LoadDetailAdder.class)).withFixedActivePower(0.0).withFixedReactivePower(0.0).withVariableActivePower((double)((float)load.getP0())).withVariableReactivePower((double)((float)load.getQ0())).add();
        } else if (type.equals("NonConformLoad")) {
            ((LoadDetailAdder)load.newExtension(LoadDetailAdder.class)).withFixedActivePower((double)((float)load.getP0())).withFixedReactivePower((double)((float)load.getQ0())).withVariableActivePower(0.0).withVariableReactivePower(0.0).add();
        }
    }

    @Override
    protected double p0() {
        return this.powerFlow().defined() ? this.powerFlow().p() : this.p.asDouble("pFixed", 0.0);
    }

    @Override
    protected double q0() {
        return this.powerFlow().defined() ? this.powerFlow().q() : this.p.asDouble("qFixed", 0.0);
    }
}

