/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractReactiveLimitsOwnerConversion;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.triplestore.api.PropertyBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquivalentInjectionConversion
extends AbstractReactiveLimitsOwnerConversion {
    private static final String REGULATION_TARGET = "regulationTarget";
    private static final Logger LOG = LoggerFactory.getLogger(EquivalentInjectionConversion.class);

    public EquivalentInjectionConversion(PropertyBag ei, Context context) {
        super("EquivalentInjection", ei, context);
    }

    @Override
    public void convertInsideBoundary() {
        if (this.context.config().convertBoundary()) {
            if (this.valid()) {
                this.convert();
            }
        } else {
            this.context.boundary().addEquivalentInjectionAtNode(this.p, this.nodeId());
        }
    }

    @Override
    public void convert() {
        this.convertToGenerator();
    }

    public DanglingLine convertOverDanglingLine(DanglingLineAdder adder, PowerFlow fother) {
        Regulation regulation = this.getRegulation();
        DanglingLine dl = regulation.status ? adder.setP0(fother.p()).setQ0(fother.q()).newGeneration().setVoltageRegulationOn(true).setMinP(-1.7976931348623157E308).setMaxP(Double.MAX_VALUE).setTargetP(regulation.targetP).setTargetQ(regulation.targetQ).setTargetV(regulation.targetV).add().add() : adder.setP0(fother.p() + this.p0()).setQ0(fother.q() + this.q0()).add();
        dl.setProperty("CGMES.EquivalentInjection", this.id);
        CgmesTerminal cgmesTerminal = this.context.cgmes().terminal(this.terminalId());
        if (cgmesTerminal != null) {
            dl.setProperty("CGMES.EquivalentInjectionTerminal", cgmesTerminal.id());
        }
        return dl;
    }

    private void convertToGenerator() {
        double minP = this.p.asDouble("minP", -1.7976931348623157E308);
        double maxP = this.p.asDouble("maxP", Double.MAX_VALUE);
        EnergySource energySource = EnergySource.OTHER;
        Regulation regulation = this.getRegulation();
        GeneratorAdder adder = this.voltageLevel().newGenerator();
        this.setMinPMaxP(adder, minP, maxP);
        adder.setVoltageRegulatorOn(regulation.status).setTargetP(regulation.targetP).setTargetQ(regulation.targetQ).setTargetV(regulation.targetV).setEnergySource(energySource);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect((InjectionAdder<?, ?>)adder);
        Generator g = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)g);
        this.convertedTerminals(g.getTerminal());
        this.convertReactiveLimits((ReactiveLimitsHolder)g);
        EquivalentInjectionConversion.addSpecificProperties(g);
    }

    private static void addSpecificProperties(Generator generator) {
        generator.setProperty("CGMES.originalClass", "EquivalentInjection");
    }

    private Regulation getRegulation() {
        Regulation regulation = new Regulation();
        boolean regulationCapability = this.p.asBoolean("regulationCapability", false);
        boolean bl = regulation.status = this.p.asBoolean("regulationStatus", false) && regulationCapability;
        if (!this.p.containsKey((Object)"regulationStatus") || !this.p.containsKey((Object)REGULATION_TARGET)) {
            LOG.trace("Attributes regulationStatus or regulationTarget not present for equivalent injection {}. Voltage regulation is considered as off.", (Object)this.id);
        }
        regulation.status = regulation.status && this.terminalConnected();
        regulation.targetV = Double.NaN;
        if (regulation.status) {
            regulation.targetV = this.p.asDouble(REGULATION_TARGET);
            if (Double.isNaN(regulation.targetV) || regulation.targetV == 0.0) {
                this.missing("Valid target voltage value (voltage regulation is considered as off)");
                regulation.status = false;
            }
        }
        PowerFlow f = this.powerFlow();
        regulation.targetP = 0.0;
        regulation.targetQ = 0.0;
        if (f.defined()) {
            regulation.targetP = -f.p();
            regulation.targetQ = -f.q();
        }
        return regulation;
    }

    static class Regulation {
        private boolean status;
        private double targetV;
        private double targetP;
        private double targetQ;

        Regulation() {
        }
    }
}

