/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForStaticVarCompensators;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.extensions.VoltagePerReactivePowerControlAdder;
import com.powsybl.triplestore.api.PropertyBag;

public class StaticVarCompensatorConversion
extends AbstractConductingEquipmentConversion {
    public StaticVarCompensatorConversion(PropertyBag svc, Context context) {
        super("StaticVarCompensator", svc, context);
    }

    @Override
    public void convert() {
        double slope = this.checkSlope(this.p.asDouble("slope"));
        double capacitiveRating = this.p.asDouble("capacitiveRating", 0.0);
        double inductiveRating = this.p.asDouble("inductiveRating", 0.0);
        StaticVarCompensatorAdder adder = this.voltageLevel().newStaticVarCompensator().setBmin(this.getB(inductiveRating, "inductive")).setBmax(this.getB(capacitiveRating, "capacitive"));
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect((InjectionAdder<?, ?>)adder);
        RegulatingControlMappingForStaticVarCompensators.initialize(adder);
        StaticVarCompensator svc = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)svc);
        this.convertedTerminals(svc.getTerminal());
        if (slope >= 0.0) {
            ((VoltagePerReactivePowerControlAdder)svc.newExtension(VoltagePerReactivePowerControlAdder.class)).withSlope(slope).add();
        }
        this.context.regulatingControlMapping().forStaticVarCompensators().add(svc.getId(), this.p);
    }

    private double getB(double rating, String name) {
        if (rating == 0.0) {
            this.fixed(name + "Rating", "Undefined or equal to 0. Corresponding susceptance is Double.MAX_VALUE");
            return name.equals("inductive") ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        return 1.0 / rating;
    }

    private double checkSlope(double slope) {
        if (Double.isNaN(slope)) {
            this.missing("slope");
        }
        if (slope < 0.0) {
            this.ignored("Slope must be positive");
        }
        return slope;
    }
}

