/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBag;

public class SvInjectionConversion
extends AbstractIdentifiedObjectConversion {
    private VoltageLevel voltageLevel;
    private int node = -1;
    private String busId;
    private CgmesTerminal cgmesTerminal;

    public SvInjectionConversion(PropertyBag p, Context context) {
        super("SvInjection", p, context);
        String tn = p.getId("TopologicalNode");
        if (!this.findVoltageLevel(tn)) {
            return;
        }
        if (context.nodeBreaker()) {
            this.findNode(tn);
        } else {
            this.findBusId(tn);
        }
    }

    @Override
    public boolean valid() {
        return this.voltageLevel != null && (this.context.nodeBreaker() && this.node != -1 || !this.context.nodeBreaker() && this.voltageLevel.getBusBreakerView().getBus(this.busId) != null);
    }

    @Override
    public void convert() {
        double p0 = this.p.asDouble("pInjection");
        double q0 = this.p.asDouble("qInjection", 0.0);
        LoadAdder adder = ((LoadAdder)this.voltageLevel.newLoad().setP0(p0).setQ0(q0).setFictitious(true)).setLoadType(LoadType.FICTITIOUS);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect(adder);
        Load load = adder.add();
        if (this.cgmesTerminal != null) {
            PowerFlow f = this.cgmesTerminal.flow();
            if (!f.defined()) {
                f = new PowerFlow(p0, q0);
            }
            this.context.convertedTerminal(this.cgmesTerminal.id(), load.getTerminal(), 1, f);
        } else {
            load.getTerminal().setP(p0);
            load.getTerminal().setQ(q0);
        }
        SvInjectionConversion.addSpecificProperties(load);
    }

    private static void addSpecificProperties(Load load) {
        load.setProperty("CGMES.originalClass", "SvInjection");
    }

    private void connect(LoadAdder adder) {
        if (this.context.nodeBreaker()) {
            adder.setNode(this.node);
        } else {
            ((LoadAdder)adder.setConnectableBus(this.busId)).setBus(this.busId);
        }
    }

    private boolean findVoltageLevel(String topologicalNode) {
        Terminal associatedTerminal = this.context.terminalMapping().findFromTopologicalNode(topologicalNode);
        if (associatedTerminal == null) {
            this.cgmesTerminal = this.context.cgmes().terminal(this.context.terminalMapping().findCgmesTerminalFromTopologicalNode(topologicalNode));
            if (this.cgmesTerminal == null || this.context.cgmes().voltageLevel(this.cgmesTerminal, this.context.nodeBreaker()) == null) {
                this.context.missing(this.id, () -> String.format("The CGMES terminal and/or the voltage level associated to the topological node %s linked to the SV injection %s is missing", topologicalNode, this.id));
                return false;
            }
            this.voltageLevel = this.context.network().getVoltageLevel(this.context.cgmes().voltageLevel(this.cgmesTerminal, this.context.nodeBreaker()));
        } else {
            this.voltageLevel = associatedTerminal.getVoltageLevel();
        }
        return true;
    }

    private void findBusId(String topologicalNode) {
        this.busId = this.context.namingStrategy().getIidmId("Bus", topologicalNode);
    }

    private void findNode(String topologicalNode) {
        Terminal associatedTerminal = this.context.terminalMapping().findFromTopologicalNode(topologicalNode);
        if (associatedTerminal == null) {
            this.findNodeFromUnmappedCgmesTerminal();
        } else {
            this.findNodeFromMappedCgmesTerminal(associatedTerminal, topologicalNode);
        }
    }

    private void findNodeFromUnmappedCgmesTerminal() {
        this.node = this.context.nodeMapping().iidmNodeForTerminal(this.cgmesTerminal, false, this.voltageLevel);
    }

    private void findNodeFromMappedCgmesTerminal(Terminal associatedTerminal, String topologicalNode) {
        this.node = this.context.nodeMapping().iidmNodeForTopologicalNode(topologicalNode, associatedTerminal.getNodeBreakerView().getNode(), associatedTerminal.getVoltageLevel());
    }
}

