/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForVscConverters;
import com.powsybl.cgmes.conversion.elements.AbstractReactiveLimitsOwnerConversion;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Objects;

public class AcDcConverterConversion
extends AbstractReactiveLimitsOwnerConversion {
    private static final double DEFAULT_POWER_FACTOR = 0.8;
    private final HvdcConverterStation.HvdcType converterType;
    private final double lossFactor;
    private final String acDcConverterDcTerminalId;
    private LccConverterStation lccConverter = null;

    public AcDcConverterConversion(PropertyBag c, HvdcConverterStation.HvdcType converterType, double lossFactor, String acDcConverterDcTerminalId, Context context) {
        super("ACDCConverter", c, context);
        this.converterType = Objects.requireNonNull(converterType);
        this.lossFactor = lossFactor;
        this.acDcConverterDcTerminalId = Objects.requireNonNull(acDcConverterDcTerminalId);
    }

    @Override
    public boolean valid() {
        if (!super.valid()) {
            return false;
        }
        if (this.converterType == null) {
            this.invalid("Type " + this.p.getLocal("type"));
            return false;
        }
        return true;
    }

    @Override
    public void convert() {
        Objects.requireNonNull(this.converterType);
        if (this.converterType.equals((Object)HvdcConverterStation.HvdcType.VSC)) {
            VscConverterStationAdder adder = (VscConverterStationAdder)this.voltageLevel().newVscConverterStation().setLossFactor((float)this.lossFactor);
            this.identify((IdentifiableAdder<?, ?>)adder);
            this.connect((InjectionAdder<?, ?>)adder);
            RegulatingControlMappingForVscConverters.initialize(adder);
            VscConverterStation c = adder.add();
            this.addAliasesAndProperties((Identifiable<?>)c);
            this.convertedTerminals(c.getTerminal());
            this.convertReactiveLimits((ReactiveLimitsHolder)c);
            this.context.regulatingControlMapping().forVscConverters().add(c.getId(), this.p);
        } else if (this.converterType.equals((Object)HvdcConverterStation.HvdcType.LCC)) {
            LccConverterStationAdder adder = ((LccConverterStationAdder)this.voltageLevel().newLccConverterStation().setLossFactor((float)this.lossFactor)).setPowerFactor((float)AcDcConverterConversion.getPowerFactor(this.p));
            this.identify((IdentifiableAdder<?, ?>)adder);
            this.connect((InjectionAdder<?, ?>)adder);
            LccConverterStation c = adder.add();
            this.addAliasesAndProperties((Identifiable<?>)c);
            this.lccConverter = c;
            this.convertedTerminals(c.getTerminal());
        }
    }

    @Override
    protected void addAliasesAndProperties(Identifiable<?> identifiable) {
        super.addAliasesAndProperties(identifiable);
        identifiable.addAlias(this.acDcConverterDcTerminalId, "CGMES.ACDCConverterDCTerminal");
    }

    private static double getPowerFactor(PropertyBag propertyBag) {
        double q;
        double p = propertyBag.asDouble("p");
        double powerFactor = p / Math.hypot(p, q = propertyBag.asDouble("q"));
        if (Double.isNaN(powerFactor)) {
            return 0.8;
        }
        return powerFactor;
    }

    public void setLccPowerFactor(double powerFactor) {
        this.lccConverter.setPowerFactor((float)powerFactor);
    }

    LccConverterStation getLccConverter() {
        return this.lccConverter;
    }
}

