/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.elements.hvdc.CgmesDcConversion;
import com.powsybl.cgmes.model.CgmesDcTerminal;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class AcDcConverterNodes {
    private final Map<String, AcDcConverterNode> converterNodes = new HashMap<String, AcDcConverterNode>();

    AcDcConverterNodes(CgmesModel cgmesModel) {
        cgmesModel.acDcConverters().forEach(c -> this.computeAcDcConverter(cgmesModel, (PropertyBag)c));
        cgmesModel.dcTerminals().forEach(c -> this.computeDcTerminalToAcDcConverter(cgmesModel, (PropertyBag)c));
    }

    private void computeAcDcConverter(CgmesModel cgmesModel, PropertyBag c) {
        String id = c.getId("ACDCConverter");
        CgmesTerminal t = cgmesModel.terminal(c.getId("Terminal"));
        String acNode = CgmesDcConversion.getAcNode(cgmesModel, t);
        this.converterNodes.computeIfAbsent(id, k -> new AcDcConverterNode(id, acNode));
    }

    private void computeDcTerminalToAcDcConverter(CgmesModel cgmesModel, PropertyBag t) {
        AcDcConverterNode acDcConverter;
        CgmesDcTerminal dcTerminal = new CgmesDcTerminal(t);
        if ((dcTerminal.dcConductingEquipmentType().equals("CsConverter") || dcTerminal.dcConductingEquipmentType().equals("VsConverter")) && (acDcConverter = this.converterNodes.get(dcTerminal.dcConductingEquipment())) != null) {
            acDcConverter.addDcNode(CgmesDcConversion.getDcNode(cgmesModel, dcTerminal));
        }
    }

    Map<String, AcDcConverterNode> getConverterNodes() {
        return this.converterNodes;
    }

    List<String> getDcNodes(String acDcConverterId) {
        return Optional.ofNullable(this.converterNodes.get((Object)acDcConverterId).dcNode).orElse(Collections.emptyList());
    }

    static class AcDcConverterNode {
        final String id;
        final String acNode;
        final List<String> dcNode;

        AcDcConverterNode(String id, String acNode) {
            Objects.requireNonNull(id);
            Objects.requireNonNull(acNode);
            this.id = id;
            this.acNode = acNode;
            this.dcNode = new ArrayList<String>();
        }

        void addDcNode(String dcNode) {
            this.dcNode.add(dcNode);
        }
    }
}

