/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.elements.hvdc.AcDcConverterNodes;
import com.powsybl.cgmes.conversion.elements.hvdc.CgmesDcConversion;
import com.powsybl.cgmes.model.CgmesDcTerminal;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.commons.PowsyblException;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class Adjacency {
    private final Map<String, List<Adjacent>> adjacency = new HashMap<String, List<Adjacent>>();

    Adjacency(CgmesModel cgmesModel, AcDcConverterNodes acDcConverterNodes) {
        cgmesModel.dcLineSegments().forEach(dcls -> this.computeDcLineSegmentAdjacency(cgmesModel, (PropertyBag)dcls));
        acDcConverterNodes.getConverterNodes().forEach((key, value) -> this.computeAcDcConverterAdjacency(value.acNode, value.dcNode));
        cgmesModel.groupedTransformerEnds().forEach((t, ends) -> {
            if (ends.size() == 2) {
                this.computeTwoWindingsTransformerAdjacency(cgmesModel, (PropertyBags)ends);
            } else if (ends.size() == 3) {
                this.computeThreeWindingsTransformerAdjacency(cgmesModel, (PropertyBags)ends);
            } else {
                throw new PowsyblException(String.format("Unexpected TransformerEnds: ends %d", ends.size()));
            }
        });
    }

    private void computeDcLineSegmentAdjacency(CgmesModel cgmesModel, PropertyBag equipment) {
        CgmesDcTerminal t1 = cgmesModel.dcTerminal(equipment.getId("DCTerminal1"));
        CgmesDcTerminal t2 = cgmesModel.dcTerminal(equipment.getId("DCTerminal2"));
        this.addAdjacency(CgmesDcConversion.getDcNode(cgmesModel, t1), CgmesDcConversion.getDcNode(cgmesModel, t2), AdjacentType.DC_LINE_SEGMENT);
    }

    private void computeAcDcConverterAdjacency(String acNode, List<String> dcNodes) {
        dcNodes.forEach(dcNode -> this.addAdjacency(acNode, (String)dcNode, AdjacentType.AC_DC_CONVERTER));
        for (int k = 0; k < dcNodes.size() - 1; ++k) {
            String dcNode2 = dcNodes.get(k);
            for (int l = k + 1; l < dcNodes.size(); ++l) {
                this.addAdjacency(dcNode2, dcNodes.get(l), AdjacentType.AC_DC_CONVERTER);
            }
        }
    }

    private void computeTwoWindingsTransformerAdjacency(CgmesModel cgmesModel, PropertyBags ends) {
        PropertyBag end1 = (PropertyBag)ends.get(0);
        CgmesTerminal t1 = cgmesModel.terminal(end1.getId("Terminal"));
        PropertyBag end2 = (PropertyBag)ends.get(1);
        CgmesTerminal t2 = cgmesModel.terminal(end2.getId("Terminal"));
        this.addTransformerAdjacency(Arrays.asList(CgmesDcConversion.getAcNode(cgmesModel, t1), CgmesDcConversion.getAcNode(cgmesModel, t2)));
    }

    private void computeThreeWindingsTransformerAdjacency(CgmesModel cgmesModel, PropertyBags ends) {
        PropertyBag end1 = (PropertyBag)ends.get(0);
        CgmesTerminal t1 = cgmesModel.terminal(end1.getId("Terminal"));
        PropertyBag end2 = (PropertyBag)ends.get(1);
        CgmesTerminal t2 = cgmesModel.terminal(end2.getId("Terminal"));
        PropertyBag end3 = (PropertyBag)ends.get(2);
        CgmesTerminal t3 = cgmesModel.terminal(end3.getId("Terminal"));
        this.addTransformerAdjacency(Arrays.asList(CgmesDcConversion.getAcNode(cgmesModel, t1), CgmesDcConversion.getAcNode(cgmesModel, t2), CgmesDcConversion.getAcNode(cgmesModel, t3)));
    }

    private void addTransformerAdjacency(List<String> nodes) {
        if (nodes.stream().anyMatch(this::containsAcDcConverter)) {
            for (int k = 0; k < nodes.size() - 1; ++k) {
                String node = nodes.get(k);
                for (int l = k + 1; l < nodes.size(); ++l) {
                    this.addAdjacency(node, nodes.get(l), AdjacentType.AC_TRANSFORMER);
                }
            }
        }
    }

    private void addAdjacency(String nodeId1, String nodeId2, AdjacentType type) {
        Adjacent ad1 = new Adjacent(type, nodeId1);
        Adjacent ad2 = new Adjacent(type, nodeId2);
        this.adjacency.computeIfAbsent(nodeId1, k -> new ArrayList()).add(ad2);
        this.adjacency.computeIfAbsent(nodeId2, k -> new ArrayList()).add(ad1);
    }

    boolean containsAcDcConverter(String nodeId) {
        if (this.adjacency.containsKey(nodeId)) {
            return this.adjacency.get(nodeId).stream().anyMatch(ad -> Adjacency.isAcDcConverter(ad.type));
        }
        return false;
    }

    static boolean isDcLineSegment(AdjacentType type) {
        return type == AdjacentType.DC_LINE_SEGMENT;
    }

    static boolean isAcDcConverter(AdjacentType type) {
        return type == AdjacentType.AC_DC_CONVERTER;
    }

    Map<String, List<Adjacent>> get() {
        return this.adjacency;
    }

    boolean isEmpty() {
        return this.adjacency.isEmpty();
    }

    boolean areAdjacentsByAcDcConverter(String node1, String node2) {
        if (this.adjacency.containsKey(node1)) {
            return this.adjacency.get(node1).stream().anyMatch(ad -> ad.type == AdjacentType.AC_DC_CONVERTER && ad.node.equals(node2));
        }
        return false;
    }

    static enum AdjacentType {
        DC_LINE_SEGMENT,
        AC_DC_CONVERTER,
        AC_TRANSFORMER;

    }

    static class Adjacent {
        AdjacentType type;
        String node;

        Adjacent(AdjacentType type, String node) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(node);
            this.type = type;
            this.node = node;
        }
    }
}

