/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.hvdc.AcDcConverterConversion;
import com.powsybl.cgmes.conversion.elements.hvdc.AcDcConverterNodes;
import com.powsybl.cgmes.conversion.elements.hvdc.Adjacency;
import com.powsybl.cgmes.conversion.elements.hvdc.DcLineSegmentConversion;
import com.powsybl.cgmes.conversion.elements.hvdc.Hvdc;
import com.powsybl.cgmes.conversion.elements.hvdc.IslandEndHvdc;
import com.powsybl.cgmes.conversion.elements.hvdc.Islands;
import com.powsybl.cgmes.conversion.elements.hvdc.IslandsEnds;
import com.powsybl.cgmes.conversion.elements.hvdc.LossFactor;
import com.powsybl.cgmes.conversion.elements.hvdc.NodeEquipment;
import com.powsybl.cgmes.model.CgmesDcTerminal;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgmesDcConversion {
    private static final String TYPE = "type";
    private static final String TARGET_PPCC = "targetPpcc";
    private static final String POLE_LOSS_P = "poleLossP";
    private static final String OPERATING_MODE = "operatingMode";
    private final CgmesModel cgmesModel;
    private final Context context;
    private HvdcConverterStation.HvdcType converterType;
    private HvdcLine.ConvertersMode operatingMode;
    private String converter1Id;
    private PropertyBag cconverter1;
    private String acDcConverterDcTerminal1Id;
    private String converter2Id;
    private PropertyBag cconverter2;
    private String acDcConverterDcTerminal2Id;
    private String dcLineSegmentId;
    private PropertyBag dcLineSegment;
    private double r;
    private double ratedUdc;
    private static final Logger LOG = LoggerFactory.getLogger(CgmesDcConversion.class);

    public CgmesDcConversion(CgmesModel cgmes, Context context) {
        this.cgmesModel = Objects.requireNonNull(cgmes);
        this.context = Objects.requireNonNull(context);
    }

    public void convert() {
        AcDcConverterNodes acDcConverterNodes = new AcDcConverterNodes(this.cgmesModel);
        Adjacency adjacency = new Adjacency(this.cgmesModel, acDcConverterNodes);
        if (adjacency.isEmpty()) {
            return;
        }
        NodeEquipment nodeEquipment = new NodeEquipment(this.cgmesModel, acDcConverterNodes, adjacency);
        Islands islands = new Islands(adjacency);
        IslandsEnds islandsEnds = new IslandsEnds();
        islands.getIslandsNodes().forEach(listNodes -> islandsEnds.add(adjacency, nodeEquipment, (List<String>)listNodes));
        Hvdc hvdc = new Hvdc();
        islandsEnds.getIslandsEndsNodes().forEach(ien -> {
            IslandEndHvdc islandEndHvdc1 = new IslandEndHvdc();
            islandEndHvdc1.add(adjacency, nodeEquipment, ien.getNodes1());
            IslandEndHvdc islandEndHvdc2 = new IslandEndHvdc();
            islandEndHvdc2.add(adjacency, nodeEquipment, ien.getNodes2());
            hvdc.add(nodeEquipment, islandEndHvdc1, islandEndHvdc2);
        });
        hvdc.getHvdcData().forEach(h -> this.convert(acDcConverterNodes, adjacency, h.converters, h.dcLineSegments));
        this.context.dc().reportCgmesConvertersNotUsed();
        this.context.dc().reportCgmesDcLineSegmentNotUsed();
    }

    private void convert(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, List<Hvdc.HvdcConverter> converters, List<String> dcLineSegments) {
        int converterNum = converters.size();
        int dcLineSegmentNum = dcLineSegments.size();
        if (converterNum == 1 && dcLineSegmentNum == 1) {
            this.oneAcDcConverterPairOneDcLineSegment(acDcConverterNodes, adjacency, converters, dcLineSegments);
        } else if (converterNum == 2 && dcLineSegmentNum == 1) {
            this.twoAcDcConverterPairsOneDcLineSegment(acDcConverterNodes, adjacency, converters, dcLineSegments);
        } else if (converterNum == 1 && dcLineSegmentNum == 2) {
            this.oneAcDcConverterPairTwoDcLineSegments(acDcConverterNodes, adjacency, converters, dcLineSegments);
        } else {
            throw new PowsyblException(String.format("Unexpected HVDC configuration: Converters %d DcLineSegments %d", converterNum, dcLineSegmentNum));
        }
    }

    private void oneAcDcConverterPairOneDcLineSegment(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, List<Hvdc.HvdcConverter> converters, List<String> dcLineSegments) {
        this.convert(acDcConverterNodes, adjacency, converters.get((int)0).acDcConvertersEnd1, converters.get((int)0).acDcConvertersEnd2, dcLineSegments.get(0));
    }

    private void twoAcDcConverterPairsOneDcLineSegment(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, List<Hvdc.HvdcConverter> converters, List<String> dcLineSegments) {
        this.convert(acDcConverterNodes, adjacency, converters.get((int)0).acDcConvertersEnd1, converters.get((int)0).acDcConvertersEnd2, dcLineSegments.get(0), false);
        this.convert(acDcConverterNodes, adjacency, converters.get((int)1).acDcConvertersEnd1, converters.get((int)1).acDcConvertersEnd2, dcLineSegments.get(0), true);
    }

    private void oneAcDcConverterPairTwoDcLineSegments(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, List<Hvdc.HvdcConverter> converters, List<String> dcLineSegments) {
        this.convert(acDcConverterNodes, adjacency, converters.get((int)0).acDcConvertersEnd1, converters.get((int)0).acDcConvertersEnd2, dcLineSegments.get(0), dcLineSegments.get(1));
    }

    private void convert(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, String acDcConverterIdEnd1, String acDcConverterIdEnd2, String dcLineSegmentId) {
        if (!this.convertCommonData(acDcConverterNodes, adjacency, acDcConverterIdEnd1, acDcConverterIdEnd2, dcLineSegmentId)) {
            return;
        }
        this.r = this.computeR(this.dcLineSegment);
        if (this.createHvdc()) {
            this.setCommonDataUsed();
        }
    }

    private void convert(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, String acDcConverterIdEnd1, String acDcConverterIdEnd2, String dcLineSegmentId, boolean isDuplicated) {
        if (!this.convertCommonData(acDcConverterNodes, adjacency, acDcConverterIdEnd1, acDcConverterIdEnd2, dcLineSegmentId)) {
            return;
        }
        this.r = 2.0 * this.computeR(this.dcLineSegment);
        if (this.createHvdc(isDuplicated)) {
            this.setCommonDataUsed();
        }
    }

    private void convert(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, String acDcConverterIdEnd1, String acDcConverterIdEnd2, String dcLineSegmentId1, String dcLineSegmentId2) {
        if (!this.convertCommonData(acDcConverterNodes, adjacency, acDcConverterIdEnd1, acDcConverterIdEnd2, dcLineSegmentId1)) {
            return;
        }
        PropertyBag dcLineSegment2 = this.context.dc().getCgmesDcLineSegmentPropertyBag(dcLineSegmentId2);
        if (dcLineSegment2 == null) {
            return;
        }
        this.r = 1.0 / (1.0 / this.computeR(this.dcLineSegment) + 1.0 / this.computeR(dcLineSegment2));
        if (this.createHvdc()) {
            this.setCommonDataUsed();
            HvdcLine line = this.context.network().getHvdcLine(dcLineSegmentId1);
            if (line != null) {
                line.addAlias(dcLineSegmentId2, "CGMES.DCLineSegment2");
            }
            this.context.dc().setCgmesDcLineSegmentUsed(dcLineSegmentId2);
        }
    }

    private void setCommonDataUsed() {
        this.context.dc().setCgmesConverterUsed(this.converter1Id);
        this.context.dc().setCgmesConverterUsed(this.converter2Id);
        this.context.dc().setCgmesDcLineSegmentUsed(this.dcLineSegmentId);
    }

    private boolean convertCommonData(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, String acDcConverterId1, String acDcConverterId2, String dcLineSegmentId) {
        PropertyBag pbDcLineSegment = this.context.dc().getCgmesDcLineSegmentPropertyBag(dcLineSegmentId);
        CgmesDcTerminal t1 = this.cgmesModel.dcTerminal(pbDcLineSegment.getId("DCTerminal1"));
        String dcNode1 = CgmesDcConversion.getDcNode(this.cgmesModel, t1);
        CgmesDcTerminal t2 = this.cgmesModel.dcTerminal(pbDcLineSegment.getId("DCTerminal2"));
        String dcNode2 = CgmesDcConversion.getDcNode(this.cgmesModel, t2);
        String acDcConverterIdEnd1 = CgmesDcConversion.findAcDcConverterConnectedTo(acDcConverterNodes, adjacency, acDcConverterId1, acDcConverterId2, dcNode1);
        String acDcConverterIdEnd2 = acDcConverterIdEnd1.equals(acDcConverterId1) ? acDcConverterId2 : acDcConverterId1;
        String acDcConverterDcNode1 = CgmesDcConversion.findAcDcConverterNode(acDcConverterNodes, adjacency, acDcConverterIdEnd1, dcNode1);
        String acDcConverterDcNode2 = CgmesDcConversion.findAcDcConverterNode(acDcConverterNodes, adjacency, acDcConverterIdEnd2, dcNode2);
        this.converter1Id = acDcConverterIdEnd1;
        this.cconverter1 = this.context.dc().getCgmesConverterPropertyBag(acDcConverterIdEnd1);
        this.acDcConverterDcTerminal1Id = this.findAcDcConverterDcTerminal(acDcConverterIdEnd1, acDcConverterDcNode1);
        this.converter2Id = acDcConverterIdEnd2;
        this.cconverter2 = this.context.dc().getCgmesConverterPropertyBag(acDcConverterIdEnd2);
        this.acDcConverterDcTerminal2Id = this.findAcDcConverterDcTerminal(acDcConverterIdEnd2, acDcConverterDcNode2);
        this.dcLineSegmentId = dcLineSegmentId;
        this.dcLineSegment = pbDcLineSegment;
        if (this.cconverter1 == null || this.cconverter2 == null) {
            return false;
        }
        this.converterType = CgmesDcConversion.decodeType(this.cconverter1.getLocal(TYPE));
        if (this.converterType == null || this.converterType != CgmesDcConversion.decodeType(this.cconverter2.getLocal(TYPE))) {
            return false;
        }
        this.operatingMode = CgmesDcConversion.decodeMode(this.converterType, this.cconverter1, this.cconverter2);
        this.ratedUdc = CgmesDcConversion.computeRatedUdc(this.cconverter1, this.cconverter2);
        return true;
    }

    private static HvdcConverterStation.HvdcType decodeType(String stype) {
        if (stype.equals("VsConverter")) {
            return HvdcConverterStation.HvdcType.VSC;
        }
        if (stype.equals("CsConverter")) {
            return HvdcConverterStation.HvdcType.LCC;
        }
        throw new PowsyblException("Unexpected HVDC type: " + stype);
    }

    private static HvdcLine.ConvertersMode decodeMode(HvdcConverterStation.HvdcType converterType, PropertyBag cconverter1, PropertyBag cconverter2) {
        String mode1 = cconverter1.getLocal(OPERATING_MODE);
        String mode2 = cconverter2.getLocal(OPERATING_MODE);
        if (converterType.equals((Object)HvdcConverterStation.HvdcType.LCC)) {
            if (CgmesDcConversion.inverter(mode1) && CgmesDcConversion.rectifier(mode2)) {
                return HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER;
            }
            if (CgmesDcConversion.rectifier(mode1) && CgmesDcConversion.inverter(mode2)) {
                return HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER;
            }
            if (cconverter1.asDouble(TARGET_PPCC) == 0.0 && cconverter2.asDouble(TARGET_PPCC) == 0.0) {
                return HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER;
            }
            LOG.warn("Undefined converter mode for the HVDC, assumed to be of type \"Side1 Rectifier - Side2 Inverter\"");
            return HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER;
        }
        if (cconverter1.asDouble(TARGET_PPCC) > 0.0 || cconverter2.asDouble(TARGET_PPCC) < 0.0) {
            return HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER;
        }
        return HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER;
    }

    private static boolean inverter(String operatingMode) {
        return operatingMode != null && operatingMode.toLowerCase().endsWith("inverter");
    }

    private static boolean rectifier(String operatingMode) {
        return operatingMode != null && operatingMode.toLowerCase().endsWith("rectifier");
    }

    private double computeR(PropertyBag dcLs) {
        double rDcLink = dcLs.asDouble("r", 0.0);
        if (rDcLink < 0.0) {
            double rDcLink1 = 0.1;
            this.context.fixed("resistance", "was negative", rDcLink, rDcLink1);
            rDcLink = rDcLink1;
        }
        return rDcLink;
    }

    private static double computeRatedUdc(PropertyBag cconverter1, PropertyBag cconverter2) {
        double ratedUdc1 = cconverter1.asDouble("ratedUdc");
        double ratedUdc2 = cconverter2.asDouble("ratedUdc");
        if (ratedUdc1 != 0.0) {
            return ratedUdc1;
        }
        return ratedUdc2;
    }

    private String findAcDcConverterDcTerminal(String acDcConverterId, String dcNodeId) {
        String terminalNodeProperty = this.context.nodeBreaker() ? "DCNode" : "DCTopologicalNode";
        return this.context.cgmes().dcTerminals().stream().filter(t -> acDcConverterId.equals(t.getId("DCConductingEquipment"))).filter(t -> CgmesDcConversion.isAcDcConverter(t.getId("dcConductingEquipmentType"))).filter(t -> dcNodeId.equals(t.getId(terminalNodeProperty))).findFirst().map(t -> t.getId("DCTerminal")).orElseThrow(() -> new PowsyblException(String.format("Missing terminal for converter %s at %s %s", acDcConverterId, terminalNodeProperty, dcNodeId)));
    }

    private static boolean isAcDcConverter(String type) {
        return type != null && (type.equals("CsConverter") || type.equals("VsConverter"));
    }

    private boolean createHvdc() {
        return this.createHvdc(false);
    }

    private boolean createHvdc(boolean isDuplicated) {
        double poleLossP1 = this.cconverter1.asDouble(POLE_LOSS_P, 0.0);
        double poleLossP2 = this.cconverter2.asDouble(POLE_LOSS_P, 0.0);
        double pAC1 = CgmesDcConversion.getPAc(this.cconverter1);
        double pAC2 = CgmesDcConversion.getPAc(this.cconverter2);
        LossFactor lossFactor = new LossFactor(this.context, this.operatingMode, pAC1, pAC2, poleLossP1, poleLossP2);
        lossFactor.compute();
        AcDcConverterConversion acDcConverterConversion1 = new AcDcConverterConversion(this.cconverter1, this.converterType, lossFactor.getLossFactor1(), this.acDcConverterDcTerminal1Id, this.context);
        AcDcConverterConversion acDcConverterConversion2 = new AcDcConverterConversion(this.cconverter2, this.converterType, lossFactor.getLossFactor2(), this.acDcConverterDcTerminal2Id, this.context);
        DcLineSegmentConversion.DcLineSegmentConverter converter1 = new DcLineSegmentConversion.DcLineSegmentConverter(this.converter1Id, poleLossP1, pAC1);
        DcLineSegmentConversion.DcLineSegmentConverter converter2 = new DcLineSegmentConversion.DcLineSegmentConverter(this.converter2Id, poleLossP2, pAC2);
        DcLineSegmentConversion dcLineSegmentConversion = new DcLineSegmentConversion(this.dcLineSegment, this.operatingMode, this.r, this.ratedUdc, converter1, converter2, isDuplicated, this.context);
        if (!(acDcConverterConversion1.valid() && acDcConverterConversion2.valid() && dcLineSegmentConversion.valid())) {
            return false;
        }
        if (this.converterType == HvdcConverterStation.HvdcType.VSC) {
            acDcConverterConversion1.convert();
            acDcConverterConversion2.convert();
            dcLineSegmentConversion.convert();
        } else {
            acDcConverterConversion1.convert();
            acDcConverterConversion2.convert();
            dcLineSegmentConversion.convert();
            CgmesDcConversion.updatePowerFactor(acDcConverterConversion1);
            CgmesDcConversion.updatePowerFactor(acDcConverterConversion2);
        }
        return true;
    }

    private static double getPAc(PropertyBag p) {
        return Double.isNaN(p.asDouble(TARGET_PPCC)) ? 0.0 : p.asDouble(TARGET_PPCC);
    }

    private static void updatePowerFactor(AcDcConverterConversion acDcConverterConversion) {
        if (acDcConverterConversion == null) {
            return;
        }
        LccConverterStation iconverter = acDcConverterConversion.getLccConverter();
        double powerFactor = CgmesDcConversion.getPowerFactor(iconverter);
        if (!Double.isNaN(powerFactor)) {
            acDcConverterConversion.setLccPowerFactor(powerFactor);
        }
    }

    private static double getPowerFactor(LccConverterStation iconverter) {
        return iconverter.getTerminal().getP() / Math.hypot(iconverter.getTerminal().getP(), iconverter.getTerminal().getQ());
    }

    static String getAcNode(CgmesModel cgmesModel, CgmesTerminal terminal) {
        if (cgmesModel.isNodeBreaker()) {
            return terminal.connectivityNode();
        }
        return terminal.topologicalNode();
    }

    static String getDcNode(CgmesModel cgmesModel, CgmesDcTerminal terminal) {
        if (cgmesModel.isNodeBreaker()) {
            return terminal.dcNode();
        }
        return terminal.dcTopologicalNode();
    }

    private static String findAcDcConverterConnectedTo(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, String acDcConverterId1, String acDcConverterId2, String dcNode) {
        List<String> dcNodes1 = acDcConverterNodes.getDcNodes(acDcConverterId1);
        if (dcNodes1.stream().anyMatch(dcNode1 -> CgmesDcConversion.isConnectedByOneStep(adjacency, dcNode1, dcNode))) {
            return acDcConverterId1;
        }
        List<String> dcNodes2 = acDcConverterNodes.getDcNodes(acDcConverterId2);
        if (dcNodes2.stream().anyMatch(dcNode2 -> CgmesDcConversion.isConnectedByOneStep(adjacency, dcNode2, dcNode))) {
            return acDcConverterId2;
        }
        throw new PowsyblException(String.format("Unexpected HVDC configuration: One of the two converters %s, %s must be connected to the dcNode %s", acDcConverterId1, acDcConverterId2, dcNode));
    }

    private static String findAcDcConverterNode(AcDcConverterNodes acDcConverterNodes, Adjacency adjacency, String acDcConverterId, String dcNode) {
        List<String> dcNodes = acDcConverterNodes.getDcNodes(acDcConverterId);
        Optional<String> optional = dcNodes.stream().filter(dcNodeConverter -> CgmesDcConversion.isConnectedByOneStep(adjacency, dcNodeConverter, dcNode)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new PowsyblException(String.format("Unexpected HVDC configuration: AcDcConverter %s must be connected to the dcNode %s", acDcConverterId, dcNode));
    }

    private static boolean isConnectedByOneStep(Adjacency adjacency, String dcNode1, String dcNode2) {
        if (dcNode1.equals(dcNode2)) {
            return true;
        }
        return adjacency.areAdjacentsByAcDcConverter(dcNode1, dcNode2);
    }
}

