/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractObjectConversion;
import com.powsybl.cgmes.conversion.elements.transformers.CgmesPhaseTapChangerBuilder;
import com.powsybl.cgmes.conversion.elements.transformers.CgmesRatioTapChangerBuilder;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.commons.PowsyblException;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Objects;

abstract class AbstractCgmesTapChangerBuilder {
    protected final Context context;
    protected final PropertyBag p;
    protected final TapChanger tapChanger;
    protected int lowStep;
    protected int highStep;

    AbstractCgmesTapChangerBuilder(PropertyBag p, Context context) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(context);
        this.context = context;
        this.p = p;
        this.tapChanger = new TapChanger();
    }

    static CgmesRatioTapChangerBuilder newRatioTapChanger(PropertyBag ratioTapChanger, Context context) {
        return new CgmesRatioTapChangerBuilder(ratioTapChanger, context);
    }

    static CgmesPhaseTapChangerBuilder newPhaseTapChanger(PropertyBag phaseTapChanger, double xtx, Context context) {
        return new CgmesPhaseTapChangerBuilder(phaseTapChanger, xtx, context);
    }

    protected int initialTapPosition(int defaultStep) {
        switch (this.context.config().getProfileForInitialValuesShuntSectionsTapPositions()) {
            case SSH: {
                return AbstractObjectConversion.fromContinuous(this.p.asDouble("step", this.p.asDouble("SVtapStep", (double)defaultStep)));
            }
            case SV: {
                return AbstractObjectConversion.fromContinuous(this.p.asDouble("SVtapStep", this.p.asDouble("step", (double)defaultStep)));
            }
        }
        throw new CgmesModelException("Unexpected profile used for initial values: " + this.context.config().getProfileForInitialValuesShuntSectionsTapPositions());
    }

    protected TapChanger build() {
        this.lowStep = this.p.asInt("lowStep");
        this.highStep = this.p.asInt("highStep");
        this.addSteps();
        int neutralStep = this.p.asInt("neutralStep");
        int normalStep = this.p.asInt("normalStep", neutralStep);
        int position = this.initialTapPosition(normalStep);
        if (position > this.highStep || position < this.lowStep) {
            position = neutralStep;
        }
        this.tapChanger.setLowTapPosition(this.lowStep).setTapPosition(position);
        boolean ltcFlag = this.p.asBoolean("ltcFlag", false);
        this.tapChanger.setLtcFlag(ltcFlag);
        this.addRegulationData();
        return this.tapChanger;
    }

    protected boolean isTableValid(String tableId, PropertyBags table) {
        int min;
        int i = min = table.stream().map(step -> step.asInt("step")).min(Integer::compareTo).orElseThrow(() -> new PowsyblException("Should at least contain one step")).intValue();
        while (i < min + table.size()) {
            int index = i++;
            if (!table.stream().noneMatch(step -> step.asInt("step") == index)) continue;
            this.context.ignored("TapChanger table", () -> String.format("There is at least one missing step (%s) in table %s. Tap changer considered linear", index, tableId));
            return false;
        }
        this.lowStep = min;
        this.highStep = min + table.size() - 1;
        return true;
    }

    protected abstract void addRegulationData();

    protected abstract void addSteps();

    double fixing(PropertyBag point, String attr, double defaultValue, String tableId, int step) {
        double value = point.asDouble(attr, defaultValue);
        if (Double.isNaN(value)) {
            this.context.fixed("RatioTapChangerTablePoint " + attr + " for step " + step + " in table " + tableId, "invalid value " + (String)point.get((Object)attr));
            return defaultValue;
        }
        return value;
    }
}

