/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;

public class CgmesT2xModel {
    final double r;
    final double x;
    final CgmesPartialEnd end1;
    final CgmesPartialEnd end2;
    final boolean x1IsZero;
    final Double ratedS;

    public CgmesT2xModel(PropertyBags ends, Context context) {
        PropertyBag bagEnd1 = (PropertyBag)ends.get(0);
        PropertyBag bagEnd2 = (PropertyBag)ends.get(1);
        double x1 = bagEnd1.asDouble("x");
        double x2 = bagEnd2.asDouble("x");
        this.r = bagEnd1.asDouble("r") + bagEnd2.asDouble("r");
        this.x = x1 + x2;
        this.end1 = new CgmesPartialEnd(bagEnd1, this.x, context);
        this.end2 = new CgmesPartialEnd(bagEnd2, this.x, context);
        this.x1IsZero = x1 == 0.0;
        this.ratedS = CgmesT2xModel.getRatedS(bagEnd1, bagEnd2);
    }

    static Double getRatedS(PropertyBag end1, PropertyBag end2) {
        double ratedS1 = end1.asDouble("ratedS", 0.0);
        if (ratedS1 > 0.0) {
            return ratedS1;
        }
        double ratedS2 = end2.asDouble("ratedS", 0.0);
        return ratedS2 > 0.0 ? Double.valueOf(ratedS2) : null;
    }

    static class CgmesPartialEnd {
        final double g;
        final double b;
        final TapChanger ratioTapChanger;
        final TapChanger phaseTapChanger;
        final double ratedU;
        final String terminal;

        CgmesPartialEnd(PropertyBag bagEnd, double x, Context context) {
            this.g = bagEnd.asDouble("g", 0.0);
            this.b = bagEnd.asDouble("b");
            this.ratioTapChanger = TapChanger.ratioTapChangerFromEnd(bagEnd, context);
            this.phaseTapChanger = TapChanger.phaseTapChangerFromEnd(bagEnd, x, context);
            this.ratedU = bagEnd.asDouble("ratedU");
            this.terminal = bagEnd.getId("Terminal");
        }
    }
}

