/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.transformers.InterpretedT2xModel;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.cgmes.conversion.elements.transformers.TapChangerConversion;

public class ConvertedT2xModel {
    final double r;
    final double x;
    final TapChangerConversion.ConvertedEnd1 end1;
    final ConvertedEnd2 end2;
    final Double ratedS;

    public ConvertedT2xModel(InterpretedT2xModel interpretedT2xModel, Context context) {
        TapChangerConversion.RatioConversion rc0;
        TapChangerConversion tcc = new TapChangerConversion(context);
        TapChanger nRatioTapChanger2 = TapChangerConversion.moveTapChangerFrom2To1(interpretedT2xModel.end2.ratioTapChanger);
        TapChanger nPhaseTapChanger2 = TapChangerConversion.moveTapChangerFrom2To1(interpretedT2xModel.end2.phaseTapChanger);
        TapChanger ratioTapChanger = tcc.combineTapChangers(interpretedT2xModel.end1.ratioTapChanger, nRatioTapChanger2);
        TapChanger phaseTapChanger = tcc.combineTapChangers(interpretedT2xModel.end1.phaseTapChanger, nPhaseTapChanger2);
        if (interpretedT2xModel.structuralRatioAtEnd2) {
            double a0 = interpretedT2xModel.end2.ratedU / interpretedT2xModel.end1.ratedU;
            rc0 = TapChangerConversion.moveRatioFrom2To1(a0, 0.0, interpretedT2xModel.r, interpretedT2xModel.x, interpretedT2xModel.end1.g, interpretedT2xModel.end1.b, interpretedT2xModel.end2.g, interpretedT2xModel.end2.b);
        } else {
            rc0 = TapChangerConversion.identityRatioConversion(interpretedT2xModel.r, interpretedT2xModel.x, interpretedT2xModel.end1.g, interpretedT2xModel.end1.b, interpretedT2xModel.end2.g, interpretedT2xModel.end2.b);
        }
        this.r = rc0.r;
        this.x = rc0.x;
        this.end1 = new TapChangerConversion.ConvertedEnd1(rc0.g1 + rc0.g2, rc0.b1 + rc0.b2, ratioTapChanger, phaseTapChanger, interpretedT2xModel.end1.ratedU, interpretedT2xModel.end1.terminal);
        this.end2 = new ConvertedEnd2(interpretedT2xModel.end2.ratedU, interpretedT2xModel.end2.terminal);
        this.ratedS = interpretedT2xModel.ratedS;
    }

    static class ConvertedEnd2 {
        final double ratedU;
        final String terminal;

        ConvertedEnd2(double ratedU, String terminal) {
            this.ratedU = ratedU;
            this.terminal = terminal;
        }
    }
}

