/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.Conversion;
import com.powsybl.cgmes.conversion.elements.transformers.CgmesT2xModel;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.cgmes.conversion.elements.transformers.TapChangerConversion;

public class InterpretedT2xModel {
    final double r;
    final double x;
    final TapChangerConversion.InterpretedEnd end1;
    final TapChangerConversion.InterpretedEnd end2;
    final boolean structuralRatioAtEnd2;
    final Double ratedS;

    public InterpretedT2xModel(CgmesT2xModel cgmesT2xModel, Conversion.Config alternative, Context context) {
        TapChangerConversion tcc = new TapChangerConversion(context);
        TapChangerConversion.AllTapChanger interpretedTapChanger = this.ratioPhaseAlternative(cgmesT2xModel, alternative, tcc);
        TapChangerConversion.AllShunt interpretedShunt = InterpretedT2xModel.shuntAlternative(cgmesT2xModel, alternative);
        this.r = cgmesT2xModel.r;
        this.x = cgmesT2xModel.x;
        this.end1 = new TapChangerConversion.InterpretedEnd(interpretedShunt.g1, interpretedShunt.b1, interpretedTapChanger.ratioTapChanger1, interpretedTapChanger.phaseTapChanger1, cgmesT2xModel.end1.ratedU, cgmesT2xModel.end1.terminal);
        this.end2 = new TapChangerConversion.InterpretedEnd(interpretedShunt.g2, interpretedShunt.b2, interpretedTapChanger.ratioTapChanger2, interpretedTapChanger.phaseTapChanger2, cgmesT2xModel.end2.ratedU, cgmesT2xModel.end2.terminal);
        this.structuralRatioAtEnd2 = InterpretedT2xModel.structuralRatioAlternative(cgmesT2xModel, alternative);
        this.ratedS = cgmesT2xModel.ratedS;
    }

    private TapChangerConversion.AllTapChanger ratioPhaseAlternative(CgmesT2xModel cgmesT2xModel, Conversion.Config alternative, TapChangerConversion tcc) {
        TapChanger ratioTapChanger1 = null;
        TapChanger phaseTapChanger1 = null;
        TapChanger ratioTapChanger2 = null;
        TapChanger phaseTapChanger2 = null;
        switch (alternative.getXfmr2RatioPhase()) {
            case END1: {
                ratioTapChanger1 = tcc.combineTapChangers(cgmesT2xModel.end1.ratioTapChanger, cgmesT2xModel.end2.ratioTapChanger);
                phaseTapChanger1 = tcc.combineTapChangers(cgmesT2xModel.end1.phaseTapChanger, cgmesT2xModel.end2.phaseTapChanger);
                break;
            }
            case END2: {
                ratioTapChanger2 = tcc.combineTapChangers(cgmesT2xModel.end2.ratioTapChanger, cgmesT2xModel.end1.ratioTapChanger);
                phaseTapChanger2 = tcc.combineTapChangers(cgmesT2xModel.end2.phaseTapChanger, cgmesT2xModel.end1.phaseTapChanger);
                break;
            }
            case END1_END2: {
                ratioTapChanger1 = cgmesT2xModel.end1.ratioTapChanger;
                phaseTapChanger1 = cgmesT2xModel.end1.phaseTapChanger;
                ratioTapChanger2 = cgmesT2xModel.end2.ratioTapChanger;
                phaseTapChanger2 = cgmesT2xModel.end2.phaseTapChanger;
                break;
            }
            case X: {
                if (cgmesT2xModel.x1IsZero) {
                    ratioTapChanger1 = tcc.combineTapChangers(cgmesT2xModel.end1.ratioTapChanger, cgmesT2xModel.end2.ratioTapChanger);
                    phaseTapChanger1 = tcc.combineTapChangers(cgmesT2xModel.end1.phaseTapChanger, cgmesT2xModel.end2.phaseTapChanger);
                    break;
                }
                ratioTapChanger2 = tcc.combineTapChangers(cgmesT2xModel.end2.ratioTapChanger, cgmesT2xModel.end1.ratioTapChanger);
                phaseTapChanger2 = tcc.combineTapChangers(cgmesT2xModel.end2.phaseTapChanger, cgmesT2xModel.end1.phaseTapChanger);
            }
        }
        TapChangerConversion.AllTapChanger allTapChanger = new TapChangerConversion.AllTapChanger();
        allTapChanger.ratioTapChanger1 = ratioTapChanger1;
        allTapChanger.phaseTapChanger1 = phaseTapChanger1;
        allTapChanger.ratioTapChanger2 = ratioTapChanger2;
        allTapChanger.phaseTapChanger2 = phaseTapChanger2;
        return allTapChanger;
    }

    private static TapChangerConversion.AllShunt shuntAlternative(CgmesT2xModel cgmesT2xModel, Conversion.Config alternative) {
        double g1 = 0.0;
        double b1 = 0.0;
        double g2 = 0.0;
        double b2 = 0.0;
        switch (alternative.getXfmr2Shunt()) {
            case END1: {
                g1 = cgmesT2xModel.end1.g + cgmesT2xModel.end2.g;
                b1 = cgmesT2xModel.end1.b + cgmesT2xModel.end2.b;
                break;
            }
            case END2: {
                g2 = cgmesT2xModel.end1.g + cgmesT2xModel.end2.g;
                b2 = cgmesT2xModel.end1.b + cgmesT2xModel.end2.b;
                break;
            }
            case END1_END2: {
                g1 = cgmesT2xModel.end1.g;
                b1 = cgmesT2xModel.end1.b;
                g2 = cgmesT2xModel.end2.g;
                b2 = cgmesT2xModel.end2.b;
                break;
            }
            case SPLIT: {
                g1 = (cgmesT2xModel.end1.g + cgmesT2xModel.end2.g) * 0.5;
                b1 = (cgmesT2xModel.end1.b + cgmesT2xModel.end2.b) * 0.5;
                g2 = (cgmesT2xModel.end1.g + cgmesT2xModel.end2.g) * 0.5;
                b2 = (cgmesT2xModel.end1.b + cgmesT2xModel.end2.b) * 0.5;
            }
        }
        TapChangerConversion.AllShunt allShunt = new TapChangerConversion.AllShunt();
        allShunt.g1 = g1;
        allShunt.b1 = b1;
        allShunt.g2 = g2;
        allShunt.b2 = b2;
        return allShunt;
    }

    private static boolean structuralRatioAlternative(CgmesT2xModel cgmesT2xModel, Conversion.Config alternative) {
        if (cgmesT2xModel.end1.ratedU == cgmesT2xModel.end2.ratedU) {
            return false;
        }
        switch (alternative.getXfmr2StructuralRatio()) {
            case END1: {
                return false;
            }
            case END2: {
                return true;
            }
            case X: {
                return !cgmesT2xModel.x1IsZero;
            }
        }
        return false;
    }
}

