/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.cgmes.model.CgmesModelException;
import java.util.Objects;
import org.apache.commons.math3.complex.Complex;

public class TapChangerConversion {
    protected final Context context;

    TapChangerConversion(Context context) {
        Objects.requireNonNull(context);
        this.context = context;
    }

    protected TapChanger combineTapChangers(TapChanger tc1, TapChanger tc2) {
        switch (TapChangerConversion.tapChangerType(tc1)) {
            case NULL: {
                return TapChangerConversion.combineTapChangerNull(tc2);
            }
            case FIXED: {
                return TapChangerConversion.combineTapChangerFixed(tc1, tc2);
            }
            case NON_REGULATING: {
                return this.combineTapChangerNonRegulating(tc1, tc2);
            }
            case REGULATING: {
                return this.combineTapChangerRegulating(tc1, tc2);
            }
        }
        return null;
    }

    private static TapChanger combineTapChangerNull(TapChanger tc) {
        switch (TapChangerConversion.tapChangerType(tc)) {
            case NULL: {
                return null;
            }
            case FIXED: 
            case NON_REGULATING: 
            case REGULATING: {
                return tc;
            }
        }
        return null;
    }

    private static TapChanger combineTapChangerFixed(TapChanger fixTc, TapChanger tc2) {
        switch (TapChangerConversion.tapChangerType(tc2)) {
            case NULL: {
                return fixTc;
            }
            case FIXED: 
            case NON_REGULATING: 
            case REGULATING: {
                return TapChangerConversion.combineTapChanger(tc2, fixTc);
            }
        }
        return null;
    }

    private TapChanger combineTapChangerNonRegulating(TapChanger tcNonRegulating, TapChanger tc2) {
        switch (TapChangerConversion.tapChangerType(tc2)) {
            case NULL: {
                return tcNonRegulating;
            }
            case FIXED: {
                return TapChangerConversion.combineTapChanger(tcNonRegulating, tc2);
            }
            case NON_REGULATING: {
                TapChanger ntc2 = this.tapChangerFixPosition(tc2);
                return TapChangerConversion.combineTapChanger(tcNonRegulating, ntc2);
            }
            case REGULATING: {
                TapChanger ntcNonRegulating = this.tapChangerFixPosition(tcNonRegulating);
                return TapChangerConversion.combineTapChanger(tc2, ntcNonRegulating);
            }
        }
        return null;
    }

    private TapChanger combineTapChangerRegulating(TapChanger tcRegulating, TapChanger tc2) {
        switch (TapChangerConversion.tapChangerType(tc2)) {
            case NULL: {
                return tcRegulating;
            }
            case FIXED: {
                return TapChangerConversion.combineTapChanger(tcRegulating, tc2);
            }
            case NON_REGULATING: 
            case REGULATING: {
                TapChanger ntc2 = this.tapChangerFixPosition(tc2);
                return TapChangerConversion.combineTapChanger(tcRegulating, ntc2);
            }
        }
        return null;
    }

    private static TapChanger combineTapChanger(TapChanger tc1, TapChanger tc2) {
        TapChanger tapChanger = TapChangerConversion.baseCloneTapChanger(tc1);
        TapChangerConversion.combineTapChangerSteps(tapChanger, tc1, tc2);
        tapChanger.setHiddenCombinedTapChanger(tc2);
        return tapChanger;
    }

    private TapChanger tapChangerFixPosition(TapChanger tc) {
        if (tc.getLowTapPosition() != tc.getHighTapPosition()) {
            this.context.fixed("TapChanger", () -> String.format("%s fixed tap at position %d ", tc.getId(), tc.getTapPosition()));
        }
        TapChanger tapChanger = TapChangerConversion.baseCloneTapChanger(tc);
        tapChanger.setLowTapPosition(tapChanger.getTapPosition());
        TapChanger.Step step = TapChangerConversion.getTapChangerFixedStep(tc);
        double ratio = step.getRatio();
        double angle = step.getAngle();
        double r = step.getR();
        double x = step.getX();
        double g1 = step.getG1();
        double b1 = step.getB1();
        double g2 = step.getG2();
        double b2 = step.getB2();
        tapChanger.beginStep().setRatio(ratio).setAngle(angle).setR(r).setX(x).setG1(g1).setB1(b1).setG2(g2).setB2(b2).endStep();
        return tapChanger;
    }

    private static void combineTapChangerSteps(TapChanger tapChanger, TapChanger tc1, TapChanger tc2) {
        TapChanger tc;
        TapChanger fixTc;
        if (tc1 != null && tc2 != null && tc1.getSteps().size() == 1 && tc1.getLowTapPosition() == tc1.getHighTapPosition()) {
            fixTc = tc1;
            tc = tc2;
        } else if (tc1 != null && tc2 != null && tc2.getSteps().size() == 1 && tc2.getLowTapPosition() == tc2.getHighTapPosition()) {
            fixTc = tc2;
            tc = tc1;
        } else {
            if (tc1 != null && tc2 != null) {
                throw new CgmesModelException("Unexpected number of steps in tapChangers: " + tc1.getId() + ", " + tc2.getId());
            }
            throw new CgmesModelException("Unexpected null tapChanger");
        }
        TapChanger.Step stepFixed = TapChangerConversion.getTapChangerFixedStep(fixTc);
        double ratioFixed = stepFixed.getRatio();
        double angleFixed = stepFixed.getAngle();
        double rFixed = stepFixed.getR();
        double xFixed = stepFixed.getX();
        double g1Fixed = stepFixed.getG1();
        double b1Fixed = stepFixed.getB1();
        double g2Fixed = stepFixed.getG2();
        double b2Fixed = stepFixed.getB2();
        Complex aFixed = new Complex(ratioFixed * Math.cos(Math.toRadians(angleFixed)), ratioFixed * Math.sin(Math.toRadians(angleFixed)));
        tc.getSteps().forEach(step -> {
            double ratio = step.getRatio();
            double angle = step.getAngle();
            double r = step.getR();
            double x = step.getX();
            double g1 = step.getG1();
            double b1 = step.getB1();
            double g2 = step.getG2();
            double b2 = step.getB2();
            Complex a = new Complex(ratio * Math.cos(Math.toRadians(angle)), ratio * Math.sin(Math.toRadians(angle)));
            Complex na = a.multiply(aFixed);
            tapChanger.beginStep().setRatio(na.abs()).setAngle(Math.toDegrees(na.getArgument())).setR(TapChangerConversion.combineTapChangerCorrection(rFixed, r)).setX(TapChangerConversion.combineTapChangerCorrection(xFixed, x)).setG1(TapChangerConversion.combineTapChangerCorrection(g1Fixed, g1)).setB1(TapChangerConversion.combineTapChangerCorrection(b1Fixed, b1)).setG2(TapChangerConversion.combineTapChangerCorrection(g2Fixed, g2)).setB2(TapChangerConversion.combineTapChangerCorrection(b2Fixed, b2)).endStep();
        });
        tapChanger.setLowTapPosition(tc.getLowTapPosition());
        tapChanger.setTapPosition(tc.getTapPosition());
    }

    private static double combineTapChangerCorrection(double correction1, double correction2) {
        if (correction1 != 0.0 && correction2 != 0.0) {
            return 100.0 * ((1.0 + correction1 / 100.0) * (1.0 + correction2 / 100.0) - 1.0);
        }
        if (correction1 != 0.0) {
            return correction1;
        }
        if (correction2 != 0.0) {
            return correction2;
        }
        return 0.0;
    }

    protected static TapChanger moveTapChangerFrom1To2(TapChanger tc) {
        return TapChangerConversion.moveTapChangerFromOneEndToTheOther(tc);
    }

    protected static TapChanger moveTapChangerFrom2To1(TapChanger tc) {
        return TapChangerConversion.moveTapChangerFromOneEndToTheOther(tc);
    }

    private static TapChanger moveTapChangerFromOneEndToTheOther(TapChanger tc) {
        switch (TapChangerConversion.tapChangerType(tc)) {
            case NULL: {
                return null;
            }
            case FIXED: 
            case NON_REGULATING: 
            case REGULATING: {
                return TapChangerConversion.moveTapChanger(tc);
            }
        }
        return null;
    }

    private static TapChanger moveTapChanger(TapChanger tc) {
        TapChanger tapChanger = TapChangerConversion.baseCloneTapChanger(tc);
        TapChangerConversion.moveTapChangerSteps(tapChanger, tc);
        return tapChanger;
    }

    private static void moveTapChangerSteps(TapChanger tapChanger, TapChanger tc) {
        tc.getSteps().forEach(step -> {
            double ratio = step.getRatio();
            double angle = step.getAngle();
            double r = step.getR();
            double x = step.getX();
            double g1 = step.getG1();
            double b1 = step.getB1();
            double g2 = step.getG2();
            double b2 = step.getB2();
            TapChangerStepConversion convertedStep = TapChangerConversion.calculateConversionStep(ratio, angle, r, x, g1, b1, g2, b2);
            tapChanger.beginStep().setRatio(convertedStep.ratio).setAngle(convertedStep.angle).setR(convertedStep.r).setX(convertedStep.x).setG1(convertedStep.g1).setB1(convertedStep.b1).setG2(convertedStep.g2).setB2(convertedStep.b2).endStep();
        });
    }

    private static TapChangerStepConversion calculateConversionStep(double a, double angle, double r, double x, double g1, double b1, double g2, double b2) {
        Complex ratio = new Complex(a * Math.cos(Math.toRadians(angle)), a * Math.sin(Math.toRadians(angle)));
        return TapChangerConversion.calculateConversionStep(ratio, r, x, g1, b1, g2, b2);
    }

    private static TapChangerStepConversion calculateConversionStep(Complex a, double r, double x, double g1, double b1, double g2, double b2) {
        TapChangerStepConversion step = new TapChangerStepConversion();
        Complex na = a.reciprocal();
        step.ratio = na.abs();
        step.angle = Math.toDegrees(na.getArgument());
        step.r = 100.0 * (TapChangerConversion.impedanceConversion(1.0 + r / 100.0, a) - 1.0);
        step.x = 100.0 * (TapChangerConversion.impedanceConversion(1.0 + x / 100.0, a) - 1.0);
        step.g1 = 100.0 * (TapChangerConversion.admittanceConversion(1.0 + g1 / 100.0, a) - 1.0);
        step.b1 = 100.0 * (TapChangerConversion.admittanceConversion(1.0 + b1 / 100.0, a) - 1.0);
        step.g2 = 100.0 * (TapChangerConversion.admittanceConversion(1.0 + g2 / 100.0, a) - 1.0);
        step.b2 = 100.0 * (TapChangerConversion.admittanceConversion(1.0 + b2 / 100.0, a) - 1.0);
        return step;
    }

    protected static RatioConversion identityRatioConversion(double r, double x, double g1, double b1, double g2, double b2) {
        RatioConversion ratio = new RatioConversion();
        ratio.r = r;
        ratio.x = x;
        ratio.g1 = g1;
        ratio.b1 = b1;
        ratio.g2 = g2;
        ratio.b2 = b2;
        return ratio;
    }

    protected static RatioConversion moveRatioFrom2To1(double a, double angle, double r, double x, double g1, double b1, double g2, double b2) {
        return TapChangerConversion.moveRatio(a, angle, r, x, g1, b1, g2, b2);
    }

    protected static RatioConversion moveRatioFrom1To2(double a, double angle, double r, double x, double g1, double b1, double g2, double b2) {
        return TapChangerConversion.moveRatio(a, angle, r, x, g1, b1, g2, b2);
    }

    private static RatioConversion moveRatio(double a, double angle, double r, double x, double g1, double b1, double g2, double b2) {
        Complex ratio = new Complex(a * Math.cos(Math.toRadians(angle)), a * Math.sin(Math.toRadians(angle)));
        return TapChangerConversion.moveRatio(ratio, r, x, g1, b1, g2, b2);
    }

    private static RatioConversion moveRatio(Complex a, double r, double x, double g1, double b1, double g2, double b2) {
        RatioConversion ratio = new RatioConversion();
        ratio.r = TapChangerConversion.impedanceConversion(r, a);
        ratio.x = TapChangerConversion.impedanceConversion(x, a);
        ratio.g1 = TapChangerConversion.admittanceConversion(g1, a);
        ratio.b1 = TapChangerConversion.admittanceConversion(b1, a);
        ratio.g2 = TapChangerConversion.admittanceConversion(g2, a);
        ratio.b2 = TapChangerConversion.admittanceConversion(b2, a);
        return ratio;
    }

    private static double admittanceConversion(double correction, Complex a) {
        double a2 = a.abs() * a.abs();
        return correction / a2;
    }

    private static double impedanceConversion(double correction, Complex a) {
        double a2 = a.abs() * a.abs();
        return correction * a2;
    }

    private static TapChanger baseCloneTapChanger(TapChanger rtc) {
        TapChanger tapChanger = new TapChanger();
        String id = rtc.getId();
        boolean isLtcFlag = rtc.isLtcFlag();
        boolean isRegulating = rtc.isRegulating();
        String regulatingControlId = rtc.getRegulatingControlId();
        String tculControlMode = rtc.getTculControlMode();
        boolean isTapChangerControlEnabled = rtc.isTapChangerControlEnabled();
        int lowStep = rtc.getLowTapPosition();
        int position = rtc.getTapPosition();
        String type = rtc.getType();
        TapChanger hiddenCombinedTapChanger = rtc.getHiddenCombinedTapChanger();
        tapChanger.setLowTapPosition(lowStep).setTapPosition(position).setLtcFlag(isLtcFlag).setId(id).setRegulating(isRegulating).setRegulatingControlId(regulatingControlId).setTculControlMode(tculControlMode).setTapChangerControlEnabled(isTapChangerControlEnabled).setType(type).setHiddenCombinedTapChanger(hiddenCombinedTapChanger);
        return tapChanger;
    }

    private static TapChanger.Step getTapChangerFixedStep(TapChanger tc) {
        if (TapChangerConversion.isTapChangerFixed(tc)) {
            return tc.getSteps().get(0);
        }
        int position = tc.getTapPosition();
        int lowPosition = tc.getLowTapPosition();
        return tc.getSteps().get(position - lowPosition);
    }

    private static TapChangerType tapChangerType(TapChanger tc) {
        if (TapChangerConversion.isTapChangerNull(tc)) {
            return TapChangerType.NULL;
        }
        if (TapChangerConversion.isTapChangerFixed(tc)) {
            return TapChangerType.FIXED;
        }
        if (!TapChangerConversion.isTapChangerRegulating(tc)) {
            return TapChangerType.NON_REGULATING;
        }
        return TapChangerType.REGULATING;
    }

    private static boolean isTapChangerNull(TapChanger tc) {
        return tc == null;
    }

    private static boolean isTapChangerFixed(TapChanger tc) {
        return tc.getSteps().size() == 1;
    }

    private static boolean isTapChangerRegulating(TapChanger tc) {
        return tc.isRegulating();
    }

    private static enum TapChangerType {
        NULL,
        FIXED,
        NON_REGULATING,
        REGULATING;

    }

    static class TapChangerStepConversion {
        double ratio;
        double angle;
        double r;
        double x;
        double g1;
        double b1;
        double g2;
        double b2;

        TapChangerStepConversion() {
        }
    }

    static class RatioConversion {
        double r;
        double x;
        double g1;
        double b1;
        double g2;
        double b2;

        RatioConversion() {
        }
    }

    static class AllShunt {
        double g1;
        double b1;
        double g2;
        double b2;

        AllShunt() {
        }
    }

    static class AllTapChanger {
        TapChanger ratioTapChanger1;
        TapChanger phaseTapChanger1;
        TapChanger ratioTapChanger2;
        TapChanger phaseTapChanger2;

        AllTapChanger() {
        }
    }

    static class ConvertedEnd1 {
        final double g;
        final double b;
        final TapChanger ratioTapChanger;
        final TapChanger phaseTapChanger;
        final double ratedU;
        final String terminal;

        ConvertedEnd1(double g, double b, TapChanger ratioTapChanger, TapChanger phaseTapChanger, double ratedU, String terminal) {
            this.g = g;
            this.b = b;
            this.ratioTapChanger = ratioTapChanger;
            this.phaseTapChanger = phaseTapChanger;
            this.ratedU = ratedU;
            this.terminal = terminal;
        }
    }

    static class InterpretedEnd {
        final double g;
        final double b;
        final TapChanger ratioTapChanger;
        final TapChanger phaseTapChanger;
        final double ratedU;
        final String terminal;

        InterpretedEnd(double g, double b, TapChanger ratioTapChanger, TapChanger phaseTapChanger, double ratedU, String terminal) {
            this.g = g;
            this.b = b;
            this.ratioTapChanger = ratioTapChanger;
            this.phaseTapChanger = phaseTapChanger;
            this.ratedU = ratedU;
            this.terminal = terminal;
        }
    }
}

