/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export;

import com.fasterxml.uuid.Generators;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.cgmes.conversion.export.ReferenceDataProvider;
import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.cgmes.conversion.naming.NamingStrategyFactory;
import com.powsybl.cgmes.extensions.BaseVoltageMapping;
import com.powsybl.cgmes.extensions.BaseVoltageMappingAdder;
import com.powsybl.cgmes.extensions.CgmesControlArea;
import com.powsybl.cgmes.extensions.CgmesControlAreas;
import com.powsybl.cgmes.extensions.CgmesControlAreasAdder;
import com.powsybl.cgmes.extensions.CgmesTopologyKind;
import com.powsybl.cgmes.extensions.CimCharacteristics;
import com.powsybl.cgmes.extensions.Source;
import com.powsybl.cgmes.model.CgmesNamespace;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.MinMaxReactiveLimits;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.ReactiveLimitsKind;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class CgmesExportContext {
    private static final String REGULATING_CONTROL = "RegulatingControl";
    private static final String GENERATING_UNIT = "GeneratingUnit";
    private static final String DCNODE = "DCNode";
    private static final String DCTERMINAL = "DCTerminal";
    private static final String ACDCCONVERTERDCTERMINAL = "ACDCConverterDCTerminal";
    private static final String TERMINAL_BOUNDARY = "Terminal_Boundary";
    private static final String REGION_ID = "regionId";
    private static final String REGION_NAME = "regionName";
    private static final String DEFAULT_REGION = "default region";
    public static final String SUB_REGION_ID = "subRegionId";
    private static final String BOUNDARY_EQ_ID_PROPERTY = "CGMES.EQ_BD_ID";
    private static final String BOUNDARY_TP_ID_PROPERTY = "CGMES.TP_BD_ID";
    private CgmesNamespace.Cim cim = CgmesNamespace.CIM_16;
    private CgmesTopologyKind topologyKind = CgmesTopologyKind.BUS_BRANCH;
    private ZonedDateTime scenarioTime = ZonedDateTime.now();
    private ReportNode reportNode = ReportNode.NO_OP;
    private String businessProcess = "1D";
    private NamingStrategy namingStrategy = new NamingStrategy.Identity();
    private String modelingAuthoritySet = null;
    private String modelDescription = null;
    private String modelVersion = null;
    private String boundaryEqId = null;
    private String boundaryTpId = null;
    private List<String> profiles = null;
    private String baseName = null;
    public static final boolean CGM_EXPORT_VALUE = false;
    public static final boolean EXPORT_BOUNDARY_POWER_FLOWS_DEFAULT_VALUE = true;
    public static final boolean EXPORT_POWER_FLOWS_FOR_SWITCHES_DEFAULT_VALUE = true;
    public static final boolean EXPORT_TRANSFORMERS_WITH_HIGHEST_VOLTAGE_AT_END1_DEFAULT_VALUE = false;
    public static final boolean ENCODE_IDS_DEFAULT_VALUE = true;
    public static final boolean EXPORT_LOAD_FLOW_STATUS_DEFAULT_VALUE = true;
    public static final boolean EXPORT_ALL_LIMITS_GROUP_DEFAULT_VALUE = true;
    public static final boolean EXPORT_GENERATORS_IN_LOCAL_REGULATION_MODE_DEFAULT_VALUE = false;
    public static final double MAX_P_MISMATCH_CONVERGED_DEFAULT_VALUE = 0.1;
    public static final double MAX_Q_MISMATCH_CONVERGED_DEFAULT_VALUE = 0.1;
    public static final boolean EXPORT_SV_INJECTIONS_FOR_SLACKS_DEFAULT_VALUE = true;
    public static final String DEFAULT_MODELING_AUTHORITY_SET_VALUE = "powsybl.org";
    public static final UUID DEFAULT_UUID_NAMESPACE = Generators.nameBasedGenerator().generate("powsybl.org");
    public static final String DEFAULT_BUSINESS_PROCESS = "1D";
    public static final boolean UPDATE_DEPENDENCIES_DEFAULT_VALUE = true;
    private boolean exportBoundaryPowerFlows = true;
    private boolean exportFlowsForSwitches = true;
    private boolean exportTransformersWithHighestVoltageAtEnd1 = false;
    private boolean exportLoadFlowStatus = true;
    private boolean exportAllLimitsGroup = true;
    private boolean exportGeneratorsInLocalRegulationMode = false;
    private double maxPMismatchConverged = 0.1;
    private double maxQMismatchConverged = 0.1;
    private boolean isExportSvInjectionsForSlacks = true;
    private boolean updateDependencies = true;
    private boolean exportEquipment = false;
    private boolean encodeIds = true;
    private final Map<Double, BaseVoltageMapping.BaseVoltageSource> baseVoltageByNominalVoltageMapping = new HashMap<Double, BaseVoltageMapping.BaseVoltageSource>();
    private final BiMap<String, String> regionsIdsByRegionName = HashBiMap.create();
    private final BiMap<String, String> subRegionsIdsBySubRegionName = HashBiMap.create();
    private final Map<String, String> fictitiousContainers = new HashMap<String, String>();
    private final Map<String, Bus> topologicalNodes = new HashMap<String, Bus>();
    private final ReferenceDataProvider referenceDataProvider;

    public String getFictitiousContainerFor(Identifiable<?> id) {
        return this.fictitiousContainers.get(id.getId());
    }

    public void setFictitiousContainerFor(Identifiable<?> id, String containerId) {
        this.fictitiousContainers.put(id.getId(), containerId);
    }

    public CgmesExportContext() {
        this.referenceDataProvider = null;
    }

    public CgmesExportContext(Network network) {
        this(network, null, NamingStrategyFactory.create("identity", DEFAULT_UUID_NAMESPACE));
    }

    public CgmesExportContext(Network network, ReferenceDataProvider referenceDataProvider) {
        this(network, referenceDataProvider, NamingStrategyFactory.create("identity", DEFAULT_UUID_NAMESPACE));
    }

    public CgmesExportContext(Network network, UUID uuidNamespace) {
        this(network, null, NamingStrategyFactory.create("identity", uuidNamespace));
    }

    public CgmesExportContext(Network network, ReferenceDataProvider referenceDataProvider, UUID uuidNamespace) {
        this(network, referenceDataProvider, NamingStrategyFactory.create("identity", uuidNamespace));
    }

    public CgmesExportContext(Network network, ReferenceDataProvider referenceDataProvider, NamingStrategy namingStrategy) {
        this.referenceDataProvider = referenceDataProvider;
        this.namingStrategy = namingStrategy;
        CimCharacteristics cimCharacteristics = (CimCharacteristics)network.getExtension(CimCharacteristics.class);
        if (cimCharacteristics != null) {
            this.setCimVersion(cimCharacteristics.getCimVersion());
            this.topologyKind = cimCharacteristics.getTopologyKind();
        } else {
            this.topologyKind = this.networkTopologyKind(network);
        }
        this.scenarioTime = network.getCaseDate();
        this.addIidmMappings(network);
        if (network.hasProperty(BOUNDARY_EQ_ID_PROPERTY)) {
            this.setBoundaryEqId(network.getProperty(BOUNDARY_EQ_ID_PROPERTY));
        }
        if (network.hasProperty(BOUNDARY_TP_ID_PROPERTY)) {
            this.setBoundaryTpId(network.getProperty(BOUNDARY_TP_ID_PROPERTY));
        }
    }

    private CgmesTopologyKind networkTopologyKind(Network network) {
        for (VoltageLevel vl : network.getVoltageLevels()) {
            if (!vl.getTopologyKind().equals((Object)TopologyKind.NODE_BREAKER)) continue;
            return CgmesTopologyKind.NODE_BREAKER;
        }
        return CgmesTopologyKind.BUS_BRANCH;
    }

    public void addIidmMappings(Network network) {
        this.addIidmMappingsSubstations(network);
        BaseVoltageMapping bvMapping = (BaseVoltageMapping)network.getExtension(BaseVoltageMapping.class);
        if (bvMapping == null) {
            ((BaseVoltageMappingAdder)network.newExtension(BaseVoltageMappingAdder.class)).add();
            bvMapping = (BaseVoltageMapping)network.getExtension(BaseVoltageMapping.class);
        }
        this.addIidmMappingsBaseVoltages(bvMapping, network);
        this.addIidmMappingsTerminals(network);
        this.addIidmMappingsGenerators(network);
        this.addIidmMappingsBatteries(network);
        this.addIidmMappingsShuntCompensators(network);
        this.addIidmMappingsStaticVarCompensators(network);
        this.addIidmMappingsEndsAndTapChangers(network);
        this.addIidmMappingsEquivalentInjection(network);
        this.addIidmMappingsControlArea(network);
    }

    private void addIidmMappingsSubstations(Network network) {
        for (Substation substation : network.getSubstations()) {
            String regionName;
            if (!substation.hasProperty("CGMES.regionId")) {
                Pair<String, String> region = this.getCreateRegion(substation);
                String regionId = (String)region.getLeft();
                regionName = (String)region.getRight();
                substation.setProperty("CGMES.regionId", regionId);
                substation.setProperty("CGMES.regionName", regionName);
            } else {
                String regionId = this.namingStrategy.getCgmesIdFromProperty((Identifiable<?>)substation, "CGMES.regionId");
                regionName = substation.getProperty("CGMES.regionName");
                if (!this.regionsIdsByRegionName.containsValue((Object)regionId)) {
                    this.regionsIdsByRegionName.computeIfAbsent((Object)regionName, k -> regionId);
                }
            }
            String geoTag = substation.getGeographicalTags().size() == 1 ? (String)substation.getGeographicalTags().iterator().next() : regionName;
            if (!substation.hasProperty("CGMES.subRegionId")) {
                String id = (String)this.subRegionsIdsBySubRegionName.computeIfAbsent((Object)geoTag, k -> this.namingStrategy.getCgmesId(CgmesObjectReference.ref(k), CgmesObjectReference.Part.SUB_GEOGRAPHICAL_REGION));
                substation.setProperty("CGMES.subRegionId", id);
                continue;
            }
            this.subRegionsIdsBySubRegionName.computeIfAbsent((Object)geoTag, k -> this.namingStrategy.getCgmesIdFromProperty((Identifiable<?>)substation, "CGMES.subRegionId"));
        }
    }

    private Pair<String, String> getCreateRegion(Substation substation) {
        Pair region = null;
        if (this.referenceDataProvider != null) {
            region = this.referenceDataProvider.getSourcingActorRegion();
        }
        if (region == null) {
            String regionName = substation.getCountry().map(Enum::name).orElse(DEFAULT_REGION);
            String regionId = (String)this.regionsIdsByRegionName.computeIfAbsent((Object)regionName, k -> this.namingStrategy.getCgmesId(CgmesObjectReference.ref(k), CgmesObjectReference.Part.GEOGRAPHICAL_REGION));
            region = Pair.of((Object)regionId, (Object)regionName);
        }
        return region;
    }

    private void addIidmMappingsBaseVoltages(BaseVoltageMapping mapping, Network network) {
        DecimalFormat noTrailingZerosFormat = new DecimalFormat("0.##");
        if (mapping.isBaseVoltageEmpty()) {
            for (VoltageLevel vl : network.getVoltageLevels()) {
                double nominalV = vl.getNominalV();
                String baseVoltageId = null;
                if (this.referenceDataProvider != null && (baseVoltageId = this.referenceDataProvider.getBaseVoltage(nominalV)) != null) {
                    mapping.addBaseVoltage(nominalV, baseVoltageId, Source.BOUNDARY);
                }
                if (baseVoltageId != null || mapping.getBaseVoltage(nominalV) != null) continue;
                CgmesObjectReference vref = CgmesObjectReference.ref(noTrailingZerosFormat.format(nominalV));
                baseVoltageId = this.namingStrategy.getCgmesId(vref, CgmesObjectReference.Part.BASE_VOLTAGE);
                mapping.addBaseVoltage(nominalV, baseVoltageId, Source.IGM);
            }
        }
        Map bvByNominalVoltage = mapping.baseVoltagesByNominalVoltageMap();
        this.baseVoltageByNominalVoltageMapping.putAll(bvByNominalVoltage);
    }

    private void addIidmMappingsTerminals(Network network) {
        for (Connectable c : network.getConnectables()) {
            if (!this.isExportedEquipment((Identifiable<?>)c)) continue;
            for (Terminal t : c.getTerminals()) {
                this.addIidmMappingsTerminal(t, c);
            }
        }
        this.addIidmMappingsSwitchTerminals(network);
        this.addIidmMappingsHvdcTerminals(network);
    }

    public boolean isExportEquipment() {
        return this.exportEquipment;
    }

    public CgmesExportContext setExportEquipment(boolean exportEquipment) {
        this.exportEquipment = exportEquipment;
        return this;
    }

    public boolean isExportedEquipment(Identifiable<?> c) {
        boolean ignored = c.isFictitious() && (c instanceof Load || c instanceof Switch && "true".equals(c.getProperty("CGMES.isCreatedForDisconnectedTerminal")));
        return !ignored;
    }

    private void addIidmMappingsSwitchTerminals(Network network) {
        for (Switch sw : network.getSwitches()) {
            String terminal2Id;
            String terminal1Id = sw.getAliasFromType("CGMES.Terminal1").orElse(null);
            if (terminal1Id == null) {
                terminal1Id = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(sw), CgmesObjectReference.Part.TERMINAL, CgmesObjectReference.ref(1));
                sw.addAlias(terminal1Id, "CGMES.Terminal1");
            }
            if ((terminal2Id = (String)sw.getAliasFromType("CGMES.Terminal2").orElse(null)) != null) continue;
            terminal2Id = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(sw), CgmesObjectReference.Part.TERMINAL, CgmesObjectReference.ref(2));
            sw.addAlias(terminal2Id, "CGMES.Terminal2");
        }
    }

    private void addIidmMappingsHvdcTerminals(Network network) {
        for (HvdcLine line : network.getHvdcLines()) {
            String acdcConverterDcTerminal2;
            String acdcConverterDcTerminal1;
            String dcTerminal2;
            String dcTerminal1;
            String dcNode2;
            String dcNode1 = line.getAliasFromType("CGMES.DCNode1").orElse(null);
            if (dcNode1 == null) {
                dcNode1 = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.DCNODE, CgmesObjectReference.ref(1));
                line.addAlias(dcNode1, "CGMES.DCNode1");
            }
            if ((dcNode2 = (String)line.getAliasFromType("CGMES.DCNode2").orElse(null)) == null) {
                dcNode2 = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.DCNODE, CgmesObjectReference.ref(2));
                line.addAlias(dcNode2, "CGMES.DCNode2");
            }
            if ((dcTerminal1 = (String)line.getAliasFromType("CGMES.DCTerminal1").orElse(null)) == null) {
                dcTerminal1 = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.TERMINAL, CgmesObjectReference.ref(1));
                line.addAlias(dcTerminal1, "CGMES.DCTerminal1");
            }
            if ((dcTerminal2 = (String)line.getAliasFromType("CGMES.DCTerminal2").orElse(null)) == null) {
                dcTerminal2 = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.TERMINAL, CgmesObjectReference.ref(2));
                line.addAlias(dcTerminal2, "CGMES.DCTerminal2");
            }
            if ((acdcConverterDcTerminal1 = (String)line.getConverterStation1().getAliasFromType("CGMES.ACDCConverterDCTerminal").orElse(null)) == null) {
                acdcConverterDcTerminal1 = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.ACDC_CONVERTER_DC_TERMINAL, CgmesObjectReference.ref(1));
                line.getConverterStation1().addAlias(acdcConverterDcTerminal1, "CGMES.ACDCConverterDCTerminal");
            }
            if ((acdcConverterDcTerminal2 = (String)line.getConverterStation2().getAliasFromType("CGMES.ACDCConverterDCTerminal").orElse(null)) != null) continue;
            acdcConverterDcTerminal2 = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.ACDC_CONVERTER_DC_TERMINAL, CgmesObjectReference.ref(2));
            line.getConverterStation2().addAlias(acdcConverterDcTerminal2, "CGMES.ACDCConverterDCTerminal");
        }
    }

    private void addIidmMappingsTerminal(Terminal t, Connectable<?> c) {
        if (c instanceof DanglingLine) {
            String boundaryId;
            String terminalId = c.getAliasFromType("CGMES.Terminal1").orElse(null);
            if (terminalId == null) {
                terminalId = c.getAliasFromType("CGMES.Terminal").orElse(null);
                if (terminalId != null) {
                    c.removeAlias(terminalId);
                } else {
                    terminalId = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(c), CgmesObjectReference.Part.TERMINAL);
                }
                c.addAlias(terminalId, "CGMES.Terminal1");
            }
            if ((boundaryId = (String)c.getAliasFromType("CGMES.Terminal_Boundary").orElse(null)) == null) {
                boundaryId = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(c), CgmesObjectReference.Part.BOUNDARY_TERMINAL);
                c.addAlias(boundaryId, "CGMES.Terminal_Boundary");
            }
        } else {
            int sequenceNumber = CgmesExportUtil.getTerminalSequenceNumber(t);
            String terminalId = c.getAliasFromType("CGMES.Terminal" + sequenceNumber).orElse(null);
            if (terminalId == null) {
                terminalId = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(c), CgmesObjectReference.Part.TERMINAL, CgmesObjectReference.ref(sequenceNumber));
                c.addAlias(terminalId, "CGMES.Terminal" + sequenceNumber);
            }
        }
    }

    private static boolean isCondenser(Generator generator) {
        return CgmesExportUtil.obtainSynchronousMachineKind(generator, generator.getMinP(), generator.getMaxP(), CgmesExportUtil.obtainCurve(generator)).contains("condenser");
    }

    private void addIidmMappingsGenerators(Network network) {
        for (Generator generator : network.getGenerators()) {
            String regulatingControlId;
            String generatingUnit;
            if (!CgmesExportContext.isCondenser(generator) && (generatingUnit = generator.getProperty("CGMES.GeneratingUnit")) == null) {
                generatingUnit = this.namingStrategy.getCgmesId(CgmesObjectReference.ref(generator), CgmesObjectReference.refGeneratingUnit(generator));
                generator.setProperty("CGMES.GeneratingUnit", generatingUnit);
            }
            if ((regulatingControlId = generator.getProperty("CGMES.RegulatingControl")) != null || !CgmesExportContext.hasVoltageControlCapability(generator)) continue;
            regulatingControlId = this.namingStrategy.getCgmesId(CgmesObjectReference.ref(generator), CgmesObjectReference.Part.REGULATING_CONTROL);
            generator.setProperty("CGMES.RegulatingControl", regulatingControlId);
        }
    }

    private static boolean hasVoltageControlCapability(Generator generator) {
        if (generator.getReactiveLimits() == null) {
            return false;
        }
        ReactiveLimits reactiveLimits = generator.getReactiveLimits();
        if (reactiveLimits.getKind() == ReactiveLimitsKind.CURVE) {
            return CgmesExportContext.hasReactiveCapability((ReactiveCapabilityCurve)reactiveLimits);
        }
        if (reactiveLimits.getKind() == ReactiveLimitsKind.MIN_MAX) {
            return CgmesExportContext.hasReactiveCapability((MinMaxReactiveLimits)reactiveLimits);
        }
        return false;
    }

    private static boolean hasReactiveCapability(ReactiveCapabilityCurve rcc) {
        for (ReactiveCapabilityCurve.Point point : rcc.getPoints()) {
            if (point.getMaxQ() == point.getMinQ()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasReactiveCapability(MinMaxReactiveLimits mmrl) {
        return mmrl.getMaxQ() != mmrl.getMinQ();
    }

    private void addIidmMappingsBatteries(Network network) {
        for (Battery battery : network.getBatteries()) {
            String generatingUnit = battery.getProperty("CGMES.GeneratingUnit");
            if (generatingUnit != null) continue;
            generatingUnit = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(battery), CgmesObjectReference.Part.GENERATING_UNIT);
            battery.setProperty("CGMES.GeneratingUnit", generatingUnit);
        }
    }

    private void addIidmMappingsShuntCompensators(Network network) {
        for (ShuntCompensator shuntCompensator : network.getShuntCompensators()) {
            String regulatingControlId;
            if ("true".equals(shuntCompensator.getProperty("CGMES.isEquivalentShunt")) || (regulatingControlId = shuntCompensator.getProperty("CGMES.RegulatingControl")) != null || !CgmesExportUtil.isValidVoltageSetpoint(shuntCompensator.getTargetV()) && Objects.equals(shuntCompensator, shuntCompensator.getRegulatingTerminal().getConnectable())) continue;
            regulatingControlId = this.namingStrategy.getCgmesId(CgmesObjectReference.ref(shuntCompensator), CgmesObjectReference.Part.REGULATING_CONTROL);
            shuntCompensator.setProperty("CGMES.RegulatingControl", regulatingControlId);
        }
    }

    private void addIidmMappingsStaticVarCompensators(Network network) {
        for (StaticVarCompensator svc : network.getStaticVarCompensators()) {
            String regulatingControlId = svc.getProperty("CGMES.RegulatingControl");
            boolean validVoltageSetpoint = CgmesExportUtil.isValidVoltageSetpoint(svc.getVoltageSetpoint());
            boolean validReactiveSetpoint = CgmesExportUtil.isValidReactivePowerSetpoint(svc.getReactivePowerSetpoint());
            if (regulatingControlId != null || !validReactiveSetpoint && !validVoltageSetpoint && Objects.equals(svc, svc.getRegulatingTerminal().getConnectable())) continue;
            regulatingControlId = this.namingStrategy.getCgmesId(CgmesObjectReference.ref(svc), CgmesObjectReference.Part.REGULATING_CONTROL);
            svc.setProperty("CGMES.RegulatingControl", regulatingControlId);
        }
    }

    private void addIidmMappingsEndsAndTapChangers(Network network) {
        for (TwoWindingsTransformer twt : network.getTwoWindingsTransformers()) {
            this.addIidmTransformerEnd((Identifiable<?>)twt, 1);
            this.addIidmTransformerEnd((Identifiable<?>)twt, 2);
            this.addIidmTapChanger2wt((Identifiable<?>)twt, (TapChanger<?, ?, ?, ?>)twt.getPhaseTapChanger(), "PhaseTapChanger");
            this.addIidmTapChanger2wt((Identifiable<?>)twt, (TapChanger<?, ?, ?, ?>)twt.getRatioTapChanger(), "RatioTapChanger");
        }
        for (TwoWindingsTransformer twt : network.getThreeWindingsTransformers()) {
            this.addIidmTransformerEnd((Identifiable<?>)twt, 1);
            this.addIidmTransformerEnd((Identifiable<?>)twt, 2);
            this.addIidmTransformerEnd((Identifiable<?>)twt, 3);
            this.addIidmTapChanger((Identifiable<?>)twt, (TapChanger<?, ?, ?, ?>)twt.getLeg1().getPhaseTapChanger(), "PhaseTapChanger", 1);
            this.addIidmTapChanger((Identifiable<?>)twt, (TapChanger<?, ?, ?, ?>)twt.getLeg1().getRatioTapChanger(), "RatioTapChanger", 1);
            this.addIidmTapChanger((Identifiable<?>)twt, (TapChanger<?, ?, ?, ?>)twt.getLeg2().getPhaseTapChanger(), "PhaseTapChanger", 2);
            this.addIidmTapChanger((Identifiable<?>)twt, (TapChanger<?, ?, ?, ?>)twt.getLeg2().getRatioTapChanger(), "RatioTapChanger", 2);
            this.addIidmTapChanger((Identifiable<?>)twt, (TapChanger<?, ?, ?, ?>)twt.getLeg3().getPhaseTapChanger(), "PhaseTapChanger", 3);
            this.addIidmTapChanger((Identifiable<?>)twt, (TapChanger<?, ?, ?, ?>)twt.getLeg3().getRatioTapChanger(), "RatioTapChanger", 3);
        }
    }

    private void addIidmTransformerEnd(Identifiable<?> eq, int end) {
        String endId = eq.getAliasFromType("CGMES.TransformerEnd" + end).orElse(null);
        if (endId == null) {
            endId = this.namingStrategy.getCgmesId(CgmesObjectReference.ref(eq), CgmesObjectReference.combo(CgmesObjectReference.Part.TRANSFORMER_END, CgmesObjectReference.ref(end)));
            eq.addAlias(endId, "CGMES.TransformerEnd" + end);
        }
    }

    private void addIidmTapChanger(Identifiable<?> eq, TapChanger<?, ?, ?, ?> tc, String typeChangerTypeName, int endNumber) {
        String aliasType;
        if (tc != null && eq.getAliasFromType(aliasType = "CGMES." + typeChangerTypeName + endNumber).isEmpty()) {
            CgmesObjectReference.Part ratioPhasePart = Objects.equals(typeChangerTypeName, "PhaseTapChanger") ? CgmesObjectReference.Part.PHASE_TAP_CHANGER : CgmesObjectReference.Part.RATIO_TAP_CHANGER;
            String newTapChangerId = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(eq), ratioPhasePart, CgmesObjectReference.ref(endNumber));
            eq.addAlias(newTapChangerId, aliasType);
        }
    }

    private void addIidmTapChanger2wt(Identifiable<?> eq, TapChanger<?, ?, ?, ?> tc, String typeChangerTypeName) {
        if (tc != null) {
            String aliasType1 = "CGMES." + typeChangerTypeName + "1";
            String aliasType2 = "CGMES." + typeChangerTypeName + "2";
            if (eq.getAliasFromType(aliasType1).isEmpty() && eq.getAliasFromType(aliasType2).isEmpty()) {
                CgmesObjectReference.Part ratioPhasePart = Objects.equals(typeChangerTypeName, "PhaseTapChanger") ? CgmesObjectReference.Part.PHASE_TAP_CHANGER : CgmesObjectReference.Part.RATIO_TAP_CHANGER;
                String newTapChangerId = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(eq), ratioPhasePart, CgmesObjectReference.ref(1));
                eq.addAlias(newTapChangerId, aliasType1);
            }
        }
    }

    private void addIidmMappingsEquivalentInjection(Network network) {
        for (DanglingLine danglingLine : network.getDanglingLines(DanglingLineFilter.ALL)) {
            String alias = danglingLine.getProperty("CGMES.EquivalentInjection");
            if (alias == null) {
                String equivalentInjectionId = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(danglingLine), CgmesObjectReference.Part.EQUIVALENT_INJECTION);
                danglingLine.setProperty("CGMES.EquivalentInjection", equivalentInjectionId);
            }
            if ((alias = danglingLine.getProperty("CGMES.EquivalentInjectionTerminal")) != null) continue;
            String equivalentInjectionTerminalId = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(danglingLine), CgmesObjectReference.Part.EQUIVALENT_INJECTION, CgmesObjectReference.Part.TERMINAL);
            danglingLine.setProperty("CGMES.EquivalentInjectionTerminal", equivalentInjectionTerminalId);
        }
    }

    private void addIidmMappingsControlArea(Network network) {
        CgmesControlAreas cgmesControlAreas = (CgmesControlAreas)network.getExtension(CgmesControlAreas.class);
        if (cgmesControlAreas == null) {
            ((CgmesControlAreasAdder)network.newExtension(CgmesControlAreasAdder.class)).add();
            cgmesControlAreas = (CgmesControlAreas)network.getExtension(CgmesControlAreas.class);
            String cgmesControlAreaId = this.namingStrategy.getCgmesId(CgmesObjectReference.refTyped(network), CgmesObjectReference.Part.CONTROL_AREA);
            cgmesControlAreas.newCgmesControlArea().setId(cgmesControlAreaId).setName("Network").setEnergyIdentificationCodeEic("Network--1").add();
            CgmesControlArea cgmesControlArea = cgmesControlAreas.getCgmesControlArea(cgmesControlAreaId);
            for (DanglingLine danglingLine : CgmesExportUtil.getBoundaryDanglingLines(network)) {
                cgmesControlArea.add(danglingLine.getTerminal());
            }
        }
    }

    public int getCimVersion() {
        return this.cim.getVersion();
    }

    public CgmesExportContext setCimVersion(int cimVersion) {
        this.cim = CgmesNamespace.getCim((int)cimVersion);
        return this;
    }

    public CgmesTopologyKind getTopologyKind() {
        return this.topologyKind;
    }

    public CgmesExportContext setTopologyKind(CgmesTopologyKind topologyKind) {
        this.topologyKind = Objects.requireNonNull(topologyKind);
        return this;
    }

    public ZonedDateTime getScenarioTime() {
        return this.scenarioTime;
    }

    public CgmesExportContext setScenarioTime(ZonedDateTime scenarioTime) {
        this.scenarioTime = Objects.requireNonNull(scenarioTime);
        return this;
    }

    public boolean exportBoundaryPowerFlows() {
        return this.exportBoundaryPowerFlows;
    }

    public CgmesExportContext setExportBoundaryPowerFlows(boolean exportBoundaryPowerFlows) {
        this.exportBoundaryPowerFlows = exportBoundaryPowerFlows;
        return this;
    }

    public boolean exportFlowsForSwitches() {
        return this.exportFlowsForSwitches;
    }

    public CgmesExportContext setExportFlowsForSwitches(boolean exportFlowsForSwitches) {
        this.exportFlowsForSwitches = exportFlowsForSwitches;
        return this;
    }

    public boolean exportTransformersWithHighestVoltageAtEnd1() {
        return this.exportTransformersWithHighestVoltageAtEnd1;
    }

    public CgmesExportContext setExportTransformersWithHighestVoltageAtEnd1(boolean exportTransformersWithHighestVoltageAtEnd1) {
        this.exportTransformersWithHighestVoltageAtEnd1 = exportTransformersWithHighestVoltageAtEnd1;
        return this;
    }

    public boolean isExportLoadFlowStatus() {
        return this.exportLoadFlowStatus;
    }

    public CgmesExportContext setExportLoadFlowStatus(boolean exportLoadFlowStatus) {
        this.exportLoadFlowStatus = exportLoadFlowStatus;
        return this;
    }

    public boolean isExportAllLimitsGroup() {
        return this.exportAllLimitsGroup;
    }

    public CgmesExportContext setExportAllLimitsGroup(boolean exportAllLimitsGroup) {
        this.exportAllLimitsGroup = exportAllLimitsGroup;
        return this;
    }

    public boolean isExportGeneratorsInLocalRegulationMode() {
        return this.exportGeneratorsInLocalRegulationMode;
    }

    public CgmesExportContext setExportGeneratorsInLocalRegulationMode(boolean exportGeneratorsInLocalRegulationMode) {
        this.exportGeneratorsInLocalRegulationMode = exportGeneratorsInLocalRegulationMode;
        return this;
    }

    public double getMaxPMismatchConverged() {
        return this.maxPMismatchConverged;
    }

    public CgmesExportContext setMaxPMismatchConverged(double maxPMismatchConverged) {
        this.maxPMismatchConverged = maxPMismatchConverged;
        return this;
    }

    public double getMaxQMismatchConverged() {
        return this.maxQMismatchConverged;
    }

    public CgmesExportContext setMaxQMismatchConverged(double maxQMismatchConverged) {
        this.maxQMismatchConverged = maxQMismatchConverged;
        return this;
    }

    public boolean isExportSvInjectionsForSlacks() {
        return this.isExportSvInjectionsForSlacks;
    }

    public CgmesExportContext setExportSvInjectionsForSlacks(boolean exportSvInjectionsForSlacks) {
        this.isExportSvInjectionsForSlacks = exportSvInjectionsForSlacks;
        return this;
    }

    public String encode(String id) {
        if (this.encodeIds) {
            return URLEncoder.encode(id, StandardCharsets.UTF_8);
        }
        return id;
    }

    public CgmesExportContext setEncodeIds(boolean encodeIds) {
        this.encodeIds = encodeIds;
        return this;
    }

    public CgmesNamespace.Cim getCim() {
        return this.cim;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public CgmesExportContext setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = Objects.requireNonNull(namingStrategy);
        return this;
    }

    public BaseVoltageMapping.BaseVoltageSource getBaseVoltageByNominalVoltage(double nominalV) {
        return this.baseVoltageByNominalVoltageMapping.get(nominalV);
    }

    public boolean writeConnectivityNodes() {
        boolean writeConnectivityNodes = this.cim.writeConnectivityNodes();
        if (!writeConnectivityNodes) {
            return this.topologyKind == CgmesTopologyKind.NODE_BREAKER;
        }
        return true;
    }

    public Collection<String> getRegionsIds() {
        return Collections.unmodifiableSet(this.regionsIdsByRegionName.values());
    }

    public String getRegionName(String regionId) {
        return (String)this.regionsIdsByRegionName.inverse().get((Object)regionId);
    }

    public String getSubRegionName(String subRegionId) {
        return (String)this.subRegionsIdsBySubRegionName.inverse().get((Object)subRegionId);
    }

    public CgmesExportContext setReportNode(ReportNode reportNode) {
        this.reportNode = reportNode;
        return this;
    }

    public ReportNode getReportNode() {
        return this.reportNode;
    }

    public void putTopologicalNode(String tn, Bus bus) {
        this.topologicalNodes.put(tn, bus);
    }

    public boolean containsTopologicalNode(String tn) {
        return this.topologicalNodes.containsKey(tn);
    }

    public Map<String, Bus> getTopologicalNodes(Network network) {
        if (this.topologicalNodes.isEmpty()) {
            return network.getBusBreakerView().getBusStream().collect(Collectors.toMap(b -> this.namingStrategy.getCgmesId((Identifiable<?>)b), b -> b));
        }
        return Collections.unmodifiableMap(this.topologicalNodes);
    }

    public String getBusinessProcess() {
        return this.businessProcess;
    }

    public CgmesExportContext setBusinessProcess(String businessProcess) {
        this.businessProcess = businessProcess;
        return this;
    }

    public String getModelingAuthoritySet() {
        return this.modelingAuthoritySet;
    }

    public CgmesExportContext setModelingAuthoritySet(String modelingAuthoritySet) {
        this.modelingAuthoritySet = modelingAuthoritySet;
        return this;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public CgmesExportContext setModelDescription(String modelDescription) {
        this.modelDescription = modelDescription;
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public CgmesExportContext setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    public String getBoundaryEqId() {
        return this.boundaryEqId;
    }

    public CgmesExportContext setBoundaryEqId(String boundaryEqId) {
        this.boundaryEqId = boundaryEqId;
        return this;
    }

    public String getBoundaryTpId() {
        return this.boundaryTpId;
    }

    public CgmesExportContext setBoundaryTpId(String boundaryTpId) {
        this.boundaryTpId = boundaryTpId;
        return this;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public CgmesExportContext setProfiles(List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public CgmesExportContext setBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    public CgmesExportContext setUpdateDependencies(boolean updateDependencies) {
        this.updateDependencies = updateDependencies;
        return this;
    }

    public boolean updateDependencies() {
        return this.updateDependencies;
    }
}

