/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.BoundaryEquipment;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgmesBoundary {
    private static final String ENERGY_IDENT_CODE_EIC_FROM_NODE = "energyIdentCodeEicFromNode";
    private static final String ENERGY_IDENT_CODE_EIC_FROM_NODE_CONTAINER = "energyIdentCodeEicFromNodeContainer";
    private final Set<String> nodes;
    private final Map<String, List<BoundaryEquipment>> nodesEquipment;
    private final Map<String, List<PropertyBag>> nodesEquivalentInjections;
    private final Map<String, PowerFlow> nodesPowerFlow;
    private final Map<String, Voltage> nodesVoltage;
    private final Map<String, String> nodesName;
    private final Map<String, String> topologicalNodes;
    private final Map<String, String> connectivityNodes;
    private final Map<String, String> lineAtNodes;
    private final Set<String> hvdcNodes;
    private static final Logger LOG = LoggerFactory.getLogger(CgmesBoundary.class);

    public CgmesBoundary(CgmesModel cgmes) {
        PropertyBags bns = cgmes.boundaryNodes();
        this.nodesName = new HashMap<String, String>();
        this.topologicalNodes = new HashMap<String, String>();
        this.connectivityNodes = new HashMap<String, String>();
        this.lineAtNodes = new HashMap<String, String>();
        this.hvdcNodes = new HashSet<String>();
        if (bns != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}{}{}", new Object[]{"CgmesBoundary nodes", System.lineSeparator(), bns.tabulateLocals()});
            }
            this.nodes = new HashSet<String>(bns.size());
            bns.forEach(node -> {
                String cn = node.getId("ConnectivityNode");
                String tn = node.getId("TopologicalNode");
                this.nodes.add(cn);
                this.nodes.add(tn);
                this.nodesName.put(cn, (String)node.get((Object)"name"));
                String tnName = (String)node.get((Object)"topologicalNodeName");
                this.nodesName.put(tn, tnName);
                this.topologicalNodes.put(tnName, tn);
                this.connectivityNodes.put(tnName, cn);
                if (CgmesBoundary.isDcNode(node)) {
                    this.hvdcNodes.add(cn);
                    this.hvdcNodes.add(tn);
                }
                if (node.containsKey((Object)ENERGY_IDENT_CODE_EIC_FROM_NODE)) {
                    this.lineAtNodes.put(cn, node.getId(ENERGY_IDENT_CODE_EIC_FROM_NODE));
                    this.lineAtNodes.put(tn, node.getId(ENERGY_IDENT_CODE_EIC_FROM_NODE));
                } else if (node.containsKey((Object)ENERGY_IDENT_CODE_EIC_FROM_NODE_CONTAINER)) {
                    this.lineAtNodes.put(cn, node.getId(ENERGY_IDENT_CODE_EIC_FROM_NODE_CONTAINER));
                    this.lineAtNodes.put(tn, node.getId(ENERGY_IDENT_CODE_EIC_FROM_NODE_CONTAINER));
                }
            });
        } else {
            this.nodes = Collections.emptySet();
        }
        this.nodesEquipment = new HashMap<String, List<BoundaryEquipment>>();
        this.nodesEquivalentInjections = new HashMap<String, List<PropertyBag>>();
        this.nodesPowerFlow = new HashMap<String, PowerFlow>();
        this.nodesVoltage = new HashMap<String, Voltage>();
    }

    public static boolean isDcNode(PropertyBag node) {
        if (node.containsKey((Object)"boundaryPointIsDirectCurrent")) {
            return Boolean.parseBoolean(node.getId("boundaryPointIsDirectCurrent"));
        }
        if (node.containsKey((Object)"description") && node.getId("description").startsWith("HVDC")) {
            return true;
        }
        return node.containsKey((Object)"topologicalNodeDescription") && node.getId("topologicalNodeDescription").startsWith("HVDC");
    }

    public boolean containsNode(String id) {
        return this.nodes.contains(id);
    }

    public boolean hasPowerFlow(String node) {
        return this.nodesPowerFlow.containsKey(node);
    }

    public PowerFlow powerFlowAtNode(String node) {
        return this.nodesPowerFlow.get(node);
    }

    public void addAcLineSegmentAtNode(PropertyBag line, String node) {
        List equipment = this.nodesEquipment.computeIfAbsent(node, ls -> new ArrayList(2));
        equipment.add(new BoundaryEquipment(BoundaryEquipment.BoundaryEquipmentType.AC_LINE_SEGMENT, line));
    }

    public void addSwitchAtNode(PropertyBag sw, String node) {
        List equipment = this.nodesEquipment.computeIfAbsent(node, ls -> new ArrayList(2));
        equipment.add(new BoundaryEquipment(BoundaryEquipment.BoundaryEquipmentType.SWITCH, sw));
    }

    public void addTransformerAtNode(PropertyBags transformerEnds, String node) {
        List equipment = this.nodesEquipment.computeIfAbsent(node, ls -> new ArrayList(2));
        equipment.add(new BoundaryEquipment(BoundaryEquipment.BoundaryEquipmentType.TRANSFORMER, transformerEnds));
    }

    public void addEquivalentBranchAtNode(PropertyBag equivalentBranch, String node) {
        List equipment = this.nodesEquipment.computeIfAbsent(node, ls -> new ArrayList(2));
        equipment.add(new BoundaryEquipment(BoundaryEquipment.BoundaryEquipmentType.EQUIVALENT_BRANCH, equivalentBranch));
    }

    public void addEquivalentInjectionAtNode(PropertyBag equivalentInjection, String node) {
        this.nodesEquivalentInjections.computeIfAbsent(node, ls -> new ArrayList(2)).add(equivalentInjection);
    }

    public void addPowerFlowAtNode(String node, PowerFlow f) {
        this.nodesPowerFlow.compute(node, (n, f0) -> f0 == null ? f : f0.sum(f));
    }

    public void addVoltageAtBoundary(String node, double v, double angle) {
        Voltage voltage = new Voltage();
        voltage.v = v;
        voltage.angle = angle;
        this.nodesVoltage.put(node, voltage);
    }

    public boolean hasVoltage(String node) {
        return this.nodesVoltage.containsKey(node);
    }

    public double vAtBoundary(String node) {
        return this.nodesVoltage.containsKey(node) ? this.nodesVoltage.get((Object)node).v : Double.NaN;
    }

    public double angleAtBoundary(String node) {
        return this.nodesVoltage.containsKey(node) ? this.nodesVoltage.get((Object)node).angle : Double.NaN;
    }

    public List<BoundaryEquipment> boundaryEquipmentAtNode(String node) {
        return this.nodesEquipment.getOrDefault(node, Collections.emptyList());
    }

    public List<PropertyBag> equivalentInjectionsAtNode(String node) {
        return this.nodesEquivalentInjections.getOrDefault(node, Collections.emptyList());
    }

    public String nameAtBoundary(String node) {
        return this.nodesName.getOrDefault(node, "XnodeCode-unknown");
    }

    public String lineAtBoundary(String node) {
        return this.lineAtNodes.get(node);
    }

    public boolean isHvdc(String node) {
        return this.hvdcNodes.contains(node);
    }

    public Collection<String> xnodesNames() {
        return this.topologicalNodes.keySet();
    }

    public String topologicalNodeAtBoundary(String xnodeName) {
        return this.topologicalNodes.get(xnodeName);
    }

    public String connectivityNodeAtBoundary(String xnodeName) {
        return this.connectivityNodes.get(xnodeName);
    }

    private static final class Voltage {
        double v;
        double angle;

        private Voltage() {
        }
    }
}

